/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import java.awt.Component;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeNode;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.util.CoreArgumentTableModel;
import org.synchronoss.cpo.util.CpoAttributeLabelNode;
import org.synchronoss.cpo.util.CpoAttributeNode;
import org.synchronoss.cpo.util.CpoUtil;

public class CpoArgumentAttributeEditor
implements TableCellEditor {
    private TableCellEditor editor = new DefaultCellEditor(new JComboBox());
    private CoreArgumentTableModel cpoFTM;

    public CpoArgumentAttributeEditor(CoreArgumentTableModel cpoFTM) {
        this.cpoFTM = cpoFTM;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JComboBox attEdBox;
        if (value instanceof CpoAttribute) {
            CpoAttribute currentCpoAtt = (CpoAttribute)value;
            try {
                CpoAttributeLabelNode attributeLabelNode = this.cpoFTM.getCpoFunctionNode().getParent().getParent().getParent().getAttributeLabelNode();
                Enumeration<TreeNode> e = attributeLabelNode.children();
                Vector<CpoAttribute> atts = new Vector<CpoAttribute>();
                while (e.hasMoreElements()) {
                    CpoAttributeNode cpoAttributeNode = (CpoAttributeNode)e.nextElement();
                    atts.add(cpoAttributeNode.getUserObject());
                }
                attEdBox = new JComboBox(atts);
                attEdBox.setSelectedItem(currentCpoAtt);
            }
            catch (Exception pe) {
                CpoUtil.showException(pe);
                attEdBox = new JComboBox();
            }
        } else {
            attEdBox = new JComboBox();
        }
        this.editor = new DefaultCellEditor(attEdBox);
        return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return this.editor.isCellEditable(anEvent);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.editor.shouldSelectCell(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        return this.editor.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.editor.cancelCellEditing();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.editor.addCellEditorListener(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.editor.removeCellEditorListener(l);
    }
}

