/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.util.CpoUtil;

public class CpoUtilClassLoader
extends ClassLoader {
    private static CpoUtilClassLoader loader;
    private static final Object LOCK;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private CpoUtilClassLoader(ClassLoader parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CpoUtilClassLoader getInstance(ClassLoader parent) {
        Object object = LOCK;
        synchronized (object) {
            if (loader == null) {
                loader = new CpoUtilClassLoader(parent);
            }
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadLoader() {
        Object object = LOCK;
        synchronized (object) {
            loader = null;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> c;
        try {
            byte[] data = this.loadClassData(name);
            c = this.defineClass(name, data, 0, data.length);
            if (c == null) {
                throw new ClassNotFoundException(name);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("loaded class: " + name);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
            throw new ClassNotFoundException("Error reading class: " + name, e);
        }
        return c;
    }

    private byte[] loadClassData(String name) throws IOException {
        for (File file : CpoUtil.getInstance().getCustomClasspathEntries()) {
            String filename;
            if (file.isFile()) {
                if (!file.getName().toLowerCase().endsWith(".jar")) continue;
                filename = name.replace('.', '/') + ".class";
                JarFile jf = new JarFile(file);
                Enumeration<JarEntry> e = jf.entries();
                while (e.hasMoreElements()) {
                    int incr;
                    ZipEntry entry = e.nextElement();
                    if (!filename.equals(entry.getName())) continue;
                    InputStream is = jf.getInputStream(entry);
                    int l = (int)entry.getSize();
                    byte[] buff = new byte[l];
                    for (int read = 0; read < l; read += incr) {
                        incr = is.read(buff, read, l - read);
                    }
                    return buff;
                }
                continue;
            }
            if (!file.isDirectory()) continue;
            filename = name.replace('.', File.separatorChar) + ".class";
            File f = new File(file, filename);
            int size = (int)f.length();
            byte[] buff = new byte[size];
            FileInputStream fis = new FileInputStream(f);
            DataInputStream dis = new DataInputStream(fis);
            dis.readFully(buff);
            dis.close();
            return buff;
        }
        throw new IOException("Could not find class");
    }

    static {
        LOCK = new Object();
    }
}

