/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpoUtilClasspathPanel
extends JPanel {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    private JList jListClasspath = new JList();
    private Vector<File> classpathEntries = new Vector();

    public CpoUtilClasspathPanel(List<File> classpathEntries) {
        this.classpathEntries.addAll(classpathEntries);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JLabel jLabClasspath = new JLabel("Currently in Classpath");
        this.add((Component)jLabClasspath, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jListClasspath.setListData(this.classpathEntries);
        JScrollPane jScroll = new JScrollPane();
        jScroll.getViewport().add(this.jListClasspath);
        this.add((Component)jScroll, new GridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JButton jButAddClasspath = new JButton("Add");
        jButAddClasspath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CpoUtilClasspathPanel.this.addFile();
            }
        });
        this.add((Component)jButAddClasspath, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        JButton jButRemove = new JButton("Remove");
        jButRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CpoUtilClasspathPanel.this.removeFile();
            }
        });
        this.add((Component)jButRemove, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void addFile() {
        JFileChooser jFile = new JFileChooser();
        jFile.setMultiSelectionEnabled(true);
        jFile.setFileSelectionMode(2);
        int result = jFile.showOpenDialog(this);
        if (result == 1) {
            return;
        }
        this.classpathEntries.addAll(Arrays.asList(jFile.getSelectedFiles()));
        this.jListClasspath.setListData(this.classpathEntries);
    }

    private void removeFile() {
        Object[] selectedFiles;
        for (Object selectedFile : selectedFiles = this.jListClasspath.getSelectedValues()) {
            this.classpathEntries.remove((File)selectedFile);
        }
        this.jListClasspath.setListData(this.classpathEntries);
    }

    public List<File> getClasspathEntries() {
        return this.classpathEntries;
    }
}

