/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.util.CpoAttributeNode;
import org.synchronoss.cpo.util.CpoClassNode;

public class TesterResultsModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private Collection<?> results;
    private String[] columnNames;
    private CpoClassNode cpoClassNode;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public TesterResultsModel(Collection<?> results, CpoClassNode cpoClassNode) {
        this.results = results;
        this.cpoClassNode = cpoClassNode;
    }

    @Override
    public int getRowCount() {
        return this.results.size();
    }

    @Override
    public int getColumnCount() {
        return this.cpoClassNode.getChildCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (this.columnNames != null) {
            return this.columnNames[columnIndex];
        }
        this.columnNames = new String[this.getColumnCount()];
        int columnCounter = 0;
        Enumeration<TreeNode> e = this.cpoClassNode.getAttributeLabelNode().children();
        while (e.hasMoreElements()) {
            CpoAttributeNode camn = (CpoAttributeNode)e.nextElement();
            this.columnNames[columnCounter] = camn.getJavaName();
            ++columnCounter;
        }
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int row = 0;
        String columnName = this.getColumnName(columnIndex);
        String methodName = "get" + columnName.substring(0, 1).toUpperCase() + columnName.substring(1);
        Object rowObj = null;
        for (Object obj : this.results) {
            if (row == rowIndex) {
                rowObj = obj;
                for (Method method : rowObj.getClass().getMethods()) {
                    if (!method.getName().equals(methodName) || method.getParameterTypes().length != 0) continue;
                    try {
                        Object returnObj = method.invoke(rowObj, new Object[0]);
                        return returnObj == null ? "" : returnObj.toString();
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), e);
                        return e.getMessage();
                    }
                }
            }
            ++row;
        }
        this.logger.debug("Did not find column/row you are looking for - trying to return toString!");
        return rowObj == null ? "" : rowObj.toString();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }
}

