/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util.jdbc;

import java.util.Arrays;
import java.util.List;
import org.synchronoss.cpo.util.CoreAttributeTableModel;
import org.synchronoss.cpo.util.CpoAttributeLabelNode;
import org.synchronoss.cpo.util.CpoAttributeNode;
import org.synchronoss.cpo.util.jdbc.JdbcAttributeNode;

public class JdbcAttributeTableModel
extends CoreAttributeTableModel {
    public JdbcAttributeTableModel(CpoAttributeLabelNode cpoAttLabNode) {
        super(cpoAttLabNode);
    }

    @Override
    public List<String> getColumnNames() {
        return Arrays.asList("Attribute", "Data Name", "Data Type", "DB Table", "DB Column", "Transform Class", "Modified?");
    }

    @Override
    public List<Class<?>> getColumnClasses() {
        Class[] columnClasses = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class};
        return Arrays.asList(columnClasses);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex < 6;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        CpoAttributeNode cpoAttributeNode = (CpoAttributeNode)this.cpoAttLabNode.getChildAt(rowIndex);
        if (!(cpoAttributeNode instanceof JdbcAttributeNode)) {
            return null;
        }
        JdbcAttributeNode jdbcAttributeNode = (JdbcAttributeNode)cpoAttributeNode;
        if (columnIndex == 0) {
            return jdbcAttributeNode.getJavaName();
        }
        if (columnIndex == 1) {
            return jdbcAttributeNode.getDataName();
        }
        if (columnIndex == 2) {
            return jdbcAttributeNode.getDataType();
        }
        if (columnIndex == 3) {
            return jdbcAttributeNode.getDbTable();
        }
        if (columnIndex == 4) {
            return jdbcAttributeNode.getDbColumn();
        }
        if (columnIndex == 5) {
            return jdbcAttributeNode.getTransformClassName();
        }
        if (columnIndex == 6) {
            if (cpoAttributeNode.isRemove()) {
                return "Removed";
            }
            if (cpoAttributeNode.isNew()) {
                return "New";
            }
            if (cpoAttributeNode.isDirty()) {
                return "Changed";
            }
            return "";
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        CpoAttributeNode cpoAttributeNode = (CpoAttributeNode)this.cpoAttLabNode.getChildAt(rowIndex);
        if (!(cpoAttributeNode instanceof JdbcAttributeNode)) {
            return;
        }
        JdbcAttributeNode jdbcAttributeNode = (JdbcAttributeNode)cpoAttributeNode;
        String val = aValue.toString();
        if (columnIndex == 0) {
            jdbcAttributeNode.setAttribute(val);
        } else if (columnIndex == 1) {
            jdbcAttributeNode.setDataName(val);
        } else if (columnIndex == 2) {
            jdbcAttributeNode.setDataType(val);
        } else if (columnIndex == 3) {
            jdbcAttributeNode.setDbTable(val);
        } else if (columnIndex == 4) {
            jdbcAttributeNode.setDbColumn(val);
        } else if (columnIndex == 5) {
            jdbcAttributeNode.setTransformClass(val);
        }
        this.fireTableDataChanged();
    }
}

