/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util.jdbc;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoAdapter;
import org.synchronoss.cpo.CpoAdapterFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.core.cpoCoreConfig.CtDataSourceConfig;
import org.synchronoss.cpo.jdbc.cpoJdbcConfig.CtJdbcConfig;
import org.synchronoss.cpo.jdbc.cpoJdbcConfig.CtJdbcReadWriteConfig;
import org.synchronoss.cpo.jdbc.cpoJdbcConfig.CtProperty;
import org.synchronoss.cpo.util.AbstractConnectionPanel;
import org.synchronoss.cpo.util.CpoUtil;

public class JdbcConnectionPanel
extends AbstractConnectionPanel {
    private static final long serialVersionUID = 1L;
    private static final String CONFIG_PROCESSOR = "org.synchronoss.cpo.jdbc.config.JdbcCpoConfigProcessor";
    private static final String PARAM_DELIM = ";";
    private static final String PARAM_ASSIGNMENT = "=";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private JTextField jTextName = new JTextField();
    private JTextField jTextUserName = new JTextField();
    private JPasswordField jTextPassword = new JPasswordField();
    private JTextField jTextUrl = new JTextField();
    private JTextField jTextDriver = new JTextField();
    private JTextArea jTextAreaParams = new JTextArea();

    public JdbcConnectionPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    public CtJdbcConfig newDataSourceConfig() {
        return CtJdbcConfig.Factory.newInstance();
    }

    @Override
    public String getTitle() {
        return "Jdbc Connection";
    }

    @Override
    protected String getConfigProcessor() {
        return CONFIG_PROCESSOR;
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(450, 275));
        JLabel jLabCpoUtilName = new JLabel("Connection Name:");
        this.add((Component)jLabCpoUtilName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jTextName.setText("MyNewConnection");
        this.add((Component)this.jTextName, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        JLabel jLabelUserName = new JLabel("User Name:");
        this.add((Component)jLabelUserName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.jTextUserName, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        JLabel jLabelPassword = new JLabel("Password:");
        this.add((Component)jLabelPassword, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.jTextPassword, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        JLabel jLabelUrl = new JLabel("URL:");
        this.add((Component)jLabelUrl, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jTextUrl.setText("jdbc:oracle:thin:@[HOSTNAME]:1521:[INSTANCE]");
        this.add((Component)this.jTextUrl, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        JLabel jLabJdbcDriver = new JLabel("Driver:");
        this.add((Component)jLabJdbcDriver, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jTextDriver.setText("oracle.jdbc.OracleDriver");
        this.add((Component)this.jTextDriver, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        JButton testConnectionButton = new JButton("Test");
        testConnectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JdbcConnectionPanel.this.testConnectionButtonActionPerformed();
            }
        });
        this.add((Component)testConnectionButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        JLabel jLabJdbcParams = new JLabel("Jdbc Params:");
        this.add((Component)jLabJdbcParams, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        JScrollPane jScrollParams = new JScrollPane();
        jScrollParams.setPreferredSize(new Dimension(300, 100));
        jScrollParams.setMinimumSize(new Dimension(300, 100));
        jScrollParams.getViewport().add((Component)this.jTextAreaParams, null);
        this.add((Component)jScrollParams, new GridBagConstraints(1, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
    }

    public CtJdbcConfig getDataSourceConfig() {
        return (CtJdbcConfig)super.getDataSourceConfig();
    }

    private void testConnectionButtonActionPerformed() {
        try {
            CtDataSourceConfig dataSourceConfig = this.createDataSourceConfig();
            CpoAdapter cpoAdapter = CpoAdapterFactory.makeCpoAdapter((CtDataSourceConfig)dataSourceConfig);
            if (cpoAdapter != null) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Connection successful", "Test Connection", 1);
            }
        }
        catch (CpoException ex) {
            CpoUtil.showErrorMessage(ex.getMessage());
        }
    }

    @Override
    public void setDataSourceConfig(CtDataSourceConfig dataSourceConfig) {
        super.setDataSourceConfig(dataSourceConfig);
        CtJdbcConfig jdbcConfig = (CtJdbcConfig)dataSourceConfig;
        this.jTextName.setText(jdbcConfig.getName());
        if (jdbcConfig.isSetReadWriteConfig()) {
            CtJdbcReadWriteConfig rwc = jdbcConfig.getReadWriteConfig();
            this.jTextUserName.setText(rwc.getUser());
            this.jTextPassword.setText(rwc.getPassword());
            this.jTextUrl.setText(rwc.getUrl());
            if (rwc.isSetDriverClassName()) {
                this.jTextDriver.setText(rwc.getDriverClassName());
            }
            StringBuilder params = new StringBuilder();
            for (CtProperty prop : rwc.getPropertyArray()) {
                params.append(prop.getName());
                params.append(PARAM_ASSIGNMENT);
                params.append(prop.getValue());
                params.append(PARAM_DELIM);
            }
            this.jTextAreaParams.setText(params.toString());
        }
    }

    @Override
    public CtDataSourceConfig createDataSourceConfig() throws CpoException {
        String connectionName = this.jTextName.getText();
        String userName = this.jTextUserName.getText();
        String password = new String(this.jTextPassword.getPassword());
        String url = this.jTextUrl.getText();
        String driver = this.jTextDriver.getText();
        String params = this.jTextAreaParams.getText();
        if (connectionName == null || connectionName.isEmpty()) {
            throw new CpoException("Connection name must be provided");
        }
        CtJdbcConfig myConfig = this.getDataSourceConfig();
        CtDataSourceConfig dupe = CpoUtil.getInstance().getDataSourceConfig(connectionName);
        if (dupe != null && !dupe.equals(myConfig)) {
            throw new CpoException("Another connection is using the name: " + connectionName + "\n\nConnection names must be unique");
        }
        if (userName == null || userName.isEmpty()) {
            throw new CpoException("A user name must be provided");
        }
        if (password.isEmpty()) {
            throw new CpoException("A password must be provided");
        }
        if (url == null || url.isEmpty()) {
            throw new CpoException("A url must be provided");
        }
        if (driver == null || driver.isEmpty()) {
            throw new CpoException("A driver must be provided");
        }
        CtJdbcConfig jdbcConfig = this.newDataSourceConfig();
        jdbcConfig.setName(connectionName);
        if (myConfig != null && myConfig.getMetaDescriptorName() != null) {
            jdbcConfig.setMetaDescriptorName(myConfig.getMetaDescriptorName());
        } else {
            jdbcConfig.setMetaDescriptorName("cpoutil");
        }
        jdbcConfig.setCpoConfigProcessor(this.getConfigProcessor());
        CtJdbcReadWriteConfig rwc = jdbcConfig.addNewReadWriteConfig();
        rwc.setUser(userName);
        rwc.setPassword(password);
        rwc.setUrl(url);
        rwc.setDriverClassName(driver);
        if (params != null && !params.isEmpty()) {
            StringTokenizer st = new StringTokenizer(params, PARAM_DELIM);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                StringTokenizer stNameValue = new StringTokenizer(token, PARAM_ASSIGNMENT);
                String name = null;
                String value = null;
                if (stNameValue.hasMoreTokens()) {
                    name = stNameValue.nextToken();
                }
                if (stNameValue.hasMoreTokens()) {
                    value = stNameValue.nextToken();
                }
                CtProperty prop = rwc.addNewProperty();
                prop.setName(name);
                prop.setValue(value);
            }
        }
        return jdbcConfig;
    }
}

