/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.util.CpoArgumentNode;
import org.synchronoss.cpo.util.CpoFunctionGroupNode;
import org.synchronoss.cpo.util.CpoFunctionNode;

public class TesterParamModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private String[] columnNames = new String[]{"Function Seq Num", "Argument Seq Num", "Data Name", "Attribute Name", "Parameter"};
    private Object[] columnClasses = new Object[]{Integer.class, String.class, String.class, String.class, String.class};
    private CpoFunctionGroupNode cpoFGnode;
    private Hashtable<Object, Object> parameterMap = new Hashtable();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public TesterParamModel(CpoFunctionGroupNode cpoQGnode) {
        this.cpoFGnode = cpoQGnode;
    }

    @Override
    public int getRowCount() {
        int rowCount = 0;
        Enumeration<TreeNode> enumQueries = this.cpoFGnode.children();
        while (enumQueries.hasMoreElements()) {
            CpoFunctionNode node = (CpoFunctionNode)enumQueries.nextElement();
            rowCount += node.getChildCount();
        }
        return rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return (Class)this.columnClasses[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 4;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int rowCount = 0;
        Enumeration<TreeNode> enumQueries = this.cpoFGnode.children();
        while (enumQueries.hasMoreElements()) {
            CpoFunctionNode node = (CpoFunctionNode)enumQueries.nextElement();
            Enumeration<TreeNode> enumArguments = node.children();
            while (enumArguments.hasMoreElements()) {
                CpoArgumentNode argumentNode = (CpoArgumentNode)enumArguments.nextElement();
                if (rowCount == rowIndex) {
                    if (columnIndex == 0) {
                        return node.getSeqNo();
                    }
                    if (columnIndex == 1) {
                        return argumentNode.getSeqNo();
                    }
                    if (columnIndex == 2) {
                        return argumentNode.getUserObject().getAttribute().getDataName();
                    }
                    if (columnIndex == 3) {
                        return argumentNode.getUserObject().getAttribute().getJavaName();
                    }
                    if (columnIndex == 4) {
                        CpoAttribute attribute = argumentNode.getUserObject().getAttribute();
                        return this.parameterMap.get(attribute != null ? attribute.getJavaName() : "");
                    }
                }
                ++rowCount;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 4) {
            this.logger.debug(this.getValueAt(rowIndex, 3) + " : " + aValue);
            if (aValue == null) {
                this.parameterMap.remove(this.getValueAt(rowIndex, 3));
            }
            this.parameterMap.put(this.getValueAt(rowIndex, 3), aValue);
            this.fireTableDataChanged();
        }
    }

    protected boolean isTableFilledOut() {
        int rows = this.getRowCount();
        for (int i = 0; i < rows; ++i) {
            if (this.getValueAt(i, 4) != null && !this.getValueAt(i, 4).equals("")) continue;
            return false;
        }
        return true;
    }

    public Hashtable<Object, Object> getParameterMap() {
        return this.parameterMap;
    }
}

