/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.util.AbstractCpoNode;
import org.synchronoss.cpo.util.CpoAttributeLabelNode;
import org.synchronoss.cpo.util.CpoBrowserPanel;
import org.synchronoss.cpo.util.CpoClassNode;
import org.synchronoss.cpo.util.CpoFunctionGroupLabelNode;
import org.synchronoss.cpo.util.CpoFunctionGroupNode;
import org.synchronoss.cpo.util.CpoFunctionNode;
import org.synchronoss.cpo.util.CpoNewClassClassPanel;
import org.synchronoss.cpo.util.CpoNewClassPanel;
import org.synchronoss.cpo.util.CpoRootNode;
import org.synchronoss.cpo.util.CpoUtil;
import org.synchronoss.cpo.util.FunctionGroupPanel;
import org.synchronoss.cpo.util.Proxy;
import org.synchronoss.cpo.util.ProxyFactory;
import org.synchronoss.cpo.util.SaveNodesPanel;

public class CpoBrowserTree
extends JTree {
    private static final long serialVersionUID = 1L;
    private JPopupMenu menu;
    private static ImageIcon iconRed = new ImageIcon(CpoBrowserTree.class.getResource("/images/red.gif"));
    private static ImageIcon iconYellow = new ImageIcon(CpoBrowserTree.class.getResource("/images/yellow.gif"));
    private static ImageIcon iconGreen = new ImageIcon(CpoBrowserTree.class.getResource("/images/green.gif"));
    private static ImageIcon iconBlue = new ImageIcon(CpoBrowserTree.class.getResource("/images/blue.gif"));
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CpoBrowserTree() {
        DefaultTreeSelectionModel treeSelectionModel = new DefaultTreeSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        this.setSelectionModel(treeSelectionModel);
        this.setCellRenderer(new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                this.setText(value.toString());
                if (value instanceof AbstractCpoNode) {
                    AbstractCpoNode node = (AbstractCpoNode)value;
                    if (node.isDirty() || node.isRemove() || node.isNew()) {
                        this.setIcon(iconRed);
                    } else if (node.isChildDirty() || node.isChildRemove() || node.isChildNew()) {
                        this.setIcon(iconYellow);
                    } else if (node.isProtected()) {
                        this.setIcon(iconBlue);
                    } else {
                        this.setIcon(iconGreen);
                    }
                }
                if (hasFocus || sel) {
                    this.setForeground(Color.red);
                } else {
                    this.setForeground(Color.blue);
                }
                return this;
            }
        });
        this.menu = new JPopupMenu();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    CpoBrowserTree.this.showMenu(e.getPoint());
                }
            }
        });
    }

    @Override
    public DefaultTreeModel getModel() {
        return (DefaultTreeModel)super.getModel();
    }

    protected CpoRootNode getRoot() {
        return (CpoRootNode)this.getModel().getRoot();
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        if (path != null && path.getLastPathComponent() instanceof AbstractCpoNode) {
            AbstractCpoNode node = (AbstractCpoNode)path.getLastPathComponent();
            return node.getToolTipText();
        }
        return null;
    }

    private void showMenu(Point p) {
        TreePath path = this.getPathForLocation((int)p.getX(), (int)p.getY());
        if (path != null) {
            TreeNode node = (TreeNode)path.getLastPathComponent();
            this.buildMenu(node);
            this.menu.show(this, (int)p.getX(), (int)p.getY());
        }
    }

    private void buildMenu(TreeNode node) {
        CpoUtil.getInstance().setStatusBarText("");
        this.menu.removeAll();
        this.menu.setLabel("");
        if (node instanceof AbstractCpoNode) {
            final AbstractCpoNode menuNode = (AbstractCpoNode)node;
            this.menu.setLabel(menuNode.toString());
            if (menuNode instanceof CpoRootNode) {
                if (menuNode.isChildDirty() || menuNode.isChildNew() || menuNode.isChildRemove()) {
                    JMenuItem jMenuCommitChildren = new JMenuItem("Save Changes");
                    jMenuCommitChildren.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            CpoBrowserTree.this.save(null);
                        }
                    });
                    this.menu.add(jMenuCommitChildren);
                }
                JMenuItem jMenuFqdnToggle = new JMenuItem("Toggle Classnames");
                jMenuFqdnToggle.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        CpoBrowserTree.this.toggleClassnames();
                    }
                });
                this.menu.add(jMenuFqdnToggle);
                JMenuItem jMenuAddClass = new JMenuItem("Add new Class");
                jMenuAddClass.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        CpoBrowserTree.this.createNewCpoClass();
                    }
                });
                this.menu.add(jMenuAddClass);
                JMenuItem jMenuAddClassFromClass = new JMenuItem("Add new Class from .class");
                jMenuAddClassFromClass.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        CpoBrowserTree.this.createNewCpoClassFromClass();
                    }
                });
                this.menu.add(jMenuAddClassFromClass);
                JMenuItem jMenuRefresh = new JMenuItem("Reload Config");
                jMenuRefresh.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        CpoBrowserTree.this.refreshFromXml(null);
                    }
                });
                this.menu.add(jMenuRefresh);
            } else if (menuNode instanceof CpoClassNode) {
                final CpoClassNode cpoClassNode = (CpoClassNode)menuNode;
                JMenuItem jMenuRename = new JMenuItem("Rename Class");
                jMenuRename.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        CpoBrowserTree.this.renameCpoClassNode(cpoClassNode);
                    }
                });
                this.menu.add(jMenuRename);
                JMenuItem jMenuGenerateClass = new JMenuItem("Generate Class Source");
                jMenuGenerateClass.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        CpoBrowserTree.this.generateClassSource(cpoClassNode);
                    }
                });
                this.menu.add(jMenuGenerateClass);
            } else if (menuNode instanceof CpoFunctionGroupLabelNode) {
                JMenuItem jMenuAddGroup = new JMenuItem("Add Function Group to Class");
                jMenuAddGroup.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        CpoBrowserTree.this.addFunctionGroup((CpoFunctionGroupLabelNode)menuNode);
                    }
                });
                this.menu.add(jMenuAddGroup);
            } else if (menuNode instanceof CpoFunctionGroupNode) {
                final CpoFunctionGroupNode cpoFunctionGroupNode = (CpoFunctionGroupNode)menuNode;
                JMenuItem jMenuAddFunction = new JMenuItem("Add Function to Group");
                jMenuAddFunction.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        CpoBrowserTree.this.addFunctionToGroup(cpoFunctionGroupNode);
                    }
                });
                this.menu.add(jMenuAddFunction);
                JMenuItem jMenuRenameFG = new JMenuItem("Rename Function Group");
                jMenuRenameFG.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        CpoBrowserTree.this.renameFunctionGroup(cpoFunctionGroupNode);
                    }
                });
                this.menu.add(jMenuRenameFG);
            } else if (menuNode instanceof CpoFunctionNode) {
                final CpoFunctionNode functionNode = (CpoFunctionNode)menuNode;
                JMenuItem jMenuMoveUp = new JMenuItem("Move Up");
                jMenuMoveUp.setEnabled(functionNode.getSeqNo() > 1);
                jMenuMoveUp.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        CpoBrowserTree.this.moveFunctionUp(functionNode);
                    }
                });
                this.menu.add(jMenuMoveUp);
                JMenuItem jMenuMoveDown = new JMenuItem("Move Down");
                jMenuMoveDown.setEnabled(functionNode.getSeqNo() < functionNode.getParent().getChildCount());
                jMenuMoveDown.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        CpoBrowserTree.this.moveFunctionDown(functionNode);
                    }
                });
                this.menu.add(jMenuMoveDown);
            }
            if (!(menuNode instanceof CpoRootNode || menuNode instanceof CpoAttributeLabelNode || menuNode instanceof CpoFunctionGroupLabelNode)) {
                JMenuItem jMenuRemove = new JMenuItem("Remove this object!");
                jMenuRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        menuNode.setRemove(true);
                    }
                });
                this.menu.add(jMenuRemove);
            }
        }
    }

    private void addFunctionGroup(CpoFunctionGroupLabelNode functionGroupLabelNode) {
        FunctionGroupPanel fgp = new FunctionGroupPanel();
        int result = JOptionPane.showConfirmDialog(this.getTopLevelAncestor(), fgp, "Create new Function Group", 2);
        if (result == 0) {
            try {
                String groupName;
                Proxy proxy = this.getRoot().getProxy();
                String string = groupName = fgp.getGroupName().equals("") ? null : fgp.getGroupName();
                if (functionGroupLabelNode.getParent().getUserObject().existsFunctionGroup(fgp.getGroupType(), groupName)) {
                    CpoUtil.showErrorMessage("A function group with that type and name already exists for this class: " + fgp.getGroupType() + " - " + groupName);
                    return;
                }
                CpoFunctionGroupNode cpoFunctionGroupNode = proxy.addFunctionGroup(functionGroupLabelNode.getParent(), groupName, fgp.getGroupType());
                this.addFunctionToGroup(cpoFunctionGroupNode);
            }
            catch (CpoException ex) {
                CpoUtil.showException(ex);
            }
        }
    }

    private void addFunctionToGroup(CpoFunctionGroupNode cpoFunctionGroupNode) {
        try {
            Proxy proxy = this.getRoot().getProxy();
            CpoFunctionNode cpoFunctionNode = proxy.addFunction(cpoFunctionGroupNode);
            DefaultTreeModel model = this.getModel();
            this.expandPath(new TreePath(model.getPathToRoot(cpoFunctionGroupNode)));
            this.setSelectionPath(new TreePath(cpoFunctionNode));
        }
        catch (CpoException ex) {
            CpoUtil.showException(ex);
        }
    }

    protected void save(File file) {
        CpoRootNode rootNode = this.getRoot();
        SaveNodesPanel saveNodesPanel = new SaveNodesPanel(rootNode);
        int result = JOptionPane.showConfirmDialog(this.getTopLevelAncestor(), saveNodesPanel, "Save Objects", 2);
        if (result == 0) {
            try {
                rootNode.getProxy().save(file);
                this.refreshFromXml(file);
                CpoUtil.getInstance().setStatusBarText("Xml saved successfully");
            }
            catch (Exception pe) {
                CpoUtil.showException(pe);
            }
        }
    }

    protected void refreshFromXml(File file) {
        int idx = -1;
        for (Container parent = this.getParent(); idx == -1 && parent != null; parent = parent.getParent()) {
            if (!(parent instanceof CpoBrowserPanel)) continue;
            idx = CpoUtil.getInstance().jTabbedPane.indexOfComponent(parent);
        }
        if (idx == -1) {
            CpoUtil.showErrorMessage("Unable to refresh");
            return;
        }
        if (CpoUtil.getInstance().checkUnsavedData("There is unsaved data, are you sure you wish to refresh over it??", idx)) {
            return;
        }
        Proxy proxy = this.getRoot().getProxy();
        try {
            ProxyFactory.getInstance().refreshMetaDescriptor(proxy, file);
            this.setModel(proxy.createTreeModel());
            this.sortClasses();
            TreePath tp = new TreePath(this.getModel().getRoot());
            this.setSelectionPath(tp);
            CpoUtil.getInstance().setStatusBarText("Reloaded " + proxy);
        }
        catch (CpoException ex) {
            CpoUtil.showException(ex);
        }
    }

    private void createNewCpoClassFromClass() {
        this.logger.debug("creating new class from class");
        Proxy proxy = this.getRoot().getProxy();
        String className = null;
        List<CpoAttribute> attributes = new ArrayList<CpoAttribute>();
        boolean happy = false;
        while (!happy) {
            CpoNewClassClassPanel cnccp = new CpoNewClassClassPanel(proxy);
            int result = JOptionPane.showConfirmDialog(this.getTopLevelAncestor(), cnccp, "Create new CPO Class from Class", 2);
            if (result == 0) {
                try {
                    className = cnccp.getClassName();
                    attributes = proxy.createAttributesFromClass(className);
                    happy = true;
                }
                catch (Exception pe) {
                    CpoUtil.showException(pe);
                }
                continue;
            }
            CpoUtil.getInstance().setStatusBarText("Aborted Class Creation");
            return;
        }
        this.createNewClass(className, attributes, false);
    }

    private void createNewCpoClass() {
        this.logger.debug("creating new class");
        Proxy proxy = this.getRoot().getProxy();
        String className = null;
        List<CpoAttribute> attributes = new ArrayList<CpoAttribute>();
        boolean generateClassSource = false;
        boolean happy = false;
        while (!happy) {
            CpoNewClassPanel cncp = new CpoNewClassPanel(proxy);
            int result = JOptionPane.showConfirmDialog(this.getTopLevelAncestor(), cncp, "Create new CPO Class", 2);
            if (result == 0) {
                try {
                    className = cncp.getClassName();
                    attributes = proxy.createAttributesFromExpression(cncp.getConnection(), cncp.getExpression());
                    generateClassSource = cncp.isGenerateSource();
                    happy = true;
                }
                catch (Exception pe) {
                    CpoUtil.showException(pe);
                }
                continue;
            }
            CpoUtil.getInstance().setStatusBarText("Aborted Class Creation");
            return;
        }
        this.createNewClass(className, attributes, generateClassSource);
    }

    private void createNewClass(String className, List<CpoAttribute> attributes, boolean generateClassSource) {
        try {
            Proxy proxy = this.getRoot().getProxy();
            CpoClassNode cpoClassNode = proxy.addClass(className);
            proxy.addAttributes(cpoClassNode, attributes);
            if (generateClassSource) {
                this.saveClassSource(cpoClassNode);
            }
            DefaultTreeModel model = this.getModel();
            this.expandPath(new TreePath(model.getPathToRoot(cpoClassNode)));
            this.setSelectionPath(new TreePath(cpoClassNode));
            CpoUtil.getInstance().setStatusBarText("Class (" + cpoClassNode.getUserObject().getClass().getName() + ") successfully created");
        }
        catch (Exception pe) {
            CpoUtil.showException(pe);
        }
    }

    private void saveClassSource(CpoClassNode cpoClassNode) {
        String className;
        Proxy proxy = this.getRoot().getProxy();
        String saveClassName = className = cpoClassNode.getUserObject().getName();
        if (className.contains(".")) {
            saveClassName = className.substring(className.lastIndexOf(".") + 1);
        }
        JFileChooser jFile = new JFileChooser();
        if (proxy.getLastDir() != null) {
            jFile.setCurrentDirectory(proxy.getLastDir());
        }
        jFile.setDialogTitle("Choose a directory to save: " + saveClassName + ".java");
        jFile.setFileSelectionMode(1);
        int result = jFile.showSaveDialog(this.getTopLevelAncestor());
        if (result != 0 || jFile.getSelectedFile() == null) {
            CpoUtil.getInstance().setStatusBarText("Aborted Class Creation: file not saved");
            return;
        }
        proxy.setLastDir(jFile.getCurrentDirectory());
        try {
            FileWriter fw = new FileWriter(jFile.getSelectedFile() + File.separator + saveClassName + ".java");
            fw.write(proxy.generateSourceCode(cpoClassNode));
            fw.close();
        }
        catch (IOException ioe) {
            CpoUtil.showException(ioe);
            CpoUtil.getInstance().setStatusBarText("Class not created: exception caught during save: " + ioe.getMessage());
            return;
        }
        CpoUtil.getInstance().setStatusBarText("Class (" + className + ") successfully saved");
    }

    private void renameFunctionGroup(CpoFunctionGroupNode cpoFunctionGroupNode) {
        String result = (String)JOptionPane.showInputDialog(this.getTopLevelAncestor(), "Enter new group name", "Edit Group Name", 1, null, null, cpoFunctionGroupNode.getGroupName());
        if (result == null) {
            return;
        }
        if (result.equals("")) {
            result = null;
        }
        cpoFunctionGroupNode.setGroupName(result);
        CpoUtil.getInstance().setStatusBarText("Changed Group Name to: " + result);
    }

    public void toggleClassnames() {
        CpoRootNode rootNode = this.getRoot();
        rootNode.getProxy().toggleClassNames();
        this.sortClasses();
    }

    private void sortClasses() {
        CpoRootNode rootNode = this.getRoot();
        ArrayList<CpoClassNode> nodes = new ArrayList<CpoClassNode>();
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            CpoClassNode node = (CpoClassNode)rootNode.getChildAt(i);
            nodes.add(node);
        }
        Collections.sort(nodes);
        rootNode.removeAllChildren();
        for (CpoClassNode node : nodes) {
            rootNode.add(node);
        }
        this.getModel().nodeStructureChanged(rootNode);
    }

    private void renameCpoClassNode(CpoClassNode cpoClassNode) {
        String result = (String)JOptionPane.showInputDialog(this.getTopLevelAncestor(), "Enter new class name", "Edit Class Name", 1, null, null, cpoClassNode.getUserObject().getName());
        if (result == null) {
            return;
        }
        if (result.equals("")) {
            result = null;
        }
        cpoClassNode.setClassName(result);
        CpoUtil.getInstance().setStatusBarText("Changed Class Name to: " + result);
    }

    private void generateClassSource(CpoClassNode cpoClassNode) {
        try {
            this.saveClassSource(cpoClassNode);
        }
        catch (Exception e) {
            CpoUtil.showException(e);
        }
    }

    private void moveFunctionUp(CpoFunctionNode functionNode) {
        functionNode.getProxy().moveFunctionUp(functionNode);
    }

    private void moveFunctionDown(CpoFunctionNode functionNode) {
        functionNode.getProxy().moveFunctionDown(functionNode);
    }
}

