/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.meta.domain.CpoClass;
import org.synchronoss.cpo.util.AbstractCpoNode;
import org.synchronoss.cpo.util.CpoAttributeLabelNode;
import org.synchronoss.cpo.util.CpoAttributeNode;
import org.synchronoss.cpo.util.CpoFunctionGroupLabelNode;
import org.synchronoss.cpo.util.CpoRootNode;
import org.synchronoss.cpo.util.TesterPanel;

public class CpoClassNode
extends AbstractCpoNode
implements Comparable<CpoClassNode> {
    public CpoClassNode(CpoClass cpoClass) {
        super(cpoClass);
        this.createLabelNodes();
    }

    protected void createLabelNodes() {
        this.add(new CpoAttributeLabelNode());
        this.add(new CpoFunctionGroupLabelNode());
    }

    public CpoClass getUserObject() {
        return (CpoClass)super.getUserObject();
    }

    @Override
    public CpoRootNode getParent() {
        return (CpoRootNode)super.getParent();
    }

    @Override
    public JPanel getPanelForSelected() {
        return new TesterPanel(this);
    }

    public CpoAttributeLabelNode getAttributeLabelNode() {
        return (CpoAttributeLabelNode)this.getChildAt(0);
    }

    public CpoFunctionGroupLabelNode getFunctionGroupLabelNode() {
        return (CpoFunctionGroupLabelNode)this.getChildAt(1);
    }

    public boolean attributeExists(String name) {
        Enumeration<TreeNode> e = this.getAttributeLabelNode().children();
        while (e.hasMoreElements()) {
            CpoAttributeNode cpoAttributeNode = (CpoAttributeNode)e.nextElement();
            if (!cpoAttributeNode.getJavaName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getDisplayClassName();
    }

    @Override
    public String getToolTipText() {
        return this.getUserObject().toString();
    }

    @Override
    public void performRemove() throws CpoException {
        this.getProxy().removeClass(this);
    }

    public String getDisplayClassName() {
        String className = this.getUserObject().getName();
        if (this.getProxy().isDisplayShortClassName() && className.lastIndexOf(".") != -1 && className.length() > className.lastIndexOf(".") + 1) {
            return className.substring(className.lastIndexOf(".") + 1);
        }
        return className;
    }

    public void setClassName(String className) {
        CpoClass cpoClass = this.getUserObject();
        if (className == null && cpoClass.getName() == null || cpoClass.getName() != null && cpoClass.getName().equals(className)) {
            return;
        }
        cpoClass.setName(className);
        this.setDirty(true);
    }

    @Override
    public int compareTo(CpoClassNode ccn) {
        return this.getDisplayClassName().compareTo(ccn.getDisplayClassName());
    }
}

