/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoAdapter;
import org.synchronoss.cpo.CpoAdapterFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.MetaVisitor;
import org.synchronoss.cpo.core.cpoCoreConfig.CtDataSourceConfig;
import org.synchronoss.cpo.core.cpoCoreMeta.StFunctionGroupType;
import org.synchronoss.cpo.exporter.CpoClassSourceGenerator;
import org.synchronoss.cpo.meta.CpoMetaDescriptor;
import org.synchronoss.cpo.meta.domain.CpoArgument;
import org.synchronoss.cpo.meta.domain.CpoAttribute;
import org.synchronoss.cpo.meta.domain.CpoClass;
import org.synchronoss.cpo.meta.domain.CpoFunction;
import org.synchronoss.cpo.meta.domain.CpoFunctionGroup;
import org.synchronoss.cpo.parser.ExpressionParser;
import org.synchronoss.cpo.util.AbstractCpoNode;
import org.synchronoss.cpo.util.CaseInsensitiveStringComparator;
import org.synchronoss.cpo.util.CpoArgumentNode;
import org.synchronoss.cpo.util.CpoAttributeNode;
import org.synchronoss.cpo.util.CpoClassNode;
import org.synchronoss.cpo.util.CpoFunctionGroupNode;
import org.synchronoss.cpo.util.CpoFunctionNode;
import org.synchronoss.cpo.util.CpoRootNode;
import org.synchronoss.cpo.util.CpoUtil;
import org.synchronoss.cpo.util.CpoUtilClassLoader;
import org.synchronoss.cpo.util.JTreeMetaVisitor;
import org.synchronoss.cpo.util.SupportedType;

public abstract class Proxy {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected File cpoMetaXml;
    protected File lastDir;
    protected CpoMetaDescriptor metaDescriptor = null;
    protected Map<String, CpoAdapter> adapterCache = new ConcurrentHashMap<String, CpoAdapter>();
    protected DefaultTreeModel treeModel = null;
    private boolean displayShortClassName = false;

    protected Proxy() {
    }

    protected final File getCpoMetaXml() {
        return this.cpoMetaXml;
    }

    protected final void setCpoMetaXml(File cpoMetaXml) {
        this.cpoMetaXml = cpoMetaXml;
        this.lastDir = cpoMetaXml.getParentFile();
    }

    protected final void setMetaDescriptor(CpoMetaDescriptor metaDescriptor) {
        this.metaDescriptor = metaDescriptor;
    }

    public final TreeModel createTreeModel() throws CpoException {
        CpoRootNode rootNode = new CpoRootNode(this);
        JTreeMetaVisitor visitor = new JTreeMetaVisitor(rootNode);
        for (CpoClass cpoClass : this.metaDescriptor.getCpoClasses()) {
            cpoClass.acceptMetaDFVisitor((MetaVisitor)visitor);
        }
        this.treeModel = new DefaultTreeModel(rootNode);
        return this.treeModel;
    }

    protected CpoRootNode getRoot() {
        return (CpoRootNode)this.treeModel.getRoot();
    }

    public String getDefaultPackageName() {
        return this.metaDescriptor.getDefaultPackageName();
    }

    public void setDefaultPackageName(String packageName) {
        this.metaDescriptor.setDefaultPackageName(packageName);
    }

    public File getLastDir() {
        return this.lastDir;
    }

    public void setLastDir(File file) {
        if (file != null) {
            this.lastDir = file;
        }
    }

    public String toString() {
        return this.cpoMetaXml.getName();
    }

    public String getMetaXmlFullName() {
        return this.cpoMetaXml.getAbsolutePath();
    }

    public Vector<String> getConnectionList() throws CpoException {
        Vector<String> result = new Vector<String>();
        SupportedType type = SupportedType.getTypeForMetaDescriptor(this.metaDescriptor);
        List<CtDataSourceConfig> dataSourceConfigs = CpoUtil.getInstance().getDataSourceConfigs();
        for (CtDataSourceConfig dataSourceConfig : dataSourceConfigs) {
            if (!type.getDataSourceConfigClass().isAssignableFrom(dataSourceConfig.getClass())) continue;
            result.add(dataSourceConfig.getName());
        }
        Collections.sort(result, new CaseInsensitiveStringComparator());
        return result;
    }

    public Vector<String> getAllowableDataTypes() {
        Vector<String> dataTypes = new Vector<String>();
        try {
            dataTypes.addAll(this.metaDescriptor.getAllowableDataTypes());
        }
        catch (CpoException ex) {
            CpoUtil.showException(ex);
        }
        return dataTypes;
    }

    public void save(File file) throws CpoException {
        File dest = file;
        if (dest == null) {
            dest = this.cpoMetaXml;
        }
        List<AbstractCpoNode> changedNodes = this.getRoot().getChangedNodes();
        for (AbstractCpoNode node : changedNodes) {
            if (!node.isRemove()) continue;
            node.performRemove();
        }
        try {
            this.metaDescriptor.export(dest);
            this.getRoot().clearChangedNodes();
        }
        catch (CpoException ex) {
            CpoUtil.showException(ex);
        }
    }

    public void toggleClassNames() {
        this.displayShortClassName = !this.displayShortClassName;
    }

    public boolean isDisplayShortClassName() {
        return this.displayShortClassName;
    }

    protected CpoClass createCpoClass(String className) throws CpoException {
        CpoClass cpoClass = this.metaDescriptor.createCpoClass();
        cpoClass.setName(className);
        if (cpoClass.getName().lastIndexOf(".") != -1) {
            this.setDefaultPackageName(cpoClass.getName().substring(0, cpoClass.getName().lastIndexOf(".")));
        }
        return cpoClass;
    }

    protected CpoAttribute createCpoAttribute() throws CpoException {
        return this.metaDescriptor.createCpoAttribute();
    }

    protected CpoFunctionGroup createCpoFunctionGroup(String name, String type) throws CpoException {
        CpoFunctionGroup functionGroup = this.metaDescriptor.createCpoFunctionGroup();
        functionGroup.setName(name);
        functionGroup.setType(type);
        return functionGroup;
    }

    protected CpoFunction createCpoFunction() throws CpoException {
        CpoFunction function = this.metaDescriptor.createCpoFunction();
        function.setExpression("");
        return function;
    }

    protected CpoArgument createCpoArgument() throws CpoException {
        return this.metaDescriptor.createCpoArgument();
    }

    protected CpoClassNode createClassNode(CpoClass cpoClass) {
        return new CpoClassNode(cpoClass);
    }

    protected CpoAttributeNode createAttributeNode(CpoAttribute cpoAttribute) {
        return new CpoAttributeNode(cpoAttribute);
    }

    protected CpoFunctionGroupNode createFunctionGroupNode(CpoFunctionGroup cpoFunctionGroup) {
        return new CpoFunctionGroupNode(cpoFunctionGroup);
    }

    protected CpoFunctionNode createFunctionNode(CpoFunction cpoFunction) {
        return new CpoFunctionNode(cpoFunction);
    }

    protected CpoArgumentNode createArgumentNode(CpoArgument cpoArgument) {
        return new CpoArgumentNode(cpoArgument);
    }

    public CpoClassNode addClass(String className) throws CpoException {
        CpoClass cpoClass = this.createCpoClass(className);
        CpoClassNode cpoClassNode = this.createClassNode(cpoClass);
        cpoClassNode.setProtected(CpoUtil.getInstance().isClassProtected(cpoClass));
        this.metaDescriptor.addCpoClass(cpoClass);
        this.getRoot().add(cpoClassNode);
        cpoClassNode.setNew(true);
        return cpoClassNode;
    }

    public boolean addAttribute(CpoClassNode cpoClassNode, CpoAttribute attribute) {
        boolean added = false;
        if (!cpoClassNode.attributeExists(attribute.getJavaName())) {
            cpoClassNode.getUserObject().addAttribute(attribute);
            CpoAttributeNode cpoAttributeNode = this.createAttributeNode(attribute);
            cpoClassNode.getAttributeLabelNode().add(cpoAttributeNode);
            cpoAttributeNode.setNew(true);
            added = true;
        }
        return added;
    }

    public CpoFunctionGroupNode addFunctionGroup(CpoClassNode cpoClassNode, String name, String type) throws CpoException {
        CpoFunctionGroup cpoFunctionGroup = this.createCpoFunctionGroup(name, type);
        CpoFunctionGroupNode cpoFunctionGroupNode = this.createFunctionGroupNode(cpoFunctionGroup);
        cpoFunctionGroupNode.setProtected(cpoClassNode.isProtected());
        cpoClassNode.getUserObject().addFunctionGroup(cpoFunctionGroup);
        cpoClassNode.getFunctionGroupLabelNode().add(cpoFunctionGroupNode);
        cpoFunctionGroupNode.setNew(true);
        return cpoFunctionGroupNode;
    }

    public CpoFunctionNode addFunction(CpoFunctionGroupNode cpoFunctionGroupNode) throws CpoException {
        CpoFunction cpoFunction = this.createCpoFunction();
        CpoFunctionNode cpoFunctionNode = this.createFunctionNode(cpoFunction);
        cpoFunctionNode.setProtected(cpoFunctionGroupNode.isProtected());
        cpoFunctionGroupNode.getUserObject().addFunction(cpoFunction);
        cpoFunctionGroupNode.add(cpoFunctionNode);
        cpoFunctionNode.setNew(true);
        return cpoFunctionNode;
    }

    public CpoArgumentNode addArgument(CpoFunctionNode cpoFunctionNode, CpoAttribute cpoAttribute) throws CpoException {
        CpoArgument cpoArgument = this.createCpoArgument();
        if (cpoAttribute != null) {
            cpoArgument.setAttribute(cpoAttribute);
        }
        CpoArgumentNode cpoArgumentNode = this.createArgumentNode(cpoArgument);
        cpoArgumentNode.setProtected(cpoFunctionNode.isProtected());
        cpoFunctionNode.getUserObject().addArgument(cpoArgument);
        cpoFunctionNode.add(cpoArgumentNode);
        cpoArgumentNode.setNew(true);
        return cpoArgumentNode;
    }

    public void removeClass(CpoClassNode cpoClassNode) throws CpoException {
        this.metaDescriptor.removeCpoClass(cpoClassNode.getUserObject());
        cpoClassNode.removeFromParent();
    }

    public void removeAttribute(CpoAttributeNode cpoAttributeNode) throws CpoException {
        CpoClassNode cpoClassNode = cpoAttributeNode.getParent().getParent();
        cpoClassNode.getUserObject().removeAttribute(cpoAttributeNode.getUserObject());
        cpoAttributeNode.removeFromParent();
    }

    public void removeFunctionGroup(CpoFunctionGroupNode cpoFunctionGroupNode) throws CpoException {
        CpoClassNode cpoClassNode = cpoFunctionGroupNode.getParent().getParent();
        cpoClassNode.getUserObject().removeFunctionGroup(cpoFunctionGroupNode.getUserObject());
        cpoFunctionGroupNode.removeFromParent();
    }

    public void removeFunction(CpoFunctionNode cpoFunctionNode) throws CpoException {
        CpoFunctionGroupNode cpoFunctionGroupNode = cpoFunctionNode.getParent();
        cpoFunctionGroupNode.getUserObject().removeFunction(cpoFunctionNode.getUserObject());
        cpoFunctionNode.removeFromParent();
    }

    public void removeArgument(CpoArgumentNode cpoArgumentNode) throws CpoException {
        CpoFunctionNode cpoFunctionNode = cpoArgumentNode.getParent();
        cpoFunctionNode.getUserObject().removeArgument(cpoArgumentNode.getSeqNo());
        cpoArgumentNode.removeFromParent();
    }

    public Set<CpoFunctionGroup> getFunctionGroupsUsingAttribute(CpoAttributeNode cpoAttributeNode) {
        TreeSet<CpoFunctionGroup> functionGroups = new TreeSet<CpoFunctionGroup>();
        Enumeration<TreeNode> functionGroupNodes = cpoAttributeNode.getParent().getParent().getFunctionGroupLabelNode().children();
        while (functionGroupNodes.hasMoreElements()) {
            CpoFunctionGroupNode functionGroupNode = (CpoFunctionGroupNode)functionGroupNodes.nextElement();
            if (functionGroupNode.isRemove()) continue;
            CpoFunctionGroup functionGroup = functionGroupNode.getUserObject();
            Enumeration<TreeNode> functionNodes = functionGroupNode.children();
            while (functionNodes.hasMoreElements()) {
                CpoFunctionNode functionNode = (CpoFunctionNode)functionNodes.nextElement();
                Enumeration<TreeNode> argumentNodes = functionNode.children();
                while (argumentNodes.hasMoreElements()) {
                    CpoArgumentNode argumentNode = (CpoArgumentNode)argumentNodes.nextElement();
                    if (!argumentNode.getUserObject().getAttributeName().equals(cpoAttributeNode.getUserObject().getJavaName())) continue;
                    functionGroups.add(functionGroup);
                }
            }
        }
        return functionGroups;
    }

    public void moveFunctionUp(CpoFunctionNode cpoFunctionNode) {
        CpoFunctionGroupNode functionGroupNode = cpoFunctionNode.getParent();
        int idx = functionGroupNode.getIndex(cpoFunctionNode);
        int newIdx = idx - 1;
        this.reorderFunctionNode(cpoFunctionNode, newIdx);
    }

    public void moveFunctionDown(CpoFunctionNode cpoFunctionNode) {
        CpoFunctionGroupNode functionGroupNode = cpoFunctionNode.getParent();
        int idx = functionGroupNode.getIndex(cpoFunctionNode);
        int newIdx = idx + 1;
        this.reorderFunctionNode(cpoFunctionNode, newIdx);
    }

    private void reorderFunctionNode(CpoFunctionNode cpoFunctionNode, int newIdx) {
        CpoFunctionGroupNode functionGroupNode = cpoFunctionNode.getParent();
        List functions = functionGroupNode.getUserObject().getFunctions();
        functions.remove(cpoFunctionNode.getUserObject());
        functions.add(newIdx, cpoFunctionNode.getUserObject());
        this.treeModel.removeNodeFromParent(cpoFunctionNode);
        this.treeModel.insertNodeInto(cpoFunctionNode, functionGroupNode, newIdx);
        cpoFunctionNode.setDirty(true);
    }

    public String getDataTypeName(CpoAttribute cpoAttribute) throws CpoException {
        return this.metaDescriptor.getDataTypeName(cpoAttribute);
    }

    public List<CpoAttribute> createAttributesFromExpression(String connectionName, String expression) throws CpoException {
        List<Object> attributes = new ArrayList<CpoAttribute>();
        if (connectionName != null && !connectionName.isEmpty() && expression != null && !expression.isEmpty()) {
            try {
                CpoAdapter cpoAdapter = this.getCpoAdapter(connectionName);
                attributes = cpoAdapter.getCpoAttributes(expression);
            }
            catch (Exception ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
                throw new CpoException((Throwable)ex);
            }
        }
        return attributes;
    }

    public List<CpoAttribute> createAttributesFromClass(String className) throws CpoException, ClassNotFoundException {
        Method[] methods;
        String getMethodPrefix = "get";
        ArrayList<CpoAttribute> attributes = new ArrayList<CpoAttribute>();
        for (Method method : methods = CpoUtilClassLoader.getInstance(this.getClass().getClassLoader()).loadClass(className).getMethods()) {
            if (!method.getName().startsWith(getMethodPrefix)) continue;
            String attributeName = method.getName().substring(getMethodPrefix.length());
            CpoAttribute attribute = this.createCpoAttribute();
            attribute.setJavaName(attributeName);
            attribute.setJavaType(method.getReturnType().getName());
            attribute.setDataName(attributeName);
            attribute.setDataType("VARCHAR");
            attribute.setTransformClassName(null);
            attributes.add(attribute);
        }
        return attributes;
    }

    public boolean addAttributes(CpoClassNode cpoClassNode, List<CpoAttribute> attributes) {
        boolean added = false;
        ArrayList<CpoAttribute> ignored = new ArrayList<CpoAttribute>();
        for (CpoAttribute att : attributes) {
            if (this.addAttribute(cpoClassNode, att)) {
                added = true;
                continue;
            }
            ignored.add(att);
        }
        if (!ignored.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append("Did not add attributes because they already exist:");
            for (CpoAttribute ignoredAtt : ignored) {
                message.append("\n");
                message.append(ignoredAtt.getJavaName());
            }
            CpoUtil.getInstance().setStatusBarText(message.toString());
        }
        return added;
    }

    protected void nodeChanged(AbstractCpoNode notifier, AbstractCpoNode changedNode) {
        AbstractCpoNode parent;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Proxy got notification of changed object (new) " + changedNode.isNew() + " (remove) " + changedNode.isRemove());
        }
        if ((parent = notifier.getParent()) != null) {
            parent.setChildDirty(changedNode);
            parent.setChildNew(changedNode);
            parent.setChildRemove(changedNode);
            int index = parent.getIndex(notifier);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Set parent flags - index is: " + index);
            }
            if (index >= 0 && notifier.equals(changedNode)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Index: " + index + " size: " + notifier.getParent().getChildCount());
                }
                if (notifier.isRemove()) {
                    this.logger.debug("Notifying a parent of node (marked deleted) change");
                    this.treeModel.nodeChanged(parent);
                } else if (notifier.isDirty()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Notifying parent of node change (dirty and all else)");
                    }
                    this.treeModel.nodeChanged(parent);
                } else if (notifier.isNew()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Notifying parent (" + parent + ") of node insertion (" + changedNode + ")");
                    }
                    this.treeModel.nodesWereInserted(parent, new int[]{index});
                }
            } else if (notifier.equals(changedNode)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Object equal to notifier: " + notifier + " : parent: " + parent);
                }
                this.treeModel.nodeStructureChanged(parent);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("object not equal to notifier: " + notifier + " : object: " + changedNode);
                }
                this.treeModel.nodeChanged(parent);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Parent of " + notifier.getClass() + " was null");
        }
    }

    public String generateSourceCode(CpoClassNode node) {
        CpoClass cpoClass = node.getUserObject();
        CpoClassSourceGenerator generator = new CpoClassSourceGenerator(this.metaDescriptor);
        cpoClass.acceptMetaDFVisitor((MetaVisitor)generator);
        return generator.getSourceCode();
    }

    protected CpoAdapter getCpoAdapter(String connectionName) throws CpoException {
        if (this.adapterCache.containsKey(connectionName)) {
            return this.adapterCache.get(connectionName);
        }
        CtDataSourceConfig dataSourceConfig = CpoUtil.getInstance().getDataSourceConfig(connectionName);
        if (dataSourceConfig == null) {
            throw new CpoException("Unable to create connection: " + connectionName);
        }
        dataSourceConfig.setMetaDescriptorName(this.metaDescriptor.getName());
        CpoAdapter cpoAdapter = CpoAdapterFactory.makeCpoAdapter((CtDataSourceConfig)dataSourceConfig);
        this.adapterCache.put(connectionName, cpoAdapter);
        return cpoAdapter;
    }

    public Collection<?> executeFunctionGroup(String connectionName, Object obj, Object objReturnType, CpoFunctionGroup cpoFGnode, boolean persist) throws CpoException {
        CpoAdapter cpoAdapter = this.getCpoAdapter(connectionName);
        List<Long> result = new ArrayList<Long>();
        Object resultObj = null;
        if (cpoFGnode.getType().equals(StFunctionGroupType.CREATE.toString())) {
            resultObj = cpoAdapter.insertObject(cpoFGnode.getName(), obj);
        } else if (cpoFGnode.getType().equals(StFunctionGroupType.DELETE.toString())) {
            cpoAdapter.deleteObject(cpoFGnode.getName(), obj);
            resultObj = cpoAdapter.retrieveBean(cpoFGnode.getName(), obj);
        } else if (cpoFGnode.getType().equals(StFunctionGroupType.LIST.toString())) {
            result = cpoAdapter.retrieveBeans(cpoFGnode.getName(), obj, objReturnType);
        } else if (cpoFGnode.getType().equals(StFunctionGroupType.RETRIEVE.toString())) {
            resultObj = cpoAdapter.retrieveBean(cpoFGnode.getName(), obj);
        } else if (cpoFGnode.getType().equals(StFunctionGroupType.UPDATE.toString())) {
            cpoAdapter.updateObject(cpoFGnode.getName(), obj);
            resultObj = cpoAdapter.retrieveBean(cpoFGnode.getName(), obj);
        } else if (cpoFGnode.getType().equals(StFunctionGroupType.EXIST.toString()) && persist) {
            cpoAdapter.persistObject(cpoFGnode.getName(), obj);
            resultObj = cpoAdapter.retrieveBean(cpoFGnode.getName(), obj);
        } else if (cpoFGnode.getType().equals(StFunctionGroupType.EXIST.toString())) {
            resultObj = cpoAdapter.existsObject(cpoFGnode.getName(), obj);
        }
        if (result == null) {
            return new ArrayList();
        }
        if (resultObj != null) {
            result.add((Long)resultObj);
        }
        return result;
    }

    public ExpressionParser getExpressionParser(String expression) throws CpoException {
        ExpressionParser parser = this.metaDescriptor.getExpressionParser();
        parser.setExpression(expression);
        return parser;
    }
}

