/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.core.cpoCoreMeta.CpoMetaDataDocument;
import org.synchronoss.cpo.core.cpoCoreMeta.CtCpoMetaData;
import org.synchronoss.cpo.meta.CpoMetaDescriptor;
import org.synchronoss.cpo.util.Proxy;
import org.synchronoss.cpo.util.SupportedType;

public class ProxyFactory {
    protected static Logger logger = LoggerFactory.getLogger(ProxyFactory.class);
    private static ProxyFactory proxyFactory = new ProxyFactory();

    private ProxyFactory() {
    }

    public static ProxyFactory getInstance() {
        return proxyFactory;
    }

    public Proxy getProxy(File cpoMetaXml) throws CpoException {
        try {
            CpoMetaDescriptor metaDescriptor = this.createMetaDescriptor(cpoMetaXml);
            SupportedType type = SupportedType.getTypeForMetaDescriptor(metaDescriptor);
            Proxy proxy = type.newProxyInstance();
            proxy.setCpoMetaXml(cpoMetaXml);
            proxy.setMetaDescriptor(metaDescriptor);
            return proxy;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new CpoException((Throwable)ex);
        }
    }

    public Proxy newProxy(File cpoMetaXml, SupportedType type) throws CpoException {
        try {
            CpoMetaDataDocument cpoMetaDataDocument = CpoMetaDataDocument.Factory.newInstance();
            CtCpoMetaData ctCpoMetaData = cpoMetaDataDocument.addNewCpoMetaData();
            ctCpoMetaData.setMetaDescriptor(type.getMetaDescriptorClass().getName());
            cpoMetaDataDocument.save(cpoMetaXml);
            return this.getProxy(cpoMetaXml);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new CpoException((Throwable)ex);
        }
    }

    public void refreshMetaDescriptor(Proxy proxy, File file) throws CpoException {
        if (file == null) {
            file = proxy.getCpoMetaXml();
        }
        CpoMetaDescriptor metaDescriptor = this.createMetaDescriptor(file);
        proxy.setCpoMetaXml(file);
        proxy.setMetaDescriptor(metaDescriptor);
    }

    private CpoMetaDescriptor createMetaDescriptor(File cpoMetaXml) throws CpoException {
        String metaDescriptorName = "CpoUtil:" + System.currentTimeMillis() + ":" + cpoMetaXml.getAbsolutePath();
        return CpoMetaDescriptor.getInstance((String)metaDescriptorName, (String)cpoMetaXml.getAbsolutePath(), (boolean)false);
    }
}

