/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.synchronoss.cpo.util.AbstractCpoNode;
import org.synchronoss.cpo.util.CpoRootNode;

public class SaveNodesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private List<AbstractCpoNode> changedObjects;
    private String[] columnNames = new String[]{"Object Type", "Object", "Trans Type"};
    private Object[] columnClasses = new Object[]{String.class, String.class, String.class};

    public SaveNodesTableModel(CpoRootNode rootNode) {
        this.changedObjects = rootNode.getChangedNodes();
    }

    @Override
    public int getRowCount() {
        return this.changedObjects.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return (Class)this.columnClasses[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            String className = this.changedObjects.get(rowIndex).getClass().getName();
            return className.substring(className.lastIndexOf(".") + 1);
        }
        if (columnIndex == 1) {
            return this.changedObjects.get(rowIndex).toString();
        }
        if (columnIndex == 2) {
            if (this.changedObjects.get(rowIndex).isRemove()) {
                return "Delete";
            }
            if (this.changedObjects.get(rowIndex).isNew()) {
                return "New";
            }
            if (this.changedObjects.get(rowIndex).isDirty()) {
                return "Update";
            }
            return "This shouldn't be here!";
        }
        return null;
    }
}

