/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util.cassandra;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoAdapter;
import org.synchronoss.cpo.CpoAdapterFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.cassandra.cpoCassandraConfig.CtCassandraConfig;
import org.synchronoss.cpo.cassandra.cpoCassandraConfig.CtCassandraReadWriteConfig;
import org.synchronoss.cpo.core.cpoCoreConfig.CtDataSourceConfig;
import org.synchronoss.cpo.util.AbstractConnectionPanel;
import org.synchronoss.cpo.util.CpoUtil;

public class CassandraConnectionPanel
extends AbstractConnectionPanel {
    private static final String CONFIG_PROCESSOR = "org.synchronoss.cpo.cassandra.config.CassandraCpoConfigProcessor";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private JTextField jTextName = new JTextField();
    private JTextField jTextHost = new JTextField();
    private JTextField jTextKeyspace = new JTextField();

    public CassandraConnectionPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected String getConfigProcessor() {
        return CONFIG_PROCESSOR;
    }

    @Override
    public String getTitle() {
        return "Cassandra Connection";
    }

    public CtCassandraConfig newDataSourceConfig() {
        return CtCassandraConfig.Factory.newInstance();
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(450, 275));
        JLabel jLabCpoUtilName = new JLabel("Connection Name:");
        this.add((Component)jLabCpoUtilName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jTextName.setText("MyNewConnection");
        this.add((Component)this.jTextName, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        JLabel jLabelHost = new JLabel("Host:");
        this.add((Component)jLabelHost, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jTextHost.setText("127.0.0.1");
        this.add((Component)this.jTextHost, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        JLabel jLabKeyspace = new JLabel("Keyspace:");
        this.add((Component)jLabKeyspace, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jTextKeyspace.setText("MyKeyspace");
        this.add((Component)this.jTextKeyspace, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        JButton testConnectionButton = new JButton("Test");
        testConnectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CassandraConnectionPanel.this.testConnectionButtonActionPerformed();
            }
        });
        this.add((Component)testConnectionButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
    }

    public CtCassandraConfig getDataSourceConfig() {
        return (CtCassandraConfig)super.getDataSourceConfig();
    }

    private void testConnectionButtonActionPerformed() {
        try {
            CtDataSourceConfig dataSourceConfig = this.createDataSourceConfig();
            CpoAdapter cpoAdapter = CpoAdapterFactory.makeCpoAdapter((CtDataSourceConfig)dataSourceConfig);
            if (cpoAdapter != null) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Connection successful", "Test Connection", 1);
            }
        }
        catch (CpoException ex) {
            CpoUtil.showErrorMessage(ex.getMessage());
        }
    }

    @Override
    public CtDataSourceConfig createDataSourceConfig() throws CpoException {
        String connectionName = this.jTextName.getText();
        String host = this.jTextHost.getText();
        String keyspace = this.jTextKeyspace.getText();
        if (connectionName == null || connectionName.isEmpty()) {
            throw new CpoException("Connection name must be provided");
        }
        CtCassandraConfig myConfig = this.getDataSourceConfig();
        CtDataSourceConfig dupe = CpoUtil.getInstance().getDataSourceConfig(connectionName);
        if (dupe != null && !dupe.equals(myConfig)) {
            throw new CpoException("Another connection is using the name: " + connectionName + "\n\nConnection names must be unique");
        }
        if (host == null || host.isEmpty()) {
            throw new CpoException("A host must be provided");
        }
        if (keyspace == null || keyspace.isEmpty()) {
            throw new CpoException("A keyspace must be provided");
        }
        CtCassandraConfig cassandraConfig = this.newDataSourceConfig();
        cassandraConfig.setName(connectionName);
        if (myConfig != null && myConfig.getMetaDescriptorName() != null) {
            cassandraConfig.setMetaDescriptorName(myConfig.getMetaDescriptorName());
        } else {
            cassandraConfig.setMetaDescriptorName("cpoutil");
        }
        cassandraConfig.setCpoConfigProcessor(this.getConfigProcessor());
        CtCassandraReadWriteConfig rwc = cassandraConfig.addNewReadWriteConfig();
        rwc.setContactPointArray(0, host);
        rwc.setKeySpace(keyspace);
        return cassandraConfig;
    }
}

