/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cpo.util.conversion;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.xmlbeans.XmlObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cpo.CpoException;
import org.synchronoss.cpo.core.cpoCoreConfig.CtDataSourceConfig;
import org.synchronoss.cpo.jdbc.cpoJdbcConfig.CtJdbcConfig;
import org.synchronoss.cpo.jdbc.cpoJdbcConfig.CtJdbcReadWriteConfig;
import org.synchronoss.cpo.jdbc.cpoJdbcConfig.CtProperty;
import org.synchronoss.cpo.util.cpoUtilConfig.CtCpoUtilConfig;
import org.synchronoss.cpo.util.cpoUtilConfig.CtCustomClasspath;
import org.synchronoss.cpo.util.cpoUtilConfig.CtDataConfig;

public class ConvertCpoUtilLocalProperties {
    private static Logger logger = LoggerFactory.getLogger(ConvertCpoUtilLocalProperties.class);
    private static final File oldPropFile = new File(System.getProperties().getProperty("user.home"), ".cpoutil.properties");
    private static final String JDBC_CONFIG_PROCESSOR = "org.synchronoss.cpo.jdbc.config.JdbcCpoConfigProcessor";
    private static final String DEFAULT_META_DESCRIPTOR = "cpoutil";
    private static final String PARAM_DELIM = ";";
    private static final String PARAM_ASSIGNMENT = "=";
    private static final String CUSTOM_CLASSPATH = "cpoutil.classpath";
    private static final String PROP_WLSURL = "cpoutil.wls.url.";
    private static final String PROP_JDBC_URL = "cpoutil.jdbc.url.";
    private static final String PROP_JDBC_DRIVER = "cpoutil.jdbc.driver.";
    private static final String PROP_JDBC_PARAMS = "cpoutil.jdbc.params.";

    public static CtCpoUtilConfig convert() throws CpoException {
        logger.info("Converting CpoUtil properties file to XML...");
        logger.info("Converting: " + oldPropFile.getAbsolutePath());
        if (!oldPropFile.exists() || !oldPropFile.canRead()) {
            return null;
        }
        Properties oldProps = new Properties();
        try {
            oldProps.load(new FileInputStream(oldPropFile));
        }
        catch (IOException ex) {
            throw new CpoException(ex.getMessage(), (Throwable)ex);
        }
        TreeSet<String> servers = new TreeSet<String>();
        Enumeration<?> propsEnum = oldProps.propertyNames();
        while (propsEnum.hasMoreElements()) {
            String server;
            String name = (String)propsEnum.nextElement();
            if (name.startsWith(PROP_WLSURL)) {
                server = name.substring(PROP_WLSURL.length());
                servers.add(server);
                continue;
            }
            if (!name.startsWith(PROP_JDBC_URL)) continue;
            server = name.substring(PROP_JDBC_URL.length());
            servers.add(server);
        }
        CtCpoUtilConfig cpoUtilConfig = CtCpoUtilConfig.Factory.newInstance();
        String customClasspath = oldProps.getProperty(CUSTOM_CLASSPATH);
        if (customClasspath != null && !customClasspath.isEmpty()) {
            CtCustomClasspath ctCustomClasspath = cpoUtilConfig.addNewCustomClasspath();
            StringTokenizer st = new StringTokenizer(customClasspath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String entry = st.nextToken();
                ctCustomClasspath.addClasspathEntry(entry);
            }
        }
        if (!servers.isEmpty()) {
            CtDataConfig dataConfig = cpoUtilConfig.addNewDataConfigs();
            for (String server : servers) {
                String userPass;
                logger.info("Converting " + server);
                if (oldProps.getProperty(PROP_JDBC_URL + server) == null && oldProps.getProperty(PROP_JDBC_URL + server) == null) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("Weblogic???");
                    continue;
                }
                String userName = null;
                String password = null;
                String url = oldProps.getProperty(PROP_JDBC_URL + server);
                String driver = oldProps.getProperty(PROP_JDBC_DRIVER + server);
                String params = oldProps.getProperty(PROP_JDBC_PARAMS + server);
                String oraclePrefix = "jdbc:oracle:thin:";
                String hsqlPrefix = "jdbc:hsqldb:file:";
                if (url.startsWith(oraclePrefix)) {
                    userPass = url.substring(oraclePrefix.length(), url.indexOf("@"));
                    userName = userPass.substring(0, userPass.indexOf("/"));
                    password = userPass.substring(userPass.indexOf("/") + 1);
                } else if (url.startsWith(hsqlPrefix)) {
                    userPass = url.substring(url.indexOf("user="));
                    if (userPass.contains(PARAM_DELIM)) {
                        userName = userPass.substring("user=".length(), userPass.indexOf(PARAM_DELIM));
                        password = userPass.substring(userPass.indexOf(PARAM_DELIM)).substring("password=".length() + 1);
                    } else {
                        userName = userPass.substring("user=".length());
                        password = "";
                    }
                }
                CtJdbcConfig jdbcConfig = CtJdbcConfig.Factory.newInstance();
                jdbcConfig.setName(server);
                jdbcConfig.setCpoConfigProcessor(JDBC_CONFIG_PROCESSOR);
                jdbcConfig.setMetaDescriptorName(DEFAULT_META_DESCRIPTOR);
                CtJdbcReadWriteConfig rwc = jdbcConfig.addNewReadWriteConfig();
                rwc.setUser(userName);
                rwc.setPassword(password);
                rwc.setUrl(url);
                rwc.setDriverClassName(driver);
                if (params != null && !params.isEmpty()) {
                    StringTokenizer st = new StringTokenizer(params, PARAM_DELIM);
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        StringTokenizer stNameValue = new StringTokenizer(token, PARAM_ASSIGNMENT);
                        String name = null;
                        String value = null;
                        if (stNameValue.hasMoreTokens()) {
                            name = stNameValue.nextToken();
                        }
                        if (stNameValue.hasMoreTokens()) {
                            value = stNameValue.nextToken();
                        }
                        CtProperty prop = rwc.addNewProperty();
                        prop.setName(name);
                        prop.setValue(value);
                    }
                }
                CtDataSourceConfig dataSourceConfig = dataConfig.addNewDataConfig();
                dataSourceConfig.set((XmlObject)jdbcConfig);
            }
        }
        return cpoUtilConfig;
    }
}

