/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.syncope.client.to.AttributeTO;
import org.syncope.client.to.MembershipTO;
import org.syncope.client.to.SchemaTO;
import org.syncope.client.to.SchemaTOs;
import org.syncope.console.SyncopeApplication;
import org.syncope.console.pages.MembershipModalPage;
import org.syncope.console.pages.SyncopeModalPage;
import org.syncope.console.rest.SchemaRestClient;

public class MembershipModalPage
extends SyncopeModalPage {
    List<SchemaWrapper> schemaWrappers = new ArrayList();
    WebMarkupContainer container;
    AjaxButton submit;

    public MembershipModalPage(Page basePage, ModalWindow window, MembershipTO membershipTO, boolean createFlag) {
        Form form = new Form("MembershipForm");
        form.setModel((IModel)new CompoundPropertyModel((Object)membershipTO));
        this.setupSchemaWrappers(createFlag, membershipTO);
        1 userAttributesView = new /* Unavailable Anonymous Inner Class!! */;
        this.submit = new /* Unavailable Anonymous Inner Class!! */;
        form.add(new Component[]{this.submit});
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{userAttributesView});
        this.container.setOutputMarkupId(true);
        form.add(new Component[]{new FeedbackPanel("feedback").setOutputMarkupId(true)});
        form.add(new Component[]{this.container});
        this.add(new Component[]{form});
    }

    public Set<AttributeTO> getMembershipAttributes() {
        HashSet<AttributeTO> attributes = new HashSet<AttributeTO>();
        for (SchemaWrapper schemaWrapper : this.schemaWrappers) {
            AttributeTO attribute = new AttributeTO();
            attribute.setSchema(schemaWrapper.getSchemaTO().getName());
            attribute.setValues(new HashSet());
            for (String value : schemaWrapper.getValues()) {
                attribute.getValues().add(value);
            }
            attributes.add(attribute);
        }
        return attributes;
    }

    public void setupSchemaWrappers(boolean create, MembershipTO membershipTO) {
        this.schemaWrappers = new ArrayList();
        SchemaRestClient schemaRestClient = (SchemaRestClient)((SyncopeApplication)Application.get()).getApplicationContext().getBean("schemaRestClient");
        SchemaTOs schemas = schemaRestClient.getAllMemberhipSchemas();
        if (create) {
            for (SchemaTO schema : schemas) {
                SchemaWrapper schemaWrapper = new SchemaWrapper(this, schema);
                this.schemaWrappers.add(schemaWrapper);
            }
        } else {
            for (SchemaTO schema : schemas) {
                for (AttributeTO attribute : membershipTO.getAttributes()) {
                    if (!schema.getName().equals(attribute.getSchema())) continue;
                    SchemaWrapper schemaWrapper = new SchemaWrapper(this, schema);
                    schemaWrapper.setValues(attribute.getValues());
                    this.schemaWrappers.add(schemaWrapper);
                }
            }
        }
    }
}

