/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.ConnectorInstanceTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.client.to.SchemaMappingTO;
import org.syncope.client.to.SchemaMappingTOs;
import org.syncope.console.SyncopeApplication;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.ResourceModalPage;
import org.syncope.console.pages.SyncopeModalPage;
import org.syncope.console.rest.ResourcesRestClient;
import org.syncope.console.rest.SchemaRestClient;

public class ResourceModalPage
extends SyncopeModalPage {
    public TextField resourceName;
    public DropDownChoice connector;
    public CheckBox forceMandatoryConstraint;
    ConnectorInstanceTO connectorTO = new ConnectorInstanceTO();
    SchemaMappingTOs schemaMappingTOs = new SchemaMappingTOs();
    public AjaxButton submit;
    public AjaxButton addSchemaMappingBtn;
    private List<String> accountIdAttributesNames;
    private List<String> passwordAttributesNames;
    private List<String> userSchemaAttributesNames;
    private List<String> roleSchemaAttributesNames;
    private List<String> membershipSchemaAttributesNames;
    private Map<String, String> errors = new HashMap();
    ListView mappingUserSchemaView;
    @SpringBean(name="resourcesRestClient")
    ResourcesRestClient restClient;
    WebMarkupContainer mappingUserSchemaContainer;
    SchemaRestClient schemaRestClient = (SchemaRestClient)((SyncopeApplication)Application.get()).getApplicationContext().getBean("schemaRestClient");

    public ResourceModalPage(BasePage basePage, ModalWindow window, ResourceTO resourceTO, boolean createFlag) {
        this.setupChoiceListsPopulators();
        this.setupSchemaMappingsList(resourceTO.getMappings());
        Form resourceForm = new Form("ResourceForm");
        resourceForm.setModel((IModel)new CompoundPropertyModel((Object)resourceTO));
        if (!createFlag) {
            this.connectorTO.setId(resourceTO.getConnectorId());
        }
        1 connectors = new /* Unavailable Anonymous Inner Class!! */;
        2 schemaTypesList = new /* Unavailable Anonymous Inner Class!! */;
        this.resourceName = new TextField("name");
        this.resourceName.setEnabled(createFlag);
        this.resourceName.setRequired(true);
        this.resourceName.setOutputMarkupId(true);
        resourceForm.add(new Component[]{this.resourceName});
        this.forceMandatoryConstraint = new CheckBox("forceMandatoryConstraint");
        this.forceMandatoryConstraint.setOutputMarkupId(true);
        resourceForm.add(new Component[]{this.forceMandatoryConstraint});
        ChoiceRenderer renderer = new ChoiceRenderer("connectorName", "id");
        this.connector = new DropDownChoice("connectors", (IModel)new Model((Serializable)this.connectorTO), (IModel)connectors, (IChoiceRenderer)renderer);
        this.connector.setEnabled(createFlag);
        this.connector.setModel((IModel)new /* Unavailable Anonymous Inner Class!! */);
        this.connector.setRequired(true);
        this.connector.setEnabled(createFlag);
        resourceForm.add(new Component[]{this.connector});
        this.mappingUserSchemaView = new /* Unavailable Anonymous Inner Class!! */;
        this.mappingUserSchemaContainer = new WebMarkupContainer("mappingUserSchemaContainer");
        this.mappingUserSchemaContainer.add(new Component[]{this.mappingUserSchemaView});
        this.mappingUserSchemaContainer.setOutputMarkupId(true);
        resourceForm.add(new Component[]{this.mappingUserSchemaContainer});
        this.addSchemaMappingBtn = new /* Unavailable Anonymous Inner Class!! */;
        this.addSchemaMappingBtn.setDefaultFormProcessing(false);
        resourceForm.add(new Component[]{this.addSchemaMappingBtn});
        this.submit = new /* Unavailable Anonymous Inner Class!! */;
        resourceForm.add(new Component[]{this.submit});
        resourceForm.add(new Component[]{new FeedbackPanel("feedback").setOutputMarkupId(true)});
        this.add(new Component[]{resourceForm});
    }

    public void resourceFormCustomValidation() {
        int count = 0;
        for (SchemaMappingTO schemaMapping : this.schemaMappingTOs) {
            if (schemaMapping.isAccountid()) {
                ++count;
            }
            if (count <= 1) continue;
            this.errors.put("accountId", this.getString("accountIdValidation"));
            break;
        }
        count = 0;
        for (SchemaMappingTO schemaMapping : this.schemaMappingTOs) {
            if (schemaMapping.isPassword()) {
                ++count;
            }
            if (count <= 1) continue;
            this.errors.put("password", this.getString("passwordValidation"));
            break;
        }
        if (this.errors.size() > 0) {
            throw new IllegalArgumentException(this.getString("customValidation"));
        }
    }

    public void setupSchemaMappingsList(SchemaMappingTOs schemaMappingTos) {
        this.schemaMappingTOs = new SchemaMappingTOs();
        if (schemaMappingTos != null) {
            for (SchemaMappingTO schemaMappingTO : schemaMappingTos.getMappings()) {
                this.schemaMappingTOs.addMapping(schemaMappingTO);
            }
        } else {
            this.schemaMappingTOs.addMapping(new SchemaMappingTO());
        }
    }

    public void setupChoiceListsPopulators() {
        ArrayList<String> accountIdList = new ArrayList<String>();
        accountIdList.add("accountId");
        this.setAccountIdAttributesNames(accountIdList);
        ArrayList<String> passwordList = new ArrayList<String>();
        passwordList.add("password");
        this.setPasswordAttributesNames(passwordList);
        this.setRoleSchemaAttributesNames(this.schemaRestClient.getAllRoleSchemasNames());
        this.setUserSchemaAttributesNames(this.schemaRestClient.getAllUserSchemasNames());
        this.setMembershipSchemaAttributesNames(this.schemaRestClient.getAllMembershipSchemasNames());
    }

    public List<String> getMembershipSchemaAttributesNames() {
        return this.membershipSchemaAttributesNames;
    }

    public void setMembershipSchemaAttributesNames(List<String> membershipSchemaAttributesNames) {
        this.membershipSchemaAttributesNames = membershipSchemaAttributesNames;
    }

    public List<String> getRoleSchemaAttributesNames() {
        return this.roleSchemaAttributesNames;
    }

    public void setRoleSchemaAttributesNames(List<String> roleSchemaAttributesNames) {
        this.roleSchemaAttributesNames = roleSchemaAttributesNames;
    }

    public List<String> getUserSchemaAttributesNames() {
        return this.userSchemaAttributesNames;
    }

    public void setUserSchemaAttributesNames(List<String> userSchemaAttributesNames) {
        this.userSchemaAttributesNames = userSchemaAttributesNames;
    }

    public List<String> getAccountIdAttributesNames() {
        return this.accountIdAttributesNames;
    }

    public void setAccountIdAttributesNames(List<String> accountIdAttributesNames) {
        this.accountIdAttributesNames = accountIdAttributesNames;
    }

    public List<String> getPasswordAttributesNames() {
        return this.passwordAttributesNames;
    }

    public void setPasswordAttributesNames(List<String> passwordAttributesNames) {
        this.passwordAttributesNames = passwordAttributesNames;
    }

    static /* synthetic */ List access$000(ResourceModalPage x0) {
        return x0.userSchemaAttributesNames;
    }

    static /* synthetic */ List access$100(ResourceModalPage x0) {
        return x0.roleSchemaAttributesNames;
    }

    static /* synthetic */ List access$200(ResourceModalPage x0) {
        return x0.membershipSchemaAttributesNames;
    }

    static /* synthetic */ Map access$300(ResourceModalPage x0) {
        return x0.errors;
    }
}

