/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.mod.AttributeMod;
import org.syncope.client.mod.MembershipMod;
import org.syncope.client.mod.UserMod;
import org.syncope.client.to.AttributeTO;
import org.syncope.client.to.MembershipTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.client.to.ResourceTOs;
import org.syncope.client.to.RoleTO;
import org.syncope.client.to.RoleTOs;
import org.syncope.client.to.SchemaTO;
import org.syncope.client.to.SchemaTOs;
import org.syncope.client.to.UserTO;
import org.syncope.console.SyncopeApplication;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.SyncopeModalPage;
import org.syncope.console.pages.UserModalPage;
import org.syncope.console.rest.ResourcesRestClient;
import org.syncope.console.rest.RolesRestClient;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.rest.UsersRestClient;
import org.syncope.console.wicket.markup.html.tree.SyncopeRoleTree;
import org.syncope.types.SchemaValueType;

public class UserModalPage
extends SyncopeModalPage {
    @SpringBean(name="usersRestClient")
    UsersRestClient usersRestClient;
    @SpringBean(name="rolesRestClient")
    RolesRestClient rolesRestClient;
    WebMarkupContainer container;
    WebMarkupContainer membershipsContainer;
    AjaxButton submit;
    List<SchemaWrapper> schemaWrappers;
    List<MembershipTO> membershipTOs;
    final ModalWindow createUserWin;
    UserTO oldUser;
    UserMod userMod;
    Map rolesMap;

    public UserModalPage(BasePage basePage, ModalWindow window, UserTO userTO, boolean createFlag) {
        if (!createFlag) {
            this.cloneOldUserTO(userTO);
        }
        this.setupRolesMap();
        this.schemaWrappers = new ArrayList();
        Component[] componentArray = new Component[1];
        this.createUserWin = new ModalWindow("membershipWin");
        componentArray[0] = this.createUserWin;
        this.add(componentArray);
        this.createUserWin.setCssClassName("w_silver");
        this.createUserWin.setPageMapName("create-membership-modal");
        this.createUserWin.setCookieName("create-membership-modal");
        Form userForm = new Form("UserForm");
        userForm.setModel((IModel)new CompoundPropertyModel((Object)userTO));
        this.setupSchemaWrappers(createFlag, userTO);
        this.setupMemberships(createFlag, userTO);
        1 userAttributesView = new /* Unavailable Anonymous Inner Class!! */;
        userForm.add(new Component[]{userAttributesView});
        ListModel selectedResources = new ListModel();
        selectedResources.setObject((Object)this.getSelectedResources(userTO));
        ListModel availableResources = new ListModel();
        availableResources.setObject((Object)this.getAvailableResources(userTO));
        ChoiceRenderer paletteRenderer = new ChoiceRenderer("name", "name");
        Palette resourcesPalette = new Palette("resourcesPalette", (IModel)selectedResources, (IModel)availableResources, (IChoiceRenderer)paletteRenderer, 8, false);
        userForm.add(new Component[]{resourcesPalette});
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{userAttributesView});
        PasswordTextField password = new PasswordTextField("password");
        password.setRequired(createFlag);
        password.setResetPassword(false);
        this.container.add(new Component[]{password});
        this.container.setOutputMarkupId(true);
        userForm.add(new Component[]{this.container});
        this.submit = new /* Unavailable Anonymous Inner Class!! */;
        userForm.add(new Component[]{this.submit});
        userForm.add(new Component[]{new FeedbackPanel("feedback").setOutputMarkupId(true)});
        SyncopeRoleTree roleTree = new SyncopeRoleTree(this.rolesRestClient);
        3 tree = new /* Unavailable Anonymous Inner Class!! */;
        tree.getTreeState().expandAll();
        tree.updateTree();
        userForm.add(new Component[]{tree});
        4 membershipsView = new /* Unavailable Anonymous Inner Class!! */;
        this.membershipsContainer = new WebMarkupContainer("membershipsContainer");
        this.membershipsContainer.add(new Component[]{membershipsView});
        this.membershipsContainer.setOutputMarkupId(true);
        this.setWindowClosedCallback(this.createUserWin, this.membershipsContainer);
        userForm.add(new Component[]{this.membershipsContainer});
        this.add(new Component[]{userForm});
    }

    public List<ResourceTO> getSelectedResources(UserTO userTO) {
        ArrayList<ResourceTO> resources = new ArrayList<ResourceTO>();
        for (String resourceName : userTO.getResources()) {
            ResourceTO clusterableResourceTO = new ResourceTO();
            clusterableResourceTO.setName(resourceName);
            resources.add(clusterableResourceTO);
        }
        return resources;
    }

    public List<ResourceTO> getAvailableResources(UserTO userTO) {
        ArrayList<ResourceTO> resources = new ArrayList<ResourceTO>();
        ResourcesRestClient resourcesRestClient = (ResourcesRestClient)((SyncopeApplication)Application.get()).getApplicationContext().getBean("resourcesRestClient");
        ResourceTOs resourcesTos = resourcesRestClient.getAllResources();
        for (ResourceTO resourceTO : resourcesTos) {
            resources.add(resourceTO);
        }
        return resources;
    }

    public void cloneOldUserTO(UserTO userTO) {
        this.oldUser = new UserTO();
        this.oldUser.setId(userTO.getId());
        this.oldUser.setPassword(userTO.getPassword());
        this.oldUser.setAttributes(userTO.getAttributes());
        this.oldUser.setMemberships(new HashSet());
        for (MembershipTO membershipTO : userTO.getMemberships()) {
            MembershipTO membership = new MembershipTO();
            membership.setRoleId(membershipTO.getRoleId());
            membership.setAttributes(membershipTO.getAttributes());
            this.oldUser.getMemberships().add(membership);
        }
    }

    public void setupRolesMap() {
        this.rolesMap = new HashMap();
        RoleTOs roleTOs = this.rolesRestClient.getAllRoles();
        for (RoleTO roleTO : roleTOs) {
            this.rolesMap.put(roleTO.getId(), roleTO.getName());
        }
    }

    public void setWindowClosedCallback(ModalWindow window, WebMarkupContainer container) {
        window.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setupSchemaWrappers(boolean create, UserTO userTO) {
        this.schemaWrappers = new ArrayList();
        SchemaRestClient schemaRestClient = (SchemaRestClient)((SyncopeApplication)Application.get()).getApplicationContext().getBean("schemaRestClient");
        SchemaTOs schemas = schemaRestClient.getAllUserSchemas();
        boolean found = false;
        if (create) {
            for (SchemaTO schema : schemas) {
                SchemaWrapper schemaWrapper = new SchemaWrapper(this, schema);
                this.schemaWrappers.add(schemaWrapper);
            }
        } else {
            for (SchemaTO schema : schemas) {
                SchemaWrapper schemaWrapper;
                for (AttributeTO attribute : userTO.getAttributes()) {
                    if (!schema.getName().equals(attribute.getSchema())) continue;
                    schemaWrapper = new SchemaWrapper(this, schema);
                    if (schema.getType().equals((Object)SchemaValueType.Boolean)) {
                        schemaWrapper.setBooleanValues(attribute.getValues());
                    } else {
                        schemaWrapper.setValues(attribute.getValues());
                    }
                    this.schemaWrappers.add(schemaWrapper);
                    found = true;
                }
                if (!found) {
                    schemaWrapper = new SchemaWrapper(this, schema);
                    this.schemaWrappers.add(schemaWrapper);
                    continue;
                }
                found = false;
            }
        }
    }

    public void setupMemberships(boolean create, UserTO userTO) {
        this.membershipTOs = new ArrayList();
        if (!create) {
            Set memberships = userTO.getMemberships();
            for (MembershipTO membership : memberships) {
                this.membershipTOs.add(membership);
            }
        }
    }

    public Set<AttributeTO> getUserAttributesSet() {
        HashSet<AttributeTO> attributes = new HashSet<AttributeTO>();
        for (SchemaWrapper schemaWrapper : this.schemaWrappers) {
            AttributeTO attribute = new AttributeTO();
            attribute.setSchema(schemaWrapper.getSchemaTO().getName());
            attribute.setValues(new HashSet());
            for (String value : schemaWrapper.getValues()) {
                attribute.getValues().add(value);
            }
            attributes.add(attribute);
        }
        return attributes;
    }

    public Set<MembershipTO> getMembershipsSet() {
        HashSet<MembershipTO> memberships = new HashSet<MembershipTO>();
        for (MembershipTO membership : this.membershipTOs) {
            memberships.add(membership);
        }
        return memberships;
    }

    public Set<String> getResourcesSet(Collection<ResourceTO> resourcesList) {
        HashSet<String> resourcesSet = new HashSet<String>();
        for (ResourceTO resourceTO : resourcesList) {
            resourcesSet.add(resourceTO.getName());
        }
        return resourcesSet;
    }

    public List<MembershipTO> getMembershipTOs() {
        return this.membershipTOs;
    }

    public void setMembershipTOs(List<MembershipTO> membershipTOs) {
        this.membershipTOs = membershipTOs;
    }

    public void setupUserMod(UserTO userTO) {
        this.userMod = new UserMod();
        this.userMod.setId(this.oldUser.getId());
        if (!this.oldUser.getPassword().equals(userTO.getPassword())) {
            this.userMod.setPassword(userTO.getPassword());
        }
        for (AttributeTO attributeTO : userTO.getAttributes()) {
            this.searchAndUpdateAttribute(attributeTO);
        }
        for (String resource : userTO.getResources()) {
            this.searchAndAddResource(resource);
        }
        for (String resource : this.oldUser.getResources()) {
            this.searchAndDropResource(resource, userTO);
        }
        for (MembershipTO membership : userTO.getMemberships()) {
            this.searchAndUpdateMembership(membership);
        }
        for (MembershipTO membership : this.oldUser.getMemberships()) {
            this.searchAndDropMembership(membership, userTO);
        }
    }

    public void searchAndUpdateAttribute(AttributeTO attributeTO) {
        boolean found = false;
        AttributeMod attributeMod = new AttributeMod();
        attributeMod.setSchema(attributeTO.getSchema());
        for (AttributeTO oldAttribute : this.oldUser.getAttributes()) {
            if (!attributeTO.getSchema().equals(oldAttribute.getSchema())) continue;
            if (!attributeTO.equals((Object)oldAttribute)) {
                attributeMod.setValuesToBeAdded(attributeTO.getValues());
                this.userMod.addAttributeToBeRemoved(oldAttribute.getSchema());
                this.userMod.addAttributeToBeUpdated(attributeMod);
            }
            found = true;
        }
        if (!found) {
            attributeMod.setValuesToBeAdded(attributeTO.getValues());
            this.userMod.addAttributeToBeUpdated(attributeMod);
        }
    }

    public void searchAndAddResource(String resource) {
        boolean found = false;
        for (String oldResource : this.oldUser.getResources()) {
            if (!resource.equals(oldResource)) continue;
            found = true;
        }
        if (!found) {
            this.userMod.addResourceToBeAdded(resource);
        }
    }

    public void searchAndDropResource(String resource, UserTO userTO) {
        boolean found = false;
        for (String newResource : userTO.getResources()) {
            if (!resource.equals(newResource)) continue;
            found = true;
        }
        if (!found) {
            this.userMod.addResourceToBeRemoved(resource);
        }
    }

    public void searchAndUpdateMembership(MembershipTO membershipTO) {
        boolean found = false;
        MembershipMod membershipMod = new MembershipMod();
        membershipMod.setRole(membershipTO.getRoleId());
        for (MembershipTO oldMembership : this.oldUser.getMemberships()) {
            if (membershipTO.getRoleId() != oldMembership.getRoleId()) continue;
            for (AttributeTO oldAttribute : oldMembership.getAttributes()) {
                for (AttributeTO newAttribute : membershipTO.getAttributes()) {
                    if (oldAttribute.equals((Object)newAttribute)) continue;
                    AttributeMod attributeMod = new AttributeMod();
                    attributeMod.setSchema(newAttribute.getSchema());
                    attributeMod.setValuesToBeRemoved(oldAttribute.getValues());
                    attributeMod.setValuesToBeAdded(newAttribute.getValues());
                    membershipMod.addAttributeToBeUpdated(attributeMod);
                    this.userMod.addMembershipToBeAdded(membershipMod);
                    this.userMod.addMembershipToBeRemoved(Long.valueOf(oldMembership.getId()));
                }
            }
            found = true;
        }
        if (!found) {
            HashSet<AttributeMod> attributes = new HashSet<AttributeMod>();
            for (AttributeTO attr : membershipTO.getAttributes()) {
                AttributeMod attrMod = new AttributeMod();
                attrMod.setSchema(attr.getSchema());
                attrMod.setValuesToBeAdded(attr.getValues());
                attributes.add(attrMod);
            }
            membershipMod.setAttributesToBeUpdated(attributes);
            this.userMod.addMembershipToBeAdded(membershipMod);
        }
    }

    public void searchAndDropMembership(MembershipTO membershipTO, UserTO userTO) {
        boolean found = false;
        for (MembershipTO newMembership : userTO.getMemberships()) {
            if (newMembership.getId() != membershipTO.getId()) continue;
            found = true;
        }
        if (!found) {
            this.userMod.addMembershipToBeRemoved(Long.valueOf(membershipTO.getId()));
        }
    }
}

