/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestClientException;
import org.syncope.client.to.DerivedSchemaTO;
import org.syncope.client.to.DerivedSchemaTOs;
import org.syncope.client.to.SchemaTO;
import org.syncope.client.to.SchemaTOs;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.rest.RestClient;
import org.syncope.types.SyncopeClientExceptionType;

public class SchemaRestClient {
    RestClient restClient;
    protected static final Logger log = LoggerFactory.getLogger(SchemaRestClient.class);

    public SchemaTOs getAllUserSchemas() {
        SchemaTOs userSchemas = null;
        try {
            userSchemas = (SchemaTOs)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "schema/user/list.json", SchemaTOs.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            for (SyncopeClientExceptionType exceptionType : SyncopeClientExceptionType.values()) {
                if (!e.hasException(exceptionType)) continue;
                log.error(exceptionType.toString());
                log.error(e.getException(exceptionType).getElements().toString());
            }
        }
        catch (RestClientException e) {
            e.printStackTrace();
        }
        return userSchemas;
    }

    public List<String> getAllUserSchemasNames() {
        SchemaTOs userSchemas = null;
        ArrayList<String> schemasNames = new ArrayList<String>();
        try {
            userSchemas = (SchemaTOs)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "schema/user/list.json", SchemaTOs.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
        catch (RestClientException e) {
            e.printStackTrace();
        }
        for (SchemaTO schemaTO : userSchemas) {
            schemasNames.add(schemaTO.getName());
        }
        return schemasNames;
    }

    public DerivedSchemaTOs getAllUserDerivedSchemas() {
        DerivedSchemaTOs userDerivedSchemas = null;
        try {
            userDerivedSchemas = (DerivedSchemaTOs)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "derivedSchema/user/list.json", DerivedSchemaTOs.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
        return userDerivedSchemas;
    }

    public List<String> getAllUserDerivedSchemasNames() {
        DerivedSchemaTOs userDerivedSchemas = null;
        ArrayList<String> userDerivedSchemasNames = new ArrayList<String>();
        try {
            userDerivedSchemas = (DerivedSchemaTOs)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "derivedSchema/user/list.json", DerivedSchemaTOs.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
        catch (RestClientException e) {
            e.printStackTrace();
        }
        for (DerivedSchemaTO schemaTO : userDerivedSchemas) {
            userDerivedSchemasNames.add(schemaTO.getName());
        }
        return userDerivedSchemasNames;
    }

    public void createUserSchema(SchemaTO schemaTO) {
        try {
            this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "schema/user/create", (Object)schemaTO, SchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
    }

    public SchemaTO readUserSchema(String name) {
        SchemaTO schema = null;
        try {
            schema = (SchemaTO)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "schema/user/read/" + name + ".json", SchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
        return schema;
    }

    public void updateUserSchema(SchemaTO schemaTO) {
        try {
            this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "schema/user/update", (Object)schemaTO, SchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
    }

    public void deleteUserSchema(String name) {
        try {
            this.restClient.getRestTemplate().delete(this.restClient.getBaseURL() + "schema/user/delete/" + name + ".json", new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
    }

    public void createUserDerivedSchema(DerivedSchemaTO schemaTO) {
        try {
            this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "derivedSchema/user/create", (Object)schemaTO, DerivedSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
    }

    public DerivedSchemaTO readUserDerivedSchema(String name) {
        DerivedSchemaTO derivedSchemaTO = null;
        try {
            derivedSchemaTO = (DerivedSchemaTO)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "derivedSchema/user/read/" + name + ".json", DerivedSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
        return derivedSchemaTO;
    }

    public void updateUserDerivedSchema(DerivedSchemaTO schemaTO) {
        try {
            this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "derivedSchema/user/update", (Object)schemaTO, DerivedSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
    }

    public void deleteUserDerivedSchema(String name) {
        try {
            this.restClient.getRestTemplate().delete(this.restClient.getBaseURL() + "derivedSchema/user/delete/" + name + ".json", new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
    }

    public RestClient getRestClient() {
        return this.restClient;
    }

    public void setRestClient(RestClient restClient) {
        this.restClient = restClient;
    }

    public SchemaTOs getAllRoleSchemas() {
        SchemaTOs roleSchemas = null;
        try {
            roleSchemas = (SchemaTOs)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "schema/role/list.json", SchemaTOs.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
        }
        catch (RestClientException e) {
            e.printStackTrace();
        }
        return roleSchemas;
    }

    public List<String> getAllRoleSchemasNames() {
        SchemaTOs roleSchemas = null;
        ArrayList<String> roleSchemasNames = new ArrayList<String>();
        try {
            roleSchemas = (SchemaTOs)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "schema/role/list.json", SchemaTOs.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
        }
        catch (RestClientException e) {
            e.printStackTrace();
        }
        for (SchemaTO schemaTO : roleSchemas) {
            roleSchemasNames.add(schemaTO.getName());
        }
        return roleSchemasNames;
    }

    public List<String> getAllMembershipSchemasNames() {
        SchemaTOs membershipSchemas = null;
        ArrayList<String> membershipSchemasNames = new ArrayList<String>();
        try {
            membershipSchemas = (SchemaTOs)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "schema/membership/list.json", SchemaTOs.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
        }
        catch (RestClientException e) {
            e.printStackTrace();
        }
        for (SchemaTO schemaTO : membershipSchemas) {
            membershipSchemasNames.add(schemaTO.getName());
        }
        return membershipSchemasNames;
    }

    public void createRoleSchema(SchemaTO schemaTO) {
        try {
            this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "schema/role/create", (Object)schemaTO, SchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
    }

    public SchemaTO readRoleSchema(String name) {
        SchemaTO schema = null;
        try {
            schema = (SchemaTO)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "schema/role/read/" + name + ".json", SchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
        return schema;
    }

    public void updateRoleSchema(SchemaTO schemaTO) {
        try {
            SchemaTO updatedTO = (SchemaTO)this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "schema/role/update", (Object)schemaTO, SchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
    }

    public void deleteRoleSchema(String name) {
        try {
            this.restClient.getRestTemplate().delete(this.restClient.getBaseURL() + "schema/role/delete/" + name + ".json", new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
    }

    public DerivedSchemaTOs getAllRoleDerivedSchemas() {
        DerivedSchemaTOs roleDerivedSchemas = null;
        try {
            roleDerivedSchemas = (DerivedSchemaTOs)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "derivedSchema/role/list.json", DerivedSchemaTOs.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException syncopeClientCompositeErrorException) {
            // empty catch block
        }
        return roleDerivedSchemas;
    }

    public void createRoleDerivedSchema(DerivedSchemaTO schemaTO) {
        try {
            this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "derivedSchema/role/create", (Object)schemaTO, DerivedSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
    }

    public DerivedSchemaTO readRoleDerivedSchema(String name) {
        DerivedSchemaTO derivedSchemaTO = null;
        try {
            derivedSchemaTO = (DerivedSchemaTO)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "derivedSchema/role/read/" + name + ".json", DerivedSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
        return derivedSchemaTO;
    }

    public void updateRoleDerivedSchema(DerivedSchemaTO schemaTO) {
        try {
            this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "derivedSchema/role/update", (Object)schemaTO, DerivedSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
    }

    public void deleteRoleDerivedSchema(String name) {
        try {
            this.restClient.getRestTemplate().delete(this.restClient.getBaseURL() + "derivedSchema/role/delete/" + name + ".json", new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
    }

    public SchemaTOs getAllMemberhipSchemas() {
        SchemaTOs memberhipSchemas = null;
        try {
            memberhipSchemas = (SchemaTOs)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "schema/membership/list.json", SchemaTOs.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
        }
        catch (RestClientException e) {
            e.printStackTrace();
        }
        return memberhipSchemas;
    }

    public void createMemberhipSchema(SchemaTO schemaTO) {
        try {
            this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "schema/membership/create", (Object)schemaTO, SchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
    }

    public SchemaTO readMemberhipSchema(String name) {
        SchemaTO schema = null;
        try {
            schema = (SchemaTO)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "schema/membership/read/" + name + ".json", SchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
        return schema;
    }

    public void updateMemberhipSchema(SchemaTO schemaTO) {
        try {
            SchemaTO updatedTO = (SchemaTO)this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "schema/membership/update", (Object)schemaTO, SchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
    }

    public void deleteMemberhipSchema(String name) {
        try {
            this.restClient.getRestTemplate().delete(this.restClient.getBaseURL() + "schema/membership/delete/" + name + ".json", new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
    }

    public Set<String> getAllValidatorClasses() {
        Set validators = null;
        try {
            validators = (Set)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "configuration/validators.json", Set.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
        return validators;
    }

    public DerivedSchemaTOs getAllMembershipDerivedSchemas() {
        DerivedSchemaTOs roleDerivedSchemas = null;
        try {
            roleDerivedSchemas = (DerivedSchemaTOs)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "derivedSchema/membership/list.json", DerivedSchemaTOs.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException syncopeClientCompositeErrorException) {
            // empty catch block
        }
        return roleDerivedSchemas;
    }

    public void createMembershipDerivedSchema(DerivedSchemaTO schemaTO) {
        try {
            this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "derivedSchema/membership/create", (Object)schemaTO, DerivedSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
    }

    public DerivedSchemaTO readMembershipDerivedSchema(String name) {
        DerivedSchemaTO derivedSchemaTO = null;
        try {
            derivedSchemaTO = (DerivedSchemaTO)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "derivedSchema/membership/read/" + name + ".json", DerivedSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
        return derivedSchemaTO;
    }

    public void updateMembershipDerivedSchema(DerivedSchemaTO schemaTO) {
        try {
            this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "derivedSchema/membership/update", (Object)schemaTO, DerivedSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
    }

    public void deleteMembershipDerivedSchema(String name) {
        try {
            this.restClient.getRestTemplate().delete(this.restClient.getBaseURL() + "derivedSchema/membership/delete/" + name + ".json", new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
    }
}

