/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.navigation.paging.AjaxPagingNavigator;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.PageableListView;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.ConfigurationTO;
import org.syncope.console.commons.Utility;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.ConfigurationModalPage;
import org.syncope.console.rest.ConfigurationsRestClient;

public class Configuration
extends BasePage {
    @SpringBean(name="configurationsRestClient")
    ConfigurationsRestClient restClient;
    @SpringBean(name="utility")
    Utility utility;
    final ModalWindow createConfigWin;
    final ModalWindow editConfigWin;
    final int WIN_USER_HEIGHT = 680;
    final int WIN_USER_WIDTH = 1133;
    WebMarkupContainer container;
    boolean operationResult = false;
    FeedbackPanel feedbackPanel = new FeedbackPanel("feedback");

    public Configuration(PageParameters parameters) {
        super(parameters);
        this.feedbackPanel.setOutputMarkupId(true);
        this.add(new Component[]{this.feedbackPanel});
        Component[] componentArray = new Component[1];
        this.createConfigWin = new ModalWindow("createConfigurationWin");
        componentArray[0] = this.createConfigWin;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.editConfigWin = new ModalWindow("editConfigurationWin");
        componentArray2[0] = this.editConfigWin;
        this.add(componentArray2);
        LoadableDetachableModel configurations = new LoadableDetachableModel(){

            protected Object load() {
                return Configuration.this.restClient.getAllConfigurations().getConfigurations();
            }
        };
        PageableListView configurationsView = new PageableListView("configurations", (IModel)configurations, this.utility.getPaginatorRowsToDisplay("configuration")){

            protected void populateItem(ListItem item) {
                final ConfigurationTO configurationTO = (ConfigurationTO)item.getModelObject();
                item.add(new Component[]{new Label("key", configurationTO.getConfKey())});
                item.add(new Component[]{new Label("value", configurationTO.getConfValue())});
                AjaxLink editLink = new AjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Configuration.this.editConfigWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                ConfigurationModalPage window = new ConfigurationModalPage(Configuration.this, Configuration.this.editConfigWin, configurationTO, false);
                                return window;
                            }
                        });
                        Configuration.this.editConfigWin.show(target);
                    }
                };
                item.add(new Component[]{editLink});
                AjaxLink deleteLink = new AjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            Configuration.this.restClient.deleteConfiguration(configurationTO.getConfKey());
                        }
                        catch (UnsupportedEncodingException ex) {
                            Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, null, ex);
                            this.error((Serializable)((Object)ex.getMessage()));
                            return;
                        }
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Configuration.this.feedbackPanel);
                        target.addComponent((Component)Configuration.this.container);
                    }
                };
                item.add(new Component[]{deleteLink});
            }
        };
        this.add(new Component[]{new AjaxPagingNavigator("configurationsNavigator", (IPageable)configurationsView)});
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{configurationsView});
        this.container.setOutputMarkupId(true);
        this.createConfigWin.setCssClassName("w_silver");
        this.createConfigWin.setInitialHeight(680);
        this.createConfigWin.setInitialWidth(1133);
        this.createConfigWin.setPageMapName("create-configuration-modal");
        this.createConfigWin.setCookieName("create-configuration-modal");
        this.editConfigWin.setCssClassName("w_silver");
        this.editConfigWin.setInitialHeight(680);
        this.editConfigWin.setInitialWidth(680);
        this.editConfigWin.setPageMapName("edit-configuration-modal");
        this.editConfigWin.setCookieName("edit-configuration-modal");
        this.setWindowClosedCallback(this.createConfigWin, this.container);
        this.setWindowClosedCallback(this.editConfigWin, this.container);
        this.add(new Component[]{this.container});
        this.add(new Component[]{new AjaxLink("createConfigurationLink"){

            public void onClick(AjaxRequestTarget target) {
                Configuration.this.createConfigWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        ConfigurationModalPage window = new ConfigurationModalPage(Configuration.this, Configuration.this.createConfigWin, new ConfigurationTO(), true);
                        return window;
                    }
                });
                Configuration.this.createConfigWin.show(target);
            }
        }});
    }

    public void setWindowClosedCallback(ModalWindow window, final WebMarkupContainer container) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                target.addComponent((Component)container);
                if (Configuration.this.operationResult) {
                    Configuration.this.info(Configuration.this.getString("operation_succeded"));
                    target.addComponent((Component)Configuration.this.feedbackPanel);
                    Configuration.this.operationResult = false;
                }
            }
        });
    }

    public boolean isOperationResult() {
        return this.operationResult;
    }

    public void setOperationResult(boolean operationResult) {
        this.operationResult = operationResult;
    }
}

