/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.navigation.paging.AjaxPagingNavigator;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.PageableListView;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.ConnectorInstanceTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.console.commons.Utility;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.ConnectorsModalPage;
import org.syncope.console.rest.ConnectorsRestClient;
import org.syncope.console.rest.ResourcesRestClient;

public class Connectors
extends BasePage {
    @SpringBean(name="connectorsRestClient")
    ConnectorsRestClient restClient;
    @SpringBean(name="resourcesRestClient")
    ResourcesRestClient resourcesRestClient;
    @SpringBean(name="utility")
    Utility utility;
    final ModalWindow createConnectorWin;
    final ModalWindow editConnectorWin;
    WebMarkupContainer connectorsContainer;
    boolean operationResult = false;
    FeedbackPanel feedbackPanel;

    public Connectors(PageParameters parameters) {
        super(parameters);
        Component[] componentArray = new Component[1];
        this.createConnectorWin = new ModalWindow("createConnectorWin");
        componentArray[0] = this.createConnectorWin;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.editConnectorWin = new ModalWindow("editConnectorWin");
        componentArray2[0] = this.editConnectorWin;
        this.add(componentArray2);
        this.feedbackPanel = new FeedbackPanel("feedback");
        this.feedbackPanel.setOutputMarkupId(true);
        this.add(new Component[]{this.feedbackPanel});
        LoadableDetachableModel connectors = new LoadableDetachableModel(){

            protected Object load() {
                return Connectors.this.restClient.getAllConnectors().getInstances();
            }
        };
        PageableListView connectorsView = new PageableListView("connectors", (IModel)connectors, this.utility.getPaginatorRowsToDisplay("connectors")){

            protected void populateItem(final ListItem item) {
                final ConnectorInstanceTO connectorTO = (ConnectorInstanceTO)item.getDefaultModelObject();
                item.add(new Component[]{new Label("id", connectorTO.getId() + "")});
                item.add(new Component[]{new Label("name", connectorTO.getConnectorName())});
                item.add(new Component[]{new Label("version", connectorTO.getVersion())});
                item.add(new Component[]{new Label("bundleName", connectorTO.getBundleName())});
                AjaxLink editLink = new AjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        final ConnectorInstanceTO connectorTO = (ConnectorInstanceTO)item.getDefaultModelObject();
                        Connectors.this.editConnectorWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                ConnectorsModalPage form = new ConnectorsModalPage(Connectors.this, Connectors.this.editConnectorWin, connectorTO, false);
                                return form;
                            }
                        });
                        Connectors.this.editConnectorWin.show(target);
                    }
                };
                item.add(new Component[]{editLink});
                AjaxLink deleteLink = new AjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        if (!Connectors.this.checkDeleteIsForbidden(connectorTO)) {
                            Connectors.this.restClient.deleteConnector(connectorTO.getId());
                            this.info(this.getString("operation_succeded"));
                        } else {
                            this.error((Serializable)((Object)this.getString("delete_error")));
                        }
                        target.addComponent((Component)Connectors.this.connectorsContainer);
                        target.addComponent((Component)Connectors.this.feedbackPanel);
                    }
                };
                item.add(new Component[]{deleteLink});
            }
        };
        this.add(new Component[]{new AjaxPagingNavigator("connectorsNavigator", (IPageable)connectorsView)});
        this.connectorsContainer = new WebMarkupContainer("connectorsContainer");
        this.connectorsContainer.add(new Component[]{connectorsView});
        this.connectorsContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.connectorsContainer});
        this.setWindowClosedCallback(this.createConnectorWin, this.connectorsContainer);
        this.setWindowClosedCallback(this.editConnectorWin, this.connectorsContainer);
        this.createConnectorWin.setCssClassName("w_silver");
        this.createConnectorWin.setPageMapName("create-conn-modal");
        this.createConnectorWin.setCookieName("create-conn-modal");
        this.editConnectorWin.setCssClassName("w_silver");
        this.editConnectorWin.setPageMapName("edit-conn-modal");
        this.editConnectorWin.setCookieName("edit-conn-modal");
        this.add(new Component[]{new AjaxLink("createConnectorLink"){

            public void onClick(AjaxRequestTarget target) {
                Connectors.this.createConnectorWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        ConnectorsModalPage form = new ConnectorsModalPage(Connectors.this, Connectors.this.editConnectorWin, new ConnectorInstanceTO(), true);
                        return form;
                    }
                });
                Connectors.this.createConnectorWin.show(target);
            }
        }});
    }

    public boolean checkDeleteIsForbidden(ConnectorInstanceTO connectorTO) {
        boolean forbidden = false;
        List resources = this.resourcesRestClient.getAllResources().getResources();
        for (ResourceTO resourceTO : resources) {
            if (resourceTO.getConnectorId() != connectorTO.getId()) continue;
            forbidden = true;
        }
        return forbidden;
    }

    public void setWindowClosedCallback(ModalWindow window, final WebMarkupContainer container) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                target.addComponent((Component)container);
                if (Connectors.this.operationResult) {
                    Connectors.this.info(Connectors.this.getString("operation_succeded"));
                    target.addComponent((Component)Connectors.this.feedbackPanel);
                    Connectors.this.operationResult = false;
                }
            }
        });
    }

    public boolean isOperationResult() {
        return this.operationResult;
    }

    public void setOperationResult(boolean operationResult) {
        this.operationResult = operationResult;
    }
}

