/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.DerivedSchemaTO;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.Schema;
import org.syncope.console.pages.SyncopeModalPage;
import org.syncope.console.rest.SchemaRestClient;

public class DerivedSchemaModalPage
extends SyncopeModalPage {
    public TextField name;
    public TextField expression;
    public AjaxButton submit;
    public Entity entity;
    @SpringBean(name="schemaRestClient")
    SchemaRestClient restClient;

    public DerivedSchemaModalPage(final BasePage basePage, final ModalWindow window, DerivedSchemaTO schema, final boolean createFlag) {
        if (schema == null) {
            schema = new DerivedSchemaTO();
        }
        Form schemaForm = new Form("SchemaForm");
        schemaForm.setModel((IModel)new CompoundPropertyModel((Object)schema));
        schemaForm.add(new Component[]{new FeedbackPanel("feedback").setOutputMarkupId(true)});
        this.name = new TextField("name");
        this.name.setRequired(true);
        this.expression = new TextField("expression");
        this.expression.setRequired(true);
        this.name.setEnabled(createFlag);
        this.submit = new AjaxButton("submit"){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                if (DerivedSchemaModalPage.this.getEntity() == Entity.USER) {
                    if (createFlag) {
                        DerivedSchemaModalPage.this.restClient.createUserDerivedSchema((DerivedSchemaTO)form.getDefaultModelObject());
                    } else {
                        DerivedSchemaModalPage.this.restClient.updateUserDerivedSchema((DerivedSchemaTO)form.getDefaultModelObject());
                    }
                } else if (DerivedSchemaModalPage.this.getEntity() == Entity.ROLE) {
                    if (createFlag) {
                        DerivedSchemaModalPage.this.restClient.createRoleDerivedSchema((DerivedSchemaTO)form.getDefaultModelObject());
                    } else {
                        DerivedSchemaModalPage.this.restClient.updateRoleDerivedSchema((DerivedSchemaTO)form.getDefaultModelObject());
                    }
                } else if (DerivedSchemaModalPage.this.getEntity() == Entity.MEMBERSHIP) {
                    if (createFlag) {
                        DerivedSchemaModalPage.this.restClient.createMembershipDerivedSchema((DerivedSchemaTO)form.getDefaultModelObject());
                    } else {
                        DerivedSchemaModalPage.this.restClient.updateMembershipDerivedSchema((DerivedSchemaTO)form.getDefaultModelObject());
                    }
                }
                Schema callerPage = (Schema)basePage;
                callerPage.setOperationResult(true);
                window.close(target);
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent(form.get("feedback"));
            }
        };
        schemaForm.add(new Component[]{this.name});
        schemaForm.add(new Component[]{this.expression});
        schemaForm.add(new Component[]{this.submit});
        this.add(new Component[]{schemaForm});
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public static enum Entity {
        USER,
        ROLE,
        MEMBERSHIP;

    }
}

