/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.syncope.client.to.AttributeTO;
import org.syncope.client.to.MembershipTO;
import org.syncope.client.to.SchemaTO;
import org.syncope.client.to.SchemaTOs;
import org.syncope.console.SyncopeApplication;
import org.syncope.console.pages.SyncopeModalPage;
import org.syncope.console.pages.UserModalPage;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.syncope.console.wicket.markup.html.form.DateFieldPanel;

public class MembershipModalPage
extends SyncopeModalPage {
    List<SchemaWrapper> schemaWrappers = new ArrayList<SchemaWrapper>();
    WebMarkupContainer container;
    AjaxButton submit;

    public MembershipModalPage(final Page basePage, final ModalWindow window, MembershipTO membershipTO, final boolean createFlag) {
        Form form = new Form("MembershipForm");
        form.setModel((IModel)new CompoundPropertyModel((Object)membershipTO));
        this.setupSchemaWrappers(createFlag, membershipTO);
        ListView userAttributesView = new ListView("membershipSchemas", this.schemaWrappers){

            protected void populateItem(ListItem item) {
                final SchemaWrapper schemaWrapper = (SchemaWrapper)item.getDefaultModelObject();
                final SchemaTO schemaTO = schemaWrapper.getSchemaTO();
                item.add(new Component[]{new Label("name", schemaWrapper.getSchemaTO().getName())});
                item.add(new Component[]{new ListView("fields", schemaWrapper.getValues()){
                    Panel panel;

                    protected void populateItem(final ListItem item) {
                        if (schemaTO.getType().getClassName().equals("java.lang.String")) {
                            this.panel = new AjaxTextFieldPanel("panel", schemaTO.getName(), (IModel)new Model(){

                                public Serializable getObject() {
                                    return (String)item.getModelObject();
                                }

                                public void setObject(Serializable object) {
                                    item.setModelObject((Object)((String)((Object)object)));
                                }
                            }, schemaTO.isMandatory());
                        } else if (schemaTO.getType().getClassName().equals("java.lang.Boolean")) {
                            this.panel = new AjaxCheckBoxPanel("panel", schemaTO.getName(), (IModel<Boolean>)new Model(){

                                public Serializable getObject() {
                                    return "false";
                                }

                                public void setObject(Serializable object) {
                                    Boolean val = (Boolean)object;
                                    item.setModelObject((Object)val.toString());
                                }
                            }, schemaTO.isMandatory());
                        } else if (schemaTO.getType().getClassName().equals("java.util.Date")) {
                            this.panel = new DateFieldPanel("panel", schemaTO.getName(), (IModel<?>)new Model(){

                                public Serializable getObject() {
                                    SimpleDateFormat formatter = new SimpleDateFormat(schemaTO.getConversionPattern());
                                    Date date = new Date();
                                    try {
                                        String dateValue = (String)item.getModelObject();
                                        formatter = new SimpleDateFormat(schemaTO.getConversionPattern());
                                        if (!dateValue.equals("")) {
                                            date = formatter.parse((String)item.getModelObject());
                                        }
                                    }
                                    catch (ParseException ex) {
                                        Logger.getLogger(UserModalPage.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                    return date;
                                }

                                public void setObject(Serializable object) {
                                    Date date = (Date)object;
                                    SimpleDateFormat formatter = new SimpleDateFormat(schemaTO.getConversionPattern());
                                    String val = formatter.format((Object)date);
                                    item.setModelObject((Object)val);
                                }
                            }, schemaTO.isMandatory());
                        }
                        item.add(new Component[]{this.panel});
                    }
                }});
                AjaxButton addButton = new AjaxButton("add", (IModel)new Model((Serializable)((Object)this.getString("add")))){

                    protected void onSubmit(AjaxRequestTarget target, Form form) {
                        schemaWrapper.getValues().add("");
                        target.addComponent((Component)MembershipModalPage.this.container);
                    }
                };
                AjaxButton dropButton = new AjaxButton("drop", (IModel)new Model((Serializable)((Object)this.getString("drop")))){

                    protected void onSubmit(AjaxRequestTarget target, Form form) {
                        schemaWrapper.getValues().remove(schemaWrapper.getValues().size() - 1);
                        target.addComponent((Component)MembershipModalPage.this.container);
                    }
                };
                if (schemaTO.getType().getClassName().equals("java.lang.Boolean")) {
                    addButton.setVisible(false);
                    dropButton.setVisible(false);
                }
                addButton.setDefaultFormProcessing(false);
                addButton.setVisible(schemaTO.isMultivalue());
                dropButton.setDefaultFormProcessing(false);
                dropButton.setVisible(schemaTO.isMultivalue());
                if (schemaWrapper.getValues().size() == 1) {
                    dropButton.setVisible(false);
                }
                item.add(new Component[]{addButton});
                item.add(new Component[]{dropButton});
            }
        };
        this.submit = new AjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                MembershipTO membershipTO = (MembershipTO)form.getDefaultModelObject();
                membershipTO.setAttributes(MembershipModalPage.this.getMembershipAttributes());
                UserModalPage userModalPage = (UserModalPage)basePage;
                if (createFlag) {
                    userModalPage.getMembershipTOs().add(membershipTO);
                } else {
                    userModalPage.getMembershipTOs().remove(membershipTO);
                    userModalPage.getMembershipTOs().add(membershipTO);
                }
                window.close(target);
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent(form.get("feedback"));
            }
        };
        form.add(new Component[]{this.submit});
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{userAttributesView});
        this.container.setOutputMarkupId(true);
        form.add(new Component[]{new FeedbackPanel("feedback").setOutputMarkupId(true)});
        form.add(new Component[]{this.container});
        this.add(new Component[]{form});
    }

    public Set<AttributeTO> getMembershipAttributes() {
        HashSet<AttributeTO> attributes = new HashSet<AttributeTO>();
        for (SchemaWrapper schemaWrapper : this.schemaWrappers) {
            AttributeTO attribute = new AttributeTO();
            attribute.setSchema(schemaWrapper.getSchemaTO().getName());
            attribute.setValues(new HashSet());
            for (String value : schemaWrapper.getValues()) {
                attribute.getValues().add(value);
            }
            attributes.add(attribute);
        }
        return attributes;
    }

    public void setupSchemaWrappers(boolean create, MembershipTO membershipTO) {
        this.schemaWrappers = new ArrayList<SchemaWrapper>();
        SchemaRestClient schemaRestClient = (SchemaRestClient)((SyncopeApplication)Application.get()).getApplicationContext().getBean("schemaRestClient");
        SchemaTOs schemas = schemaRestClient.getAllMemberhipSchemas();
        if (create) {
            for (SchemaTO schema : schemas) {
                SchemaWrapper schemaWrapper = new SchemaWrapper(schema);
                this.schemaWrappers.add(schemaWrapper);
            }
        } else {
            for (SchemaTO schema : schemas) {
                for (AttributeTO attribute : membershipTO.getAttributes()) {
                    if (!schema.getName().equals(attribute.getSchema())) continue;
                    SchemaWrapper schemaWrapper = new SchemaWrapper(schema);
                    schemaWrapper.setValues(attribute.getValues());
                    this.schemaWrappers.add(schemaWrapper);
                }
            }
        }
    }

    public class SchemaWrapper {
        SchemaTO schemaTO;
        List<String> values;

        public SchemaWrapper(SchemaTO schemaTO) {
            this.schemaTO = schemaTO;
            this.values = new ArrayList<String>();
            this.values.add("");
        }

        public SchemaTO getSchemaTO() {
            return this.schemaTO;
        }

        public void setSchemaTO(SchemaTO schemaTO) {
            this.schemaTO = schemaTO;
        }

        public List<String> getValues() {
            return this.values;
        }

        public void setValues(List<String> values) {
            this.values = values;
        }

        public void setValues(Set<String> values) {
            this.values = new ArrayList<String>();
            for (String value : values) {
                this.values.add(value);
            }
        }
    }
}

