/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.navigation.paging.AjaxPagingNavigator;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.PageableListView;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.ResourceTO;
import org.syncope.console.commons.Utility;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.ResourceModalPage;
import org.syncope.console.rest.ResourcesRestClient;

public class Resources
extends BasePage {
    @SpringBean(name="resourcesRestClient")
    ResourcesRestClient restClient;
    @SpringBean(name="utility")
    Utility utility;
    final ModalWindow createResourceWin;
    final ModalWindow editResourceWin;
    final int WIN_INITIAL_HEIGHT = 515;
    final int WIN_INITIAL_WIDTH = 775;
    WebMarkupContainer resourcesContainer;
    boolean operationResult = false;
    FeedbackPanel feedbackPanel;

    public Resources(PageParameters parameters) {
        super(parameters);
        Component[] componentArray = new Component[1];
        this.createResourceWin = new ModalWindow("createResourceWin");
        componentArray[0] = this.createResourceWin;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.editResourceWin = new ModalWindow("editResourceWin");
        componentArray2[0] = this.editResourceWin;
        this.add(componentArray2);
        this.feedbackPanel = new FeedbackPanel("feedback");
        this.feedbackPanel.setOutputMarkupId(true);
        this.add(new Component[]{this.feedbackPanel});
        LoadableDetachableModel resources = new LoadableDetachableModel(){

            protected Object load() {
                return Resources.this.restClient.getAllResources().getResources();
            }
        };
        PageableListView resourcesView = new PageableListView("resources", (IModel)resources, this.utility.getPaginatorRowsToDisplay("resources")){

            protected void populateItem(final ListItem item) {
                final ResourceTO resourceTO = (ResourceTO)item.getDefaultModelObject();
                item.add(new Component[]{new Label("name", resourceTO.getName())});
                AjaxLink editLink = new AjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        final ResourceTO resourceTO = (ResourceTO)item.getDefaultModelObject();
                        Resources.this.editResourceWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                ResourceModalPage form = new ResourceModalPage(Resources.this, Resources.this.editResourceWin, resourceTO, false);
                                return form;
                            }
                        });
                        Resources.this.editResourceWin.show(target);
                    }
                };
                item.add(new Component[]{editLink});
                AjaxLink deleteLink = new AjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Resources.this.restClient.deleteResource(resourceTO.getName());
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Resources.this.feedbackPanel);
                        target.addComponent((Component)Resources.this.resourcesContainer);
                    }
                };
                item.add(new Component[]{deleteLink});
            }
        };
        this.add(new Component[]{new AjaxPagingNavigator("resourcesNavigator", (IPageable)resourcesView)});
        this.resourcesContainer = new WebMarkupContainer("resourcesContainer");
        this.resourcesContainer.add(new Component[]{resourcesView});
        this.resourcesContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.resourcesContainer});
        this.setWindowClosedCallback(this.createResourceWin, this.resourcesContainer);
        this.setWindowClosedCallback(this.editResourceWin, this.resourcesContainer);
        this.createResourceWin.setCssClassName("w_silver");
        this.createResourceWin.setInitialHeight(515);
        this.createResourceWin.setInitialWidth(775);
        this.createResourceWin.setPageMapName("create-res-modal");
        this.createResourceWin.setCookieName("create-res-modal");
        this.editResourceWin.setCssClassName("w_silver");
        this.editResourceWin.setInitialHeight(515);
        this.editResourceWin.setInitialWidth(775);
        this.editResourceWin.setPageMapName("edit-res-modal");
        this.editResourceWin.setCookieName("edit-res-modal");
        this.add(new Component[]{new AjaxLink("createResourceLink"){

            public void onClick(AjaxRequestTarget target) {
                Resources.this.createResourceWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        ResourceModalPage windows = new ResourceModalPage(Resources.this, Resources.this.editResourceWin, new ResourceTO(), true);
                        return windows;
                    }
                });
                Resources.this.createResourceWin.show(target);
            }
        }});
    }

    public boolean isOperationResult() {
        return this.operationResult;
    }

    public void setOperationResult(boolean operationResult) {
        this.operationResult = operationResult;
    }

    public void setWindowClosedCallback(ModalWindow window, final WebMarkupContainer container) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                target.addComponent((Component)container);
                if (Resources.this.operationResult) {
                    Resources.this.info(Resources.this.getString("operation_succeded"));
                    target.addComponent((Component)Resources.this.feedbackPanel);
                    Resources.this.operationResult = false;
                }
            }
        });
    }
}

