/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.mod.AttributeMod;
import org.syncope.client.mod.RoleMod;
import org.syncope.client.to.AttributeTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.client.to.ResourceTOs;
import org.syncope.client.to.RoleTO;
import org.syncope.client.to.SchemaTO;
import org.syncope.client.to.SchemaTOs;
import org.syncope.console.SyncopeApplication;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.Roles;
import org.syncope.console.pages.SyncopeModalPage;
import org.syncope.console.rest.ResourcesRestClient;
import org.syncope.console.rest.RolesRestClient;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.syncope.console.wicket.markup.html.form.DateFieldPanel;

public class RoleModalPage
extends SyncopeModalPage {
    @SpringBean(name="rolesRestClient")
    RolesRestClient restClient;
    AjaxButton submit;
    WebMarkupContainer container;
    List<SchemaWrapper> schemaWrappers = new ArrayList<SchemaWrapper>();
    RoleTO oldRole;
    RoleMod roleMod;

    public RoleModalPage(final BasePage basePage, final ModalWindow window, RoleTO roleTO, final boolean createFlag) {
        Form form = new Form("RoleForm");
        form.setModel((IModel)new CompoundPropertyModel((Object)roleTO));
        this.setupSchemaWrappers(createFlag, roleTO);
        if (!createFlag) {
            this.cloneOldRoleTO(roleTO);
        }
        ListView roleAttributesView = new ListView("roleSchemas", this.schemaWrappers){

            protected void populateItem(ListItem item) {
                final SchemaWrapper schemaWrapper = (SchemaWrapper)item.getDefaultModelObject();
                final SchemaTO schemaTO = schemaWrapper.getSchemaTO();
                item.add(new Component[]{new Label("name", schemaWrapper.getSchemaTO().getName())});
                item.add(new Component[]{new ListView("fields", schemaWrapper.getValues()){
                    Panel panel;

                    protected void populateItem(final ListItem item) {
                        this.panel = schemaTO.getType().getClassName().equals("java.lang.Boolean") ? new AjaxCheckBoxPanel("panel", schemaTO.getName(), (IModel<Boolean>)new Model(){

                            public Serializable getObject() {
                                return (String)item.getModelObject();
                            }

                            public void setObject(Serializable object) {
                                Boolean val = (Boolean)object;
                                item.setModelObject((Object)val.toString());
                            }
                        }, schemaTO.isMandatory()) : (schemaTO.getType().getClassName().equals("java.util.Date") ? new DateFieldPanel("panel", schemaTO.getName(), (IModel<?>)new Model(){

                            public Serializable getObject() {
                                SimpleDateFormat formatter = new SimpleDateFormat(schemaTO.getConversionPattern());
                                Date date = new Date();
                                try {
                                    String dateValue = (String)item.getModelObject();
                                    formatter = new SimpleDateFormat(schemaTO.getConversionPattern());
                                    if (!dateValue.equals("")) {
                                        date = formatter.parse((String)item.getModelObject());
                                    }
                                }
                                catch (ParseException ex) {
                                    Logger.getLogger(RoleModalPage.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                return date;
                            }

                            public void setObject(Serializable object) {
                                Date date = (Date)object;
                                SimpleDateFormat formatter = new SimpleDateFormat(schemaTO.getConversionPattern());
                                String val = formatter.format((Object)date);
                                item.setModelObject((Object)val);
                            }
                        }, schemaTO.isMandatory()) : new AjaxTextFieldPanel("panel", schemaTO.getName(), (IModel)new Model(){

                            public Serializable getObject() {
                                return (String)item.getModelObject();
                            }

                            public void setObject(Serializable object) {
                                item.setModelObject((Object)((String)((Object)object)));
                            }
                        }, schemaTO.isMandatory()));
                        item.add(new Component[]{this.panel});
                    }
                }});
                AjaxButton addButton = new AjaxButton("add", (IModel)new Model((Serializable)((Object)this.getString("add")))){

                    protected void onSubmit(AjaxRequestTarget target, Form form) {
                        schemaWrapper.getValues().add("");
                        target.addComponent((Component)RoleModalPage.this.container);
                    }
                };
                AjaxButton dropButton = new AjaxButton("drop", (IModel)new Model((Serializable)((Object)this.getString("drop")))){

                    protected void onSubmit(AjaxRequestTarget target, Form form) {
                        schemaWrapper.getValues().remove(schemaWrapper.getValues().size() - 1);
                        target.addComponent((Component)RoleModalPage.this.container);
                    }
                };
                if (schemaTO.getType().getClassName().equals("java.lang.Boolean")) {
                    addButton.setVisible(false);
                    dropButton.setVisible(false);
                }
                addButton.setDefaultFormProcessing(false);
                addButton.setVisible(schemaTO.isMultivalue());
                dropButton.setDefaultFormProcessing(false);
                dropButton.setVisible(schemaTO.isMultivalue());
                if (schemaWrapper.getValues().size() == 1) {
                    dropButton.setVisible(false);
                }
                item.add(new Component[]{addButton});
                item.add(new Component[]{dropButton});
            }
        };
        form.add(new Component[]{roleAttributesView});
        ListModel selectedResources = new ListModel();
        selectedResources.setObject(this.getSelectedResources(roleTO));
        ListModel availableResources = new ListModel();
        availableResources.setObject(this.getAvailableResources(roleTO));
        ChoiceRenderer paletteRenderer = new ChoiceRenderer("name", "name");
        final Palette resourcesPalette = new Palette("resourcesPalette", (IModel)selectedResources, (IModel)availableResources, (IChoiceRenderer)paletteRenderer, 8, false);
        form.add(new Component[]{resourcesPalette});
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{roleAttributesView});
        this.container.setOutputMarkupId(true);
        form.add(new Component[]{this.container});
        TextField name = new TextField("name");
        name.setRequired(true);
        this.container.add(new Component[]{name});
        this.submit = new AjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                RoleTO roleTO = (RoleTO)form.getDefaultModelObject();
                boolean res = false;
                try {
                    roleTO.setResources(RoleModalPage.this.getResourcesSet(resourcesPalette.getModelCollection()));
                    roleTO.setAttributes(RoleModalPage.this.getRoleAttributes());
                    if (createFlag) {
                        RoleModalPage.this.restClient.createRole(roleTO);
                        Roles callerPage = (Roles)basePage;
                        callerPage.setOperationResult(true);
                        window.close(target);
                    } else {
                        RoleModalPage.this.setupRoleMod(roleTO);
                        res = RoleModalPage.this.restClient.updateRole(RoleModalPage.this.roleMod);
                        if (!res) {
                            this.error((Serializable)((Object)this.getString("error")));
                        } else {
                            Roles callerPage = (Roles)basePage;
                            callerPage.setOperationResult(true);
                            window.close(target);
                        }
                    }
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)(this.getString("error") + ":" + e.getMessage())));
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent(form.get("feedback"));
            }
        };
        form.add(new Component[]{this.submit});
        form.add(new Component[]{new FeedbackPanel("feedback").setOutputMarkupId(true)});
        this.add(new Component[]{form});
    }

    public Set<String> getResourcesSet(Collection<ResourceTO> resourcesList) {
        HashSet<String> resourcesSet = new HashSet<String>();
        for (ResourceTO resourceTO : resourcesList) {
            resourcesSet.add(resourceTO.getName());
        }
        return resourcesSet;
    }

    public List<ResourceTO> getSelectedResources(RoleTO roleTO) {
        ArrayList<ResourceTO> resources = new ArrayList<ResourceTO>();
        for (String resourceName : roleTO.getResources()) {
            ResourceTO clusterableResourceTO = new ResourceTO();
            clusterableResourceTO.setName(resourceName);
            resources.add(clusterableResourceTO);
        }
        return resources;
    }

    public List<ResourceTO> getAvailableResources(RoleTO roleTO) {
        ArrayList<ResourceTO> resources = new ArrayList<ResourceTO>();
        ResourcesRestClient resourcesRestClient = (ResourcesRestClient)((SyncopeApplication)Application.get()).getApplicationContext().getBean("resourcesRestClient");
        ResourceTOs resourcesTos = resourcesRestClient.getAllResources();
        for (ResourceTO resourceTO : resourcesTos) {
            resources.add(resourceTO);
        }
        return resources;
    }

    public void setupSchemaWrappers(boolean create, RoleTO roleTO) {
        this.schemaWrappers = new ArrayList<SchemaWrapper>();
        SchemaRestClient schemaRestClient = (SchemaRestClient)((SyncopeApplication)Application.get()).getApplicationContext().getBean("schemaRestClient");
        SchemaTOs schemas = schemaRestClient.getAllRoleSchemas();
        boolean found = false;
        if (create) {
            for (SchemaTO schema : schemas) {
                SchemaWrapper schemaWrapper = new SchemaWrapper(schema);
                this.schemaWrappers.add(schemaWrapper);
            }
        } else {
            for (SchemaTO schema : schemas) {
                SchemaWrapper schemaWrapper;
                for (AttributeTO attribute : roleTO.getAttributes()) {
                    if (!schema.getName().equals(attribute.getSchema())) continue;
                    schemaWrapper = new SchemaWrapper(schema);
                    schemaWrapper.setValues(attribute.getValues());
                    this.schemaWrappers.add(schemaWrapper);
                    found = true;
                }
                if (!found) {
                    schemaWrapper = new SchemaWrapper(schema);
                    this.schemaWrappers.add(schemaWrapper);
                    continue;
                }
                found = false;
            }
        }
    }

    public Set<AttributeTO> getRoleAttributes() {
        HashSet<AttributeTO> attributes = new HashSet<AttributeTO>();
        for (SchemaWrapper schemaWrapper : this.schemaWrappers) {
            AttributeTO attribute = new AttributeTO();
            attribute.setSchema(schemaWrapper.getSchemaTO().getName());
            attribute.setValues(new HashSet());
            for (String value : schemaWrapper.getValues()) {
                attribute.getValues().add(value);
            }
            attributes.add(attribute);
        }
        return attributes;
    }

    public Set<String> getResourcesSet(List<String> resourcesList) {
        HashSet<String> resourcesSet = new HashSet<String>();
        for (String resource : resourcesList) {
            resourcesSet.add(resource);
        }
        return resourcesSet;
    }

    public void cloneOldRoleTO(RoleTO roleTO) {
        this.oldRole = new RoleTO();
        this.oldRole.setName(new String(roleTO.getName()));
        this.oldRole.setParent(new Long(roleTO.getParent()).longValue());
        HashSet attributes = new HashSet();
        this.oldRole.setAttributes(attributes);
        for (AttributeTO attribute : roleTO.getAttributes()) {
            AttributeTO attributeTO = new AttributeTO();
            attributeTO.setSchema(new String(attribute.getSchema()));
            HashSet<String> values = new HashSet<String>();
            for (String val : attribute.getValues()) {
                values.add(val);
            }
            attributeTO.setValues(values);
        }
    }

    public void setupRoleMod(RoleTO roleTO) {
        this.roleMod = new RoleMod();
        this.roleMod.setId(roleTO.getId());
        if (!this.oldRole.getName().equals(roleTO.getName())) {
            this.roleMod.setName(roleTO.getName());
        }
        for (AttributeTO attributeTO : roleTO.getAttributes()) {
            this.searchAndUpdateAttribute(attributeTO);
        }
    }

    public void searchAndUpdateAttribute(AttributeTO attributeTO) {
        boolean found = false;
        AttributeMod attributeMod = new AttributeMod();
        attributeMod.setSchema(attributeTO.getSchema());
        for (AttributeTO oldAttribute : this.oldRole.getAttributes()) {
            if (!attributeTO.getSchema().equals(oldAttribute.getSchema())) continue;
            if (!attributeTO.equals((Object)oldAttribute)) {
                attributeMod.setValuesToBeAdded(attributeTO.getValues());
                this.roleMod.addAttributeToBeRemoved(oldAttribute.getSchema());
                this.roleMod.addAttributeToBeUpdated(attributeMod);
            }
            found = true;
        }
        if (!found) {
            attributeMod.setValuesToBeAdded(attributeTO.getValues());
            this.roleMod.addAttributeToBeUpdated(attributeMod);
        }
    }

    public class SchemaWrapper {
        SchemaTO schemaTO;
        List<String> values;

        public SchemaWrapper(SchemaTO schemaTO) {
            this.schemaTO = schemaTO;
            this.values = new ArrayList<String>();
            this.values.add("");
        }

        public SchemaTO getSchemaTO() {
            return this.schemaTO;
        }

        public void setSchemaTO(SchemaTO schemaTO) {
            this.schemaTO = schemaTO;
        }

        public List<String> getValues() {
            return this.values;
        }

        public void setValues(List<String> values) {
            this.values = values;
        }

        public void setValues(Set<String> values) {
            for (String value : values) {
                this.values = new ArrayList<String>();
                this.values.add(value);
            }
        }
    }
}

