/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.navigation.paging.AjaxPagingNavigator;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.PageableListView;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.DerivedSchemaTO;
import org.syncope.client.to.SchemaTO;
import org.syncope.console.commons.Utility;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.DerivedSchemaModalPage;
import org.syncope.console.pages.SchemaModalPage;
import org.syncope.console.rest.SchemaRestClient;

public class Schema
extends BasePage {
    @SpringBean(name="schemaRestClient")
    SchemaRestClient restClient;
    @SpringBean(name="utility")
    Utility utility;
    final ModalWindow createUserSchemaWin;
    final ModalWindow editUserSchemaWin;
    final ModalWindow createUserDerivedSchemaWin;
    final ModalWindow editUserDerivedSchemaWin;
    final ModalWindow createRoleSchemaWin;
    final ModalWindow editRoleSchemaWin;
    final ModalWindow createRoleDerivedSchemaWin;
    final ModalWindow editRoleDerivedSchemaWin;
    final ModalWindow createMembershipSchemaWin;
    final ModalWindow editMembershipSchemaWin;
    final ModalWindow createMembershipDerivedSchemaWin;
    final ModalWindow editMembershipDerivedSchemaWin;
    WebMarkupContainer userSchemaContainer;
    WebMarkupContainer userDerivedSchemaContainer;
    WebMarkupContainer roleSchemasContainer;
    WebMarkupContainer roleDerivedSchemasContainer;
    WebMarkupContainer membershipSchemaContainer;
    WebMarkupContainer membershipDerivedSchemaContainer;
    boolean operationResult = false;
    FeedbackPanel feedbackPanel;

    public Schema(PageParameters parameters) {
        super(parameters);
        Component[] componentArray = new Component[1];
        this.createRoleSchemaWin = new ModalWindow("createRoleSchemaWin");
        componentArray[0] = this.createRoleSchemaWin;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.editRoleSchemaWin = new ModalWindow("editRoleSchemaWin");
        componentArray2[0] = this.editRoleSchemaWin;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.createRoleDerivedSchemaWin = new ModalWindow("createRoleDerivedSchemaWin");
        componentArray3[0] = this.createRoleDerivedSchemaWin;
        this.add(componentArray3);
        Component[] componentArray4 = new Component[1];
        this.editRoleDerivedSchemaWin = new ModalWindow("editRoleDerivedSchemaWin");
        componentArray4[0] = this.editRoleDerivedSchemaWin;
        this.add(componentArray4);
        Component[] componentArray5 = new Component[1];
        this.createUserSchemaWin = new ModalWindow("createUserSchemaWin");
        componentArray5[0] = this.createUserSchemaWin;
        this.add(componentArray5);
        Component[] componentArray6 = new Component[1];
        this.editUserSchemaWin = new ModalWindow("editUserSchemaWin");
        componentArray6[0] = this.editUserSchemaWin;
        this.add(componentArray6);
        Component[] componentArray7 = new Component[1];
        this.createUserDerivedSchemaWin = new ModalWindow("createUserDerSchemaWin");
        componentArray7[0] = this.createUserDerivedSchemaWin;
        this.add(componentArray7);
        Component[] componentArray8 = new Component[1];
        this.editUserDerivedSchemaWin = new ModalWindow("editUserDerSchemaWin");
        componentArray8[0] = this.editUserDerivedSchemaWin;
        this.add(componentArray8);
        Component[] componentArray9 = new Component[1];
        this.createMembershipSchemaWin = new ModalWindow("createMembershipSchemaWin");
        componentArray9[0] = this.createMembershipSchemaWin;
        this.add(componentArray9);
        Component[] componentArray10 = new Component[1];
        this.editMembershipSchemaWin = new ModalWindow("editMembershipSchemaWin");
        componentArray10[0] = this.editMembershipSchemaWin;
        this.add(componentArray10);
        Component[] componentArray11 = new Component[1];
        this.createMembershipDerivedSchemaWin = new ModalWindow("createMembershipDerSchemaWin");
        componentArray11[0] = this.createMembershipDerivedSchemaWin;
        this.add(componentArray11);
        Component[] componentArray12 = new Component[1];
        this.editMembershipDerivedSchemaWin = new ModalWindow("editMembershipDerSchemaWin");
        componentArray12[0] = this.editMembershipDerivedSchemaWin;
        this.add(componentArray12);
        this.feedbackPanel = new FeedbackPanel("feedback");
        this.feedbackPanel.setOutputMarkupId(true);
        this.add(new Component[]{this.feedbackPanel});
        LoadableDetachableModel userSchemas = new LoadableDetachableModel(){

            protected Object load() {
                return Schema.this.restClient.getAllUserSchemas().getSchemas();
            }
        };
        LoadableDetachableModel userDerivedSchemas = new LoadableDetachableModel(){

            protected Object load() {
                return Schema.this.restClient.getAllUserDerivedSchemas().getDerivedSchemas();
            }
        };
        LoadableDetachableModel roleSchemas = new LoadableDetachableModel(){

            protected Object load() {
                return Schema.this.restClient.getAllRoleSchemas().getSchemas();
            }
        };
        LoadableDetachableModel roleDerivedSchemas = new LoadableDetachableModel(){

            protected Object load() {
                return Schema.this.restClient.getAllRoleDerivedSchemas().getDerivedSchemas();
            }
        };
        LoadableDetachableModel membershipSchemas = new LoadableDetachableModel(){

            protected Object load() {
                return Schema.this.restClient.getAllMemberhipSchemas().getSchemas();
            }
        };
        LoadableDetachableModel membershipDerivedSchemas = new LoadableDetachableModel(){

            protected Object load() {
                return Schema.this.restClient.getAllMembershipDerivedSchemas().getDerivedSchemas();
            }
        };
        PageableListView roleSchemasView = new PageableListView("roleSchemas", (IModel)roleSchemas, this.utility.getPaginatorRowsToDisplay("schema")){

            protected void populateItem(final ListItem item) {
                final SchemaTO schemaTO = (SchemaTO)item.getDefaultModelObject();
                item.add(new Component[]{new Label("name", schemaTO.getName())});
                item.add(new Component[]{new Label("type", schemaTO.getType().getClassName())});
                item.add(new Component[]{new Label("attributes", schemaTO.getAttributes() + "")});
                AjaxLink editLink = new AjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        final SchemaTO schemaTO = (SchemaTO)item.getDefaultModelObject();
                        Schema.this.editRoleSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                SchemaModalPage form = new SchemaModalPage(Schema.this, Schema.this.editRoleSchemaWin, schemaTO, false);
                                form.setEntity(SchemaModalPage.Entity.ROLE);
                                return form;
                            }
                        });
                        Schema.this.editRoleSchemaWin.show(target);
                    }
                };
                item.add(new Component[]{editLink});
                AjaxLink deleteLink = new AjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.restClient.deleteRoleSchema(schemaTO.getName());
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Schema.this.feedbackPanel);
                        target.addComponent((Component)Schema.this.roleSchemasContainer);
                    }
                };
                item.add(new Component[]{deleteLink});
            }
        };
        this.add(new Component[]{new AjaxPagingNavigator("rolesNavigator", (IPageable)roleSchemasView)});
        PageableListView roleDerSchemasView = new PageableListView("roleDerivedSchemas", (IModel)roleDerivedSchemas, this.utility.getPaginatorRowsToDisplay("schema")){

            protected void populateItem(final ListItem item) {
                final DerivedSchemaTO schemaTO = (DerivedSchemaTO)item.getDefaultModelObject();
                item.add(new Component[]{new Label("name", schemaTO.getName())});
                item.add(new Component[]{new Label("expression", schemaTO.getExpression())});
                item.add(new Component[]{new Label("attributes", schemaTO.getDerivedAttributes() + "")});
                AjaxLink editLink = new AjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        final DerivedSchemaTO schemaTO = (DerivedSchemaTO)item.getDefaultModelObject();
                        Schema.this.editRoleDerivedSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                DerivedSchemaModalPage form = new DerivedSchemaModalPage(Schema.this, Schema.this.editRoleDerivedSchemaWin, schemaTO, false);
                                form.setEntity(DerivedSchemaModalPage.Entity.ROLE);
                                return form;
                            }
                        });
                        Schema.this.editRoleDerivedSchemaWin.show(target);
                    }
                };
                item.add(new Component[]{editLink});
                AjaxLink deleteLink = new AjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.restClient.deleteRoleDerivedSchema(schemaTO.getName());
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Schema.this.feedbackPanel);
                        target.addComponent((Component)Schema.this.roleDerivedSchemasContainer);
                    }
                };
                item.add(new Component[]{deleteLink});
            }
        };
        this.add(new Component[]{new AjaxPagingNavigator("rolesDerivedNavigator", (IPageable)roleDerSchemasView)});
        PageableListView userSchemasView = new PageableListView("userSchemas", (IModel)userSchemas, this.utility.getPaginatorRowsToDisplay("schema")){

            protected void populateItem(ListItem item) {
                final SchemaTO schemaTO = (SchemaTO)item.getDefaultModelObject();
                item.add(new Component[]{new Label("name", schemaTO.getName())});
                item.add(new Component[]{new Label("type", schemaTO.getType().getClassName())});
                item.add(new Component[]{new Label("attributes", schemaTO.getAttributes() + "")});
                AjaxLink editLink = new AjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.editUserSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                SchemaModalPage form = new SchemaModalPage(Schema.this, Schema.this.editUserSchemaWin, schemaTO, false);
                                form.setEntity(SchemaModalPage.Entity.USER);
                                return form;
                            }
                        });
                        Schema.this.editUserSchemaWin.show(target);
                    }
                };
                item.add(new Component[]{editLink});
                AjaxLink deleteLink = new AjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.restClient.deleteUserSchema(schemaTO.getName());
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Schema.this.feedbackPanel);
                        target.addComponent((Component)Schema.this.userSchemaContainer);
                    }
                };
                item.add(new Component[]{deleteLink});
            }
        };
        this.add(new Component[]{new AjaxPagingNavigator("usersSchemaNavigator", (IPageable)userSchemasView)});
        PageableListView userDerSchemasView = new PageableListView("userDerivedSchemas", (IModel)userDerivedSchemas, this.utility.getPaginatorRowsToDisplay("schema")){

            protected void populateItem(final ListItem item) {
                final DerivedSchemaTO schemaTO = (DerivedSchemaTO)item.getDefaultModelObject();
                item.add(new Component[]{new Label("name", schemaTO.getName())});
                item.add(new Component[]{new Label("expression", schemaTO.getExpression())});
                item.add(new Component[]{new Label("attributes", schemaTO.getDerivedAttributes() + "")});
                AjaxLink editLink = new AjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        final DerivedSchemaTO schemaTO = (DerivedSchemaTO)item.getDefaultModelObject();
                        Schema.this.editUserDerivedSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                DerivedSchemaModalPage form = new DerivedSchemaModalPage(Schema.this, Schema.this.editUserSchemaWin, schemaTO, false);
                                form.setEntity(DerivedSchemaModalPage.Entity.USER);
                                return form;
                            }
                        });
                        Schema.this.editUserDerivedSchemaWin.show(target);
                    }
                };
                item.add(new Component[]{editLink});
                AjaxLink deleteLink = new AjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.restClient.deleteUserDerivedSchema(schemaTO.getName());
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Schema.this.feedbackPanel);
                        target.addComponent((Component)Schema.this.userDerivedSchemaContainer);
                    }
                };
                item.add(new Component[]{deleteLink});
            }
        };
        this.add(new Component[]{new AjaxPagingNavigator("usersDerivedSchemaNavigator", (IPageable)userSchemasView)});
        this.add(new Component[]{userDerSchemasView});
        PageableListView membershipSchemasView = new PageableListView("membershipSchemas", (IModel)membershipSchemas, this.utility.getPaginatorRowsToDisplay("schema")){

            protected void populateItem(final ListItem item) {
                final SchemaTO schemaTO = (SchemaTO)item.getDefaultModelObject();
                item.add(new Component[]{new Label("name", schemaTO.getName())});
                item.add(new Component[]{new Label("type", schemaTO.getType().getClassName())});
                item.add(new Component[]{new Label("attributes", schemaTO.getAttributes() + "")});
                AjaxLink editLink = new AjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        final SchemaTO schemaTO = (SchemaTO)item.getDefaultModelObject();
                        Schema.this.editMembershipSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                SchemaModalPage form = new SchemaModalPage(Schema.this, Schema.this.editMembershipSchemaWin, schemaTO, false);
                                form.setEntity(SchemaModalPage.Entity.MEMBERSHIP);
                                return form;
                            }
                        });
                        Schema.this.editMembershipSchemaWin.show(target);
                    }
                };
                item.add(new Component[]{editLink});
                AjaxLink deleteLink = new AjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.restClient.deleteMemberhipSchema(schemaTO.getName());
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Schema.this.feedbackPanel);
                        target.addComponent((Component)Schema.this.membershipSchemaContainer);
                    }
                };
                item.add(new Component[]{deleteLink});
            }
        };
        this.add(new Component[]{new AjaxPagingNavigator("membershipsNavigator", (IPageable)membershipSchemasView)});
        PageableListView membershipDerSchemasView = new PageableListView("membershipDerivedSchemas", (IModel)membershipDerivedSchemas, this.utility.getPaginatorRowsToDisplay("schema")){

            protected void populateItem(final ListItem item) {
                final DerivedSchemaTO schemaTO = (DerivedSchemaTO)item.getDefaultModelObject();
                item.add(new Component[]{new Label("name", schemaTO.getName())});
                item.add(new Component[]{new Label("expression", schemaTO.getExpression())});
                item.add(new Component[]{new Label("attributes", schemaTO.getDerivedAttributes() + "")});
                AjaxLink editLink = new AjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        final DerivedSchemaTO schemaTO = (DerivedSchemaTO)item.getDefaultModelObject();
                        Schema.this.editMembershipDerivedSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                DerivedSchemaModalPage form = new DerivedSchemaModalPage(Schema.this, Schema.this.editMembershipDerivedSchemaWin, schemaTO, false);
                                form.setEntity(DerivedSchemaModalPage.Entity.MEMBERSHIP);
                                return form;
                            }
                        });
                        Schema.this.editMembershipDerivedSchemaWin.show(target);
                    }
                };
                item.add(new Component[]{editLink});
                AjaxLink deleteLink = new AjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.restClient.deleteMembershipDerivedSchema(schemaTO.getName());
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Schema.this.feedbackPanel);
                        target.addComponent((Component)Schema.this.membershipDerivedSchemaContainer);
                    }
                };
                item.add(new Component[]{deleteLink});
            }
        };
        this.add(new Component[]{new AjaxPagingNavigator("membershipsDerNavigator", (IPageable)membershipDerSchemasView)});
        this.roleSchemasContainer = new WebMarkupContainer("roleSchemasContainer");
        this.roleSchemasContainer.add(new Component[]{roleSchemasView});
        this.roleSchemasContainer.setOutputMarkupId(true);
        this.roleDerivedSchemasContainer = new WebMarkupContainer("roleDerivedSchemasContainer");
        this.roleDerivedSchemasContainer.add(new Component[]{roleDerSchemasView});
        this.roleDerivedSchemasContainer.setOutputMarkupId(true);
        this.userSchemaContainer = new WebMarkupContainer("userSchemaContainer");
        this.userSchemaContainer.add(new Component[]{userSchemasView});
        this.userSchemaContainer.setOutputMarkupId(true);
        this.userDerivedSchemaContainer = new WebMarkupContainer("userDerivedSchemaContainer");
        this.userDerivedSchemaContainer.add(new Component[]{userDerSchemasView});
        this.userDerivedSchemaContainer.setOutputMarkupId(true);
        this.membershipSchemaContainer = new WebMarkupContainer("membershipSchemaContainer");
        this.membershipSchemaContainer.add(new Component[]{membershipSchemasView});
        this.membershipSchemaContainer.setOutputMarkupId(true);
        this.membershipDerivedSchemaContainer = new WebMarkupContainer("membershipDerivedSchemaContainer");
        this.membershipDerivedSchemaContainer.add(new Component[]{membershipDerSchemasView});
        this.membershipDerivedSchemaContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.roleSchemasContainer});
        this.add(new Component[]{this.roleDerivedSchemasContainer});
        this.add(new Component[]{this.userSchemaContainer});
        this.add(new Component[]{this.userDerivedSchemaContainer});
        this.add(new Component[]{this.membershipSchemaContainer});
        this.add(new Component[]{this.membershipDerivedSchemaContainer});
        this.createUserSchemaWin.setCssClassName("w_silver");
        this.createUserSchemaWin.setPageMapName("modal-1");
        this.createUserSchemaWin.setCookieName("modal-1");
        this.editUserSchemaWin.setCssClassName("w_silver");
        this.editUserSchemaWin.setPageMapName("modal-2");
        this.editUserSchemaWin.setCookieName("modal-2");
        this.createUserDerivedSchemaWin.setCssClassName("w_silver");
        this.createUserDerivedSchemaWin.setPageMapName("modal-3");
        this.createUserDerivedSchemaWin.setCookieName("modal-3");
        this.editUserDerivedSchemaWin.setCssClassName("w_silver");
        this.editUserDerivedSchemaWin.setPageMapName("modal-4");
        this.editUserDerivedSchemaWin.setCookieName("modal-4");
        this.createRoleSchemaWin.setCssClassName("w_silver");
        this.createRoleSchemaWin.setPageMapName("modal-5");
        this.createRoleSchemaWin.setCookieName("modal-5");
        this.editRoleSchemaWin.setCssClassName("w_silver");
        this.editRoleSchemaWin.setPageMapName("modal-6");
        this.editRoleSchemaWin.setCookieName("modal-6");
        this.createRoleDerivedSchemaWin.setCssClassName("w_silver");
        this.createRoleDerivedSchemaWin.setPageMapName("modal-7");
        this.createRoleDerivedSchemaWin.setCookieName("modal-7");
        this.editRoleDerivedSchemaWin.setCssClassName("w_silver");
        this.editRoleDerivedSchemaWin.setPageMapName("modal-8");
        this.editRoleDerivedSchemaWin.setCookieName("modal-8");
        this.createMembershipSchemaWin.setCssClassName("w_silver");
        this.createMembershipSchemaWin.setPageMapName("modal-9");
        this.createMembershipSchemaWin.setCookieName("modal-9");
        this.createMembershipSchemaWin.setCssClassName("w_silver");
        this.createMembershipSchemaWin.setPageMapName("modal-10");
        this.createMembershipSchemaWin.setCookieName("modal-10");
        this.createMembershipDerivedSchemaWin.setCssClassName("w_silver");
        this.createMembershipDerivedSchemaWin.setPageMapName("modal-11");
        this.createMembershipDerivedSchemaWin.setCookieName("modal-11");
        this.editMembershipDerivedSchemaWin.setCssClassName("w_silver");
        this.editMembershipDerivedSchemaWin.setPageMapName("modal-12");
        this.editMembershipDerivedSchemaWin.setCookieName("modal-12");
        this.setWindowClosedCallback(this.createUserSchemaWin, this.userSchemaContainer);
        this.setWindowClosedCallback(this.editUserSchemaWin, this.userSchemaContainer);
        this.setWindowClosedCallback(this.createUserDerivedSchemaWin, this.userDerivedSchemaContainer);
        this.setWindowClosedCallback(this.editUserDerivedSchemaWin, this.userDerivedSchemaContainer);
        this.setWindowClosedCallback(this.createRoleSchemaWin, this.roleSchemasContainer);
        this.setWindowClosedCallback(this.editRoleSchemaWin, this.roleSchemasContainer);
        this.setWindowClosedCallback(this.createRoleDerivedSchemaWin, this.roleDerivedSchemasContainer);
        this.setWindowClosedCallback(this.editRoleDerivedSchemaWin, this.roleDerivedSchemasContainer);
        this.setWindowClosedCallback(this.createMembershipSchemaWin, this.membershipSchemaContainer);
        this.setWindowClosedCallback(this.editMembershipSchemaWin, this.membershipSchemaContainer);
        this.setWindowClosedCallback(this.createMembershipDerivedSchemaWin, this.membershipDerivedSchemaContainer);
        this.setWindowClosedCallback(this.editMembershipDerivedSchemaWin, this.membershipDerivedSchemaContainer);
        this.add(new Component[]{new AjaxLink("createRoleSchemaWinLink"){

            public void onClick(AjaxRequestTarget target) {
                Schema.this.createRoleSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        SchemaModalPage form = new SchemaModalPage(Schema.this, new ModalWindow("createRoleSchemaWin"), null, true);
                        form.setEntity(SchemaModalPage.Entity.ROLE);
                        return form;
                    }
                });
                Schema.this.createRoleSchemaWin.show(target);
            }
        }});
        this.add(new Component[]{new AjaxLink("createRoleDerivedSchemaWinLink"){

            public void onClick(AjaxRequestTarget target) {
                Schema.this.createRoleDerivedSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        DerivedSchemaModalPage form = new DerivedSchemaModalPage(Schema.this, new ModalWindow("createRoleDerivedSchemaWin"), null, true);
                        form.setEntity(DerivedSchemaModalPage.Entity.ROLE);
                        return form;
                    }
                });
                Schema.this.createRoleDerivedSchemaWin.show(target);
            }
        }});
        this.add(new Component[]{new AjaxLink("createUserSchemaWinLink"){

            public void onClick(AjaxRequestTarget target) {
                Schema.this.createUserSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        SchemaModalPage form = new SchemaModalPage(Schema.this, new ModalWindow("createUserSchemaWin"), null, true);
                        form.setEntity(SchemaModalPage.Entity.USER);
                        return form;
                    }
                });
                Schema.this.createUserSchemaWin.show(target);
            }
        }});
        this.add(new Component[]{new AjaxLink("createUserDerSchemaWinLink"){

            public void onClick(AjaxRequestTarget target) {
                Schema.this.createUserDerivedSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        DerivedSchemaModalPage form = new DerivedSchemaModalPage(Schema.this, new ModalWindow("createUserDerSchemaModalWin"), null, true);
                        form.setEntity(DerivedSchemaModalPage.Entity.USER);
                        return form;
                    }
                });
                Schema.this.createUserDerivedSchemaWin.show(target);
            }
        }});
        this.add(new Component[]{new AjaxLink("createMembershipSchemaWinLink"){

            public void onClick(AjaxRequestTarget target) {
                Schema.this.createMembershipSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        SchemaModalPage form = new SchemaModalPage(Schema.this, new ModalWindow("createMembershipSchemaModalWin"), null, true);
                        form.setEntity(SchemaModalPage.Entity.MEMBERSHIP);
                        return form;
                    }
                });
                Schema.this.createMembershipSchemaWin.show(target);
            }
        }});
        this.add(new Component[]{new AjaxLink("createMembershipDerSchemaWinLink"){

            public void onClick(AjaxRequestTarget target) {
                Schema.this.createMembershipDerivedSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        DerivedSchemaModalPage form = new DerivedSchemaModalPage(Schema.this, new ModalWindow("createMembershipDerivedSchemaWin"), null, true);
                        form.setEntity(DerivedSchemaModalPage.Entity.MEMBERSHIP);
                        return form;
                    }
                });
                Schema.this.createMembershipDerivedSchemaWin.show(target);
            }
        }});
    }

    public void setWindowClosedCallback(ModalWindow window, final WebMarkupContainer container) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                target.addComponent((Component)container);
                if (Schema.this.operationResult) {
                    Schema.this.info(Schema.this.getString("operation_succeded"));
                    target.addComponent((Component)Schema.this.feedbackPanel);
                    Schema.this.operationResult = false;
                }
            }
        });
    }

    public boolean isOperationResult() {
        return this.operationResult;
    }

    public void setOperationResult(boolean operationResult) {
        this.operationResult = operationResult;
    }
}

