/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.ajax.markup.html.navigation.paging.AjaxPagingNavigator;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.list.PageableListView;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.search.AttributeCond;
import org.syncope.client.search.MembershipCond;
import org.syncope.client.search.NodeCond;
import org.syncope.client.to.AttributeTO;
import org.syncope.client.to.ConfigurationTO;
import org.syncope.client.to.RoleTO;
import org.syncope.client.to.RoleTOs;
import org.syncope.client.to.UserTO;
import org.syncope.client.to.UserTOs;
import org.syncope.console.commons.SearchConditionWrapper;
import org.syncope.console.commons.Utility;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.DisplayAttributesModalPage;
import org.syncope.console.pages.UserModalPage;
import org.syncope.console.rest.ConfigurationsRestClient;
import org.syncope.console.rest.RolesRestClient;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.rest.UsersRestClient;
import org.syncope.console.wicket.markup.html.form.UpdatingCheckBox;
import org.syncope.console.wicket.markup.html.form.UpdatingDropDownChoice;
import org.syncope.console.wicket.markup.html.form.UpdatingTextField;

public class Users
extends BasePage {
    @SpringBean(name="usersRestClient")
    private UsersRestClient usersRestClient;
    @SpringBean(name="schemaRestClient")
    private SchemaRestClient schemaRestClient;
    @SpringBean(name="rolesRestClient")
    private RolesRestClient rolesRestClient;
    @SpringBean(name="configurationsRestClient")
    private ConfigurationsRestClient configurationsRestClient;
    @SpringBean(name="utility")
    Utility utility;
    final ModalWindow createUserWin;
    final ModalWindow editUserWin;
    final ModalWindow changeAttribsViewWin;
    final int WIN_ATTRIBUTES_HEIGHT = 515;
    final int WIN_ATTRIBUTES_WIDTH = 775;
    final int WIN_USER_HEIGHT = 680;
    final int WIN_USER_WIDTH = 1133;
    WebMarkupContainer usersContainer;
    List<String> columnsList;
    boolean operationResult = false;
    FeedbackPanel feedbackPanel;
    List<SearchConditionWrapper> searchConditionsList;
    UserTOs searchMatchedUsers;

    public Users(PageParameters parameters) {
        super(parameters);
        this.setupSearchConditionsList();
        this.searchMatchedUsers = new UserTOs();
        Component[] componentArray = new Component[1];
        this.createUserWin = new ModalWindow("createUserWin");
        componentArray[0] = this.createUserWin;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.editUserWin = new ModalWindow("editUserWin");
        componentArray2[0] = this.editUserWin;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.changeAttribsViewWin = new ModalWindow("changeAttributesViewWin");
        componentArray3[0] = this.changeAttribsViewWin;
        this.add(componentArray3);
        this.feedbackPanel = new FeedbackPanel("feedback");
        this.feedbackPanel.setOutputMarkupId(true);
        this.add(new Component[]{this.feedbackPanel});
        LoadableDetachableModel columns = new LoadableDetachableModel(){

            protected Object load() {
                ConfigurationTO configuration = Users.this.configurationsRestClient.readConfiguration("users.attributes.view");
                Users.this.columnsList = new ArrayList<String>();
                if (configuration != null && configuration.getConfValue() != null) {
                    String conf = configuration.getConfValue();
                    StringTokenizer st = new StringTokenizer(conf, ";");
                    while (st.hasMoreTokens()) {
                        Users.this.columnsList.add(st.nextToken());
                    }
                }
                Collections.sort(Users.this.columnsList);
                return Users.this.columnsList;
            }
        };
        ListView columnsView = new ListView("usersSchema", (IModel)columns){

            protected void populateItem(ListItem item) {
                String name = (String)item.getDefaultModelObject();
                item.add(new Component[]{new Label("attribute", name)});
            }
        };
        LoadableDetachableModel users = new LoadableDetachableModel(){

            protected Object load() {
                return Users.this.usersRestClient.getAllUsers().getUsers();
            }
        };
        PageableListView usersView = new PageableListView("users", (IModel)users, this.utility.getPaginatorRowsToDisplay("users")){

            protected void populateItem(final ListItem item) {
                final UserTO userTO = (UserTO)item.getDefaultModelObject();
                item.add(new Component[]{new Label("id", userTO.getId() + "")});
                item.add(new Component[]{new Label("status", userTO.getStatus())});
                if (userTO.getToken() != null && !userTO.getToken().equals("")) {
                    item.add(new Component[]{new Label("token", this.getString("tokenValued"))});
                } else {
                    item.add(new Component[]{new Label("token", this.getString("tokenNotValued"))});
                }
                item.add(new Component[]{new ListView("selectedAttributes", Users.this.attributesToDisplay(userTO)){

                    protected void populateItem(ListItem item) {
                        AttributeWrapper attribute = (AttributeWrapper)item.getDefaultModelObject();
                        for (String name : Users.this.columnsList) {
                            if (!name.equalsIgnoreCase(attribute.getKey())) continue;
                            item.add(new Component[]{new Label("name", attribute.getValue())});
                        }
                    }
                }});
                AjaxLink editLink = new AjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        final UserTO userTO = (UserTO)item.getDefaultModelObject();
                        Users.this.editUserWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                UserModalPage window = new UserModalPage(Users.this, Users.this.editUserWin, userTO, false);
                                return window;
                            }
                        });
                        Users.this.editUserWin.show(target);
                    }
                };
                item.add(new Component[]{editLink});
                AjaxLink deleteLink = new AjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Users.this.usersRestClient.deleteUser(userTO.getId() + "");
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Users.this.feedbackPanel);
                        target.addComponent((Component)Users.this.usersContainer);
                    }
                };
                item.add(new Component[]{deleteLink});
            }
        };
        this.add(new Component[]{new AjaxPagingNavigator("usersNavigator", (IPageable)usersView)});
        this.usersContainer = new WebMarkupContainer("usersContainer");
        this.usersContainer.add(new Component[]{usersView});
        this.usersContainer.add(new Component[]{columnsView});
        this.usersContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.usersContainer});
        this.createUserWin.setCssClassName("w_silver");
        this.createUserWin.setInitialHeight(680);
        this.createUserWin.setInitialWidth(1133);
        this.createUserWin.setPageMapName("create-user-modal");
        this.createUserWin.setCookieName("create-user-modal");
        this.editUserWin.setCssClassName("w_silver");
        this.editUserWin.setInitialHeight(680);
        this.editUserWin.setInitialWidth(680);
        this.editUserWin.setPageMapName("edit-user-modal");
        this.editUserWin.setCookieName("edit-user-modal");
        this.changeAttribsViewWin.setCssClassName("w_silver");
        this.changeAttribsViewWin.setInitialHeight(515);
        this.changeAttribsViewWin.setInitialWidth(775);
        this.changeAttribsViewWin.setPageMapName("change-attribs-modal");
        this.changeAttribsViewWin.setCookieName("change-attribs-modal");
        this.setWindowClosedCallback(this.createUserWin, this.usersContainer);
        this.setWindowClosedCallback(this.editUserWin, this.usersContainer);
        this.setWindowClosedCallback(this.createUserWin, this.usersContainer);
        this.setWindowClosedCallback(this.editUserWin, this.usersContainer);
        this.setWindowClosedCallback(this.changeAttribsViewWin, this.usersContainer);
        this.add(new Component[]{new AjaxLink("createUserLink"){

            public void onClick(AjaxRequestTarget target) {
                Users.this.createUserWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        UserModalPage window = new UserModalPage(Users.this, Users.this.createUserWin, new UserTO(), true);
                        return window;
                    }
                });
                Users.this.createUserWin.show(target);
            }
        }});
        this.add(new Component[]{new AjaxLink("changeAttributesViewLink"){

            public void onClick(AjaxRequestTarget target) {
                Users.this.changeAttribsViewWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        DisplayAttributesModalPage window = new DisplayAttributesModalPage(Users.this, Users.this.changeAttribsViewWin, true);
                        return window;
                    }
                });
                Users.this.changeAttribsViewWin.show(target);
            }
        }});
        LoadableDetachableModel userAttributes = new LoadableDetachableModel(){

            protected Object load() {
                return Users.this.schemaRestClient.getAllUserSchemasNames();
            }
        };
        LoadableDetachableModel roleNames = new LoadableDetachableModel(){

            protected Object load() {
                RoleTOs roleTOs = Users.this.rolesRestClient.getAllRoles();
                ArrayList<String> roleNames = new ArrayList<String>();
                for (RoleTO role : roleTOs) {
                    roleNames.add(role.getName());
                }
                return roleNames;
            }
        };
        LoadableDetachableModel attributeTypes = new LoadableDetachableModel(){

            protected Object load() {
                return Arrays.asList(AttributeCond.Type.values());
            }
        };
        LoadableDetachableModel filterTypes = new LoadableDetachableModel(){

            protected Object load() {
                return Arrays.asList(SearchConditionWrapper.FilterType.values());
            }
        };
        Form form = new Form("UserSearchForm");
        form.add(new Component[]{new FeedbackPanel("feedback").setOutputMarkupId(true)});
        final WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        ListView searchView = new ListView("searchView", this.searchConditionsList, (IModel)userAttributes, (IModel)roleNames, (IModel)attributeTypes, (IModel)filterTypes, container){
            final /* synthetic */ IModel val$userAttributes;
            final /* synthetic */ IModel val$roleNames;
            final /* synthetic */ IModel val$attributeTypes;
            final /* synthetic */ IModel val$filterTypes;
            final /* synthetic */ WebMarkupContainer val$container;
            {
                this.val$userAttributes = iModel;
                this.val$roleNames = iModel2;
                this.val$attributeTypes = iModel3;
                this.val$filterTypes = iModel4;
                this.val$container = webMarkupContainer;
                super(x0, x1);
            }

            protected void populateItem(ListItem item) {
                final SearchConditionWrapper searchCondition = (SearchConditionWrapper)item.getDefaultModelObject();
                if (item.getIndex() == 0) {
                    item.add(new Component[]{new Label("operationType", "")});
                } else {
                    item.add(new Component[]{new Label("operationType", searchCondition.getOperationType().toString())});
                }
                item.add(new Component[]{new UpdatingCheckBox("notOperator", (IModel<Boolean>)new PropertyModel((Object)searchCondition, "notOperator"))});
                final UpdatingDropDownChoice filterNameChooser = new UpdatingDropDownChoice("filterName", new PropertyModel((Object)searchCondition, "filterName"), null);
                if (searchCondition.getFilterType() == null) {
                    filterNameChooser.setChoices(Collections.emptyList());
                } else if (searchCondition.getFilterType() == SearchConditionWrapper.FilterType.ATTRIBUTE) {
                    filterNameChooser.setChoices(this.val$userAttributes);
                } else {
                    filterNameChooser.setChoices(this.val$roleNames);
                }
                filterNameChooser.setRequired(true);
                item.add(new Component[]{filterNameChooser});
                UpdatingDropDownChoice type = new UpdatingDropDownChoice("type", new PropertyModel((Object)searchCondition, "type"), this.val$attributeTypes);
                item.add(new Component[]{type});
                UpdatingTextField filterValue = new UpdatingTextField("filterValue", (IModel)new PropertyModel((Object)searchCondition, "filterValue"));
                item.add(new Component[]{filterValue});
                if (searchCondition.getFilterType() == SearchConditionWrapper.FilterType.MEMBERSHIP) {
                    type.setEnabled(false);
                    type.setRequired(false);
                    type.setModelObject(null);
                    filterValue.setEnabled(false);
                    filterValue.setModelObject("");
                } else {
                    if (!type.isEnabled()) {
                        type.setEnabled(true);
                        type.setRequired(true);
                    }
                    if (!filterValue.isEnabled()) {
                        filterValue.setEnabled(true);
                    }
                }
                UpdatingDropDownChoice filterTypeChooser = new UpdatingDropDownChoice("filterType", new PropertyModel((Object)searchCondition, "filterType"), this.val$filterTypes);
                filterTypeChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

                    protected void onUpdate(AjaxRequestTarget target) {
                        filterNameChooser.setChoices((IModel)new LoadableDetachableModel(){

                            protected Object load() {
                                SearchConditionWrapper.FilterType schemaType = searchCondition.getFilterType();
                                if (schemaType == SearchConditionWrapper.FilterType.ATTRIBUTE) {
                                    return val$userAttributes;
                                }
                                return val$roleNames;
                            }
                        });
                        target.addComponent((Component)filterNameChooser);
                        target.addComponent((Component)val$container);
                    }
                }});
                filterTypeChooser.setRequired(true);
                item.add(new Component[]{filterTypeChooser});
                AjaxButton dropButton = new AjaxButton("dropButton", (IModel)new Model((Serializable)((Object)this.getString("dropButton")))){

                    protected void onSubmit(AjaxRequestTarget target, Form form) {
                        int parentId = new Integer(this.getParent().getId());
                        Users.this.searchConditionsList.remove(parentId);
                        target.addComponent((Component)val$container);
                    }
                };
                dropButton.setDefaultFormProcessing(false);
                if (item.getIndex() == 0) {
                    dropButton.setVisible(false);
                }
                item.add(new Component[]{dropButton});
            }
        };
        container.add(new Component[]{searchView});
        AjaxButton addAndButton = new AjaxButton("addAndButton", (IModel)new Model((Serializable)((Object)this.getString("addAndButton")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                SearchConditionWrapper conditionWrapper = new SearchConditionWrapper();
                conditionWrapper.setOperationType(SearchConditionWrapper.OperationType.AND);
                Users.this.searchConditionsList.add(conditionWrapper);
                target.addComponent((Component)container);
            }
        };
        addAndButton.setDefaultFormProcessing(false);
        container.add(new Component[]{addAndButton});
        AjaxButton addOrButton = new AjaxButton("addOrButton", (IModel)new Model((Serializable)((Object)this.getString("addOrButton")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                SearchConditionWrapper conditionWrapper = new SearchConditionWrapper();
                conditionWrapper.setOperationType(SearchConditionWrapper.OperationType.OR);
                Users.this.searchConditionsList.add(conditionWrapper);
                target.addComponent((Component)container);
            }
        };
        addOrButton.setDefaultFormProcessing(false);
        container.add(new Component[]{addOrButton});
        form.add(new Component[]{container});
        LoadableDetachableModel resultsModel = new LoadableDetachableModel(){

            protected Object load() {
                return Users.this.searchMatchedUsers.getUsers();
            }
        };
        ListView resultsView = new ListView("results", (IModel)resultsModel){

            protected void populateItem(final ListItem item) {
                UserTO userTO = (UserTO)item.getModelObject();
                item.add(new Component[]{new Label("id", String.valueOf(userTO.getId()))});
                item.add(new Component[]{new Label("status", String.valueOf(userTO.getStatus()))});
                if (userTO.getToken() != null && !userTO.getToken().equals("")) {
                    item.add(new Component[]{new Label("token", this.getString("tokenValued"))});
                } else {
                    item.add(new Component[]{new Label("token", this.getString("tokenNotValued"))});
                }
                AjaxButton editButton = new AjaxButton("editLink", (IModel)new Model((Serializable)((Object)this.getString("edit")))){

                    protected void onSubmit(AjaxRequestTarget target, Form form) {
                        final UserTO userTO = (UserTO)item.getDefaultModelObject();
                        Users.this.editUserWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                UserModalPage window = new UserModalPage(Users.this, Users.this.editUserWin, userTO, false);
                                return window;
                            }
                        });
                        Users.this.editUserWin.show(target);
                    }
                };
                item.add(new Component[]{editButton});
                item.add(new Component[]{new AjaxButton("deleteLink", (IModel)new Model((Serializable)((Object)this.getString("delete")))){

                    protected void onSubmit(AjaxRequestTarget target, Form form) {
                    }
                }});
            }
        };
        final WebMarkupContainer searchResultsContainer = new WebMarkupContainer("searchResultsContainer");
        searchResultsContainer.setOutputMarkupId(true);
        searchResultsContainer.add(new Component[]{resultsView});
        this.setWindowClosedCallback(this.editUserWin, searchResultsContainer);
        form.add(new Component[]{new AjaxButton("search", (IModel)new Model((Serializable)((Object)this.getString("search")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                NodeCond nodeCond = Users.this.buildSearchExpression(Users.this.searchConditionsList);
                if (nodeCond != null) {
                    try {
                        Users.this.searchMatchedUsers = Users.this.usersRestClient.searchUsers(nodeCond);
                        target.addComponent(form.get("feedback"));
                    }
                    catch (Exception e) {
                        this.error((Serializable)((Object)e.getMessage()));
                        return;
                    }
                } else {
                    this.error((Serializable)((Object)this.getString("search_error")));
                }
                target.addComponent((Component)searchResultsContainer);
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent(form.get("feedback"));
            }
        }});
        form.add(new Component[]{searchResultsContainer});
        this.add(new Component[]{form});
    }

    public List<AttributeWrapper> attributesToDisplay(UserTO user) {
        Set attributes = user.getAttributes();
        ArrayList<AttributeWrapper> attributesList = new ArrayList<AttributeWrapper>();
        ConfigurationTO configuration = this.configurationsRestClient.readConfiguration("users.attributes.view");
        this.columnsList = new ArrayList<String>();
        if (configuration != null && configuration.getConfValue() != null && !configuration.getConfValue().equals("")) {
            String conf = configuration.getConfValue();
            StringTokenizer st = new StringTokenizer(conf, ";");
            while (st.hasMoreTokens()) {
                this.columnsList.add(st.nextToken());
            }
        }
        Collections.sort(this.columnsList);
        AttributeWrapper attributeWrapper = null;
        boolean found = false;
        for (String name : this.columnsList) {
            for (AttributeTO attribute : attributes) {
                if (!name.equals(attribute.getSchema()) || found) continue;
                attributeWrapper = new AttributeWrapper();
                attributeWrapper.setKey(attribute.getSchema());
                for (String value : attribute.getValues()) {
                    attributeWrapper.setValue(value);
                    found = true;
                }
                attributesList.add(attributeWrapper);
            }
            if (!found) {
                attributeWrapper = new AttributeWrapper();
                attributeWrapper.setKey(name);
                attributeWrapper.setValue("");
                attributesList.add(attributeWrapper);
                continue;
            }
            found = false;
        }
        return attributesList;
    }

    public void setWindowClosedCallback(ModalWindow window, final WebMarkupContainer container) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                target.addComponent((Component)container);
                if (Users.this.operationResult) {
                    Users.this.info(Users.this.getString("operation_succeded"));
                    target.addComponent((Component)Users.this.feedbackPanel);
                    Users.this.operationResult = false;
                } else {
                    target.addComponent((Component)Users.this.feedbackPanel);
                }
            }
        });
    }

    public boolean isOperationResult() {
        return this.operationResult;
    }

    public void setOperationResult(boolean operationResult) {
        this.operationResult = operationResult;
    }

    private void setupSearchConditionsList() {
        this.searchConditionsList = new ArrayList<SearchConditionWrapper>();
        this.searchConditionsList.add(new SearchConditionWrapper());
    }

    public NodeCond buildSearchExpression(List<SearchConditionWrapper> conditions) {
        AttributeCond attributeCond = null;
        MembershipCond membershipCond = null;
        List<SearchConditionWrapper> subList = null;
        SearchConditionWrapper searchConditionWrapper = conditions.iterator().next();
        if (searchConditionWrapper.getFilterType() == SearchConditionWrapper.FilterType.ATTRIBUTE) {
            attributeCond = new AttributeCond();
            attributeCond.setSchema(searchConditionWrapper.getFilterName());
            attributeCond.setType(searchConditionWrapper.getType());
            attributeCond.setExpression(searchConditionWrapper.getFilterValue());
        } else {
            membershipCond = new MembershipCond();
            membershipCond.setRoleName(searchConditionWrapper.getFilterName());
        }
        if (conditions.size() == 1) {
            if (searchConditionWrapper.getFilterType() == SearchConditionWrapper.FilterType.ATTRIBUTE) {
                if (searchConditionWrapper.isNotOperator()) {
                    return NodeCond.getNotLeafCond((AttributeCond)attributeCond);
                }
                return NodeCond.getLeafCond((AttributeCond)attributeCond);
            }
            if (searchConditionWrapper.isNotOperator()) {
                return NodeCond.getNotLeafCond((MembershipCond)membershipCond);
            }
            return NodeCond.getLeafCond((MembershipCond)membershipCond);
        }
        subList = conditions.subList(1, conditions.size());
        searchConditionWrapper = subList.iterator().next();
        if (searchConditionWrapper.getOperationType() == SearchConditionWrapper.OperationType.AND) {
            if (searchConditionWrapper.getFilterType() == SearchConditionWrapper.FilterType.ATTRIBUTE) {
                if (attributeCond != null) {
                    return NodeCond.getAndCond((NodeCond)NodeCond.getLeafCond((AttributeCond)attributeCond), (NodeCond)this.buildSearchExpression(new ArrayList<SearchConditionWrapper>(subList)));
                }
                return NodeCond.getAndCond((NodeCond)NodeCond.getLeafCond((MembershipCond)membershipCond), (NodeCond)this.buildSearchExpression(new ArrayList<SearchConditionWrapper>(subList)));
            }
            if (attributeCond != null) {
                return NodeCond.getAndCond((NodeCond)NodeCond.getLeafCond((AttributeCond)attributeCond), (NodeCond)this.buildSearchExpression(new ArrayList<SearchConditionWrapper>(subList)));
            }
            return NodeCond.getAndCond((NodeCond)NodeCond.getLeafCond((MembershipCond)membershipCond), (NodeCond)this.buildSearchExpression(new ArrayList<SearchConditionWrapper>(subList)));
        }
        if (searchConditionWrapper.getFilterType() == SearchConditionWrapper.FilterType.ATTRIBUTE) {
            if (attributeCond != null) {
                return NodeCond.getOrCond((NodeCond)NodeCond.getLeafCond((AttributeCond)attributeCond), (NodeCond)this.buildSearchExpression(new ArrayList<SearchConditionWrapper>(subList)));
            }
            return NodeCond.getOrCond((NodeCond)NodeCond.getLeafCond((MembershipCond)membershipCond), (NodeCond)this.buildSearchExpression(new ArrayList<SearchConditionWrapper>(subList)));
        }
        if (attributeCond != null) {
            return NodeCond.getOrCond((NodeCond)NodeCond.getLeafCond((AttributeCond)attributeCond), (NodeCond)this.buildSearchExpression(new ArrayList<SearchConditionWrapper>(subList)));
        }
        return NodeCond.getOrCond((NodeCond)NodeCond.getLeafCond((MembershipCond)membershipCond), (NodeCond)this.buildSearchExpression(new ArrayList<SearchConditionWrapper>(subList)));
    }

    public class AttributeWrapper {
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

