/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.rest;

import org.springframework.web.client.HttpServerErrorException;
import org.syncope.client.mod.UserMod;
import org.syncope.client.search.NodeCond;
import org.syncope.client.to.ConfigurationTO;
import org.syncope.client.to.UserTO;
import org.syncope.client.to.UserTOs;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.rest.RestClient;

public class UsersRestClient {
    protected RestClient restClient;

    public UserTOs getAllUsers() {
        UserTOs users = null;
        try {
            users = (UserTOs)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "user/list.json", UserTOs.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
        return users;
    }

    public void createUser(UserTO userTO) {
        try {
            UserTO newUserTO = (UserTO)this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "user/create", (Object)userTO, UserTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public boolean updateUser(UserMod userModTO) {
        UserTO newUserTO = null;
        try {
            newUserTO = (UserTO)this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "user/update", (Object)userModTO, UserTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
            throw e;
        }
        return userModTO.getId() == newUserTO.getId();
    }

    public void deleteUser(String id) {
        try {
            this.restClient.getRestTemplate().delete(this.restClient.getBaseURL() + "user/delete/{userId}", new Object[]{new Integer(id)});
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
    }

    public UserTO getUser(String id) {
        UserTO userTO = null;
        try {
            userTO = (UserTO)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "user/read/{userId}.json", UserTO.class, new Object[]{id});
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
        return userTO;
    }

    public boolean createConfigurationAttributes(ConfigurationTO configurationTO) {
        ConfigurationTO newConfigurationTO = (ConfigurationTO)this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "configuration/create", (Object)configurationTO, ConfigurationTO.class, new Object[0]);
        return configurationTO.equals((Object)newConfigurationTO);
    }

    public boolean updateConfigurationAttributes(ConfigurationTO configurationTO) {
        ConfigurationTO newConfigurationTO = (ConfigurationTO)this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "configuration/update", (Object)configurationTO, ConfigurationTO.class, new Object[0]);
        return configurationTO.equals((Object)newConfigurationTO);
    }

    public ConfigurationTO readConfigurationDisplayAttributes() {
        ConfigurationTO configurationTO;
        try {
            configurationTO = (ConfigurationTO)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "configuration/read/{confKey}", ConfigurationTO.class, new Object[]{"users.attributes.view"});
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
            return null;
        }
        return configurationTO;
    }

    public UserTOs searchUsers(NodeCond nodeSearchCondition) {
        UserTOs matchedUsers = null;
        try {
            matchedUsers = (UserTOs)this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "user/search", (Object)nodeSearchCondition, UserTOs.class, new Object[0]);
        }
        catch (HttpServerErrorException e) {
            e.printStackTrace();
            throw e;
        }
        return matchedUsers;
    }

    public RestClient getRestClient() {
        return this.restClient;
    }

    public void setRestClient(RestClient restClient) {
        this.restClient = restClient;
    }
}

