/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.RadioChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;
import org.syncope.client.to.SchemaTO;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.Schema;
import org.syncope.console.pages.SyncopeModalPage;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.types.SchemaValueType;

public class SchemaModalPage
extends SyncopeModalPage {
    public TextField name;
    public TextField conversionPattern;
    public DropDownChoice validatorClass;
    public DropDownChoice type;
    public DropDownChoice action;
    public AutoCompleteTextField mandatoryCondition;
    public RadioChoice virtual;
    public RadioChoice multivalue;
    public RadioChoice readonly;
    public AjaxButton submit;
    public Entity entity;
    @SpringBean(name="schemaRestClient")
    SchemaRestClient restClient;

    public SchemaModalPage(final BasePage basePage, final ModalWindow window, SchemaTO schema, final boolean createFlag) {
        if (schema == null) {
            schema = new SchemaTO();
        }
        Form schemaForm = new Form("SchemaForm");
        schemaForm.setModel((IModel)new CompoundPropertyModel((Object)schema));
        this.name = new TextField("name");
        this.name.setRequired(true);
        this.name.setEnabled(createFlag);
        this.conversionPattern = new TextField("conversionPattern");
        ArrayList<String> validatorsList = new ArrayList<String>();
        validatorsList.add("org.syncope.core.persistence.validation.AlwaysTrueValidator");
        validatorsList.add("org.syncope.core.persistence.validation.EmailAddressValidator");
        this.validatorClass = new DropDownChoice("validatorClass", (IModel)new PropertyModel((Object)schema, "validatorClass"), validatorsList);
        this.type = new DropDownChoice("type", Arrays.asList(SchemaValueType.values()));
        this.type.setRequired(true);
        this.mandatoryCondition = new AutoCompleteTextField("mandatoryCondition"){

            protected Iterator getChoices(String input) {
                List<Object> choices = new ArrayList();
                if (Strings.isEmpty((CharSequence)input)) {
                    choices = Collections.emptyList();
                    return choices.iterator();
                }
                if ("true".startsWith(input.toLowerCase())) {
                    choices.add("true");
                } else if ("false".startsWith(input.toLowerCase())) {
                    choices.add("false");
                }
                return choices.iterator();
            }
        };
        this.virtual = new RadioChoice("virtual", Arrays.asList(true, false));
        this.multivalue = new RadioChoice("multivalue", Arrays.asList(true, false));
        this.readonly = new RadioChoice("readonly", Arrays.asList(true, false));
        this.submit = new IndicatingAjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                if (SchemaModalPage.this.getEntity() == Entity.USER) {
                    if (createFlag) {
                        SchemaModalPage.this.restClient.createUserSchema((SchemaTO)form.getDefaultModelObject());
                    } else {
                        SchemaModalPage.this.restClient.updateUserSchema((SchemaTO)form.getDefaultModelObject());
                    }
                } else if (SchemaModalPage.this.getEntity() == Entity.ROLE) {
                    if (createFlag) {
                        SchemaModalPage.this.restClient.createRoleSchema((SchemaTO)form.getDefaultModelObject());
                    } else {
                        SchemaModalPage.this.restClient.updateRoleSchema((SchemaTO)form.getDefaultModelObject());
                    }
                } else if (SchemaModalPage.this.getEntity() == Entity.MEMBERSHIP) {
                    if (createFlag) {
                        SchemaModalPage.this.restClient.createMemberhipSchema((SchemaTO)form.getDefaultModelObject());
                    } else {
                        SchemaModalPage.this.restClient.updateMemberhipSchema((SchemaTO)form.getDefaultModelObject());
                    }
                }
                Schema callerPage = (Schema)basePage;
                callerPage.setOperationResult(true);
                window.close(target);
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent(form.get("feedback"));
            }
        };
        String allowedRoles = createFlag ? this.xmlRolesReader.getAllAllowedRoles("Schema", "create") : this.xmlRolesReader.getAllAllowedRoles("Schema", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.submit, (Action)ENABLE, (String)allowedRoles);
        schemaForm.add(new Component[]{new FeedbackPanel("feedback").setOutputMarkupId(true)});
        schemaForm.add(new Component[]{this.name});
        schemaForm.add(new Component[]{this.conversionPattern});
        schemaForm.add(new Component[]{this.validatorClass});
        schemaForm.add(new Component[]{this.type});
        schemaForm.add(new Component[]{this.mandatoryCondition});
        schemaForm.add(new Component[]{this.virtual});
        schemaForm.add(new Component[]{this.multivalue});
        schemaForm.add(new Component[]{this.readonly});
        schemaForm.add(new Component[]{this.submit});
        this.add(new Component[]{schemaForm});
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public static enum Entity {
        USER,
        ROLE,
        MEMBERSHIP;

    }
}

