/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxPreprocessingCallDecorator;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.datetime.DateConverter;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.syncope.client.to.TaskExecutionTO;
import org.syncope.client.to.TaskTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.SyncopeApplication;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.SyncopeModalPage;
import org.syncope.console.rest.TasksRestClient;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.LinkPanel;

public class TaskModalPage
extends SyncopeModalPage {
    public TextField id;
    public TextField accountId;
    public TextField resource;
    public Label dialogContent;
    TasksRestClient taskRestClient = (TasksRestClient)((SyncopeApplication)Application.get()).getApplicationContext().getBean("tasksRestClient");
    WebMarkupContainer container;

    public TaskModalPage(BasePage basePage, ModalWindow window, TaskTO taskTO) {
        this.dialogContent = new Label("dialogContent", (IModel)new Model((Serializable)((Object)"")));
        this.add(new Component[]{this.dialogContent.setOutputMarkupId(true)});
        final Form form = new Form("TaskForm");
        form.add(new Component[]{new FeedbackPanel("feedback").setOutputMarkupId(true)});
        form.setModel((IModel)new CompoundPropertyModel((Object)taskTO));
        this.id = new TextField("id");
        this.id.setEnabled(false);
        form.add(new Component[]{this.id});
        this.accountId = new TextField("accountId");
        this.accountId.setEnabled(false);
        form.add(new Component[]{this.accountId});
        this.resource = new TextField("resource");
        this.resource.setEnabled(false);
        form.add(new Component[]{this.resource});
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("id"))), "id", "id"));
        columns.add((Object)new DatePropertyColumn((IModel<String>)new Model((Serializable)((Object)this.getString("startDate"))), "startDate", "startDate", null));
        columns.add((Object)new DatePropertyColumn((IModel<String>)new Model((Serializable)((Object)this.getString("endDate"))), "endDate", "endDate", null));
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("status"))), "status", "status"));
        columns.add(new AbstractColumn<TaskExecutionTO>((IModel)new Model((Serializable)((Object)this.getString("message")))){

            public void populateItem(Item<ICellPopulator<TaskExecutionTO>> cellItem, String componentId, IModel<TaskExecutionTO> model) {
                final TaskExecutionTO taskExecutionTO = (TaskExecutionTO)model.getObject();
                AjaxLink messageLink = new AjaxLink("link"){

                    public void onClick(AjaxRequestTarget target) {
                        TaskModalPage.this.dialogContent.setDefaultModelObject((Object)taskExecutionTO.getMessage());
                        target.addComponent((Component)TaskModalPage.this.dialogContent);
                        target.appendJavascript("jQuery('#dialog').dialog('open')");
                    }
                };
                messageLink.add(new Component[]{new Label("linkTitle", TaskModalPage.this.getString("showMessage"))});
                LinkPanel panel = new LinkPanel(componentId);
                panel.add(new Component[]{messageLink});
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<TaskExecutionTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<TaskExecutionTO>> cellItem, String componentId, IModel<TaskExecutionTO> model) {
                final TaskExecutionTO taskExecutionTO = (TaskExecutionTO)model.getObject();
                AjaxLink deleteLink = new AjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        boolean res = false;
                        try {
                            res = TaskModalPage.this.taskRestClient.deleteTaskExecution(taskExecutionTO.getId());
                        }
                        catch (SyncopeClientCompositeErrorException scce) {
                            this.error((Serializable)((Object)scce.getMessage()));
                        }
                        if (res) {
                            this.info(this.getString("operation_succeded"));
                        }
                        target.addComponent(form.get("feedback"));
                        target.addComponent((Component)TaskModalPage.this.container);
                    }

                    protected IAjaxCallDecorator getAjaxCallDecorator() {
                        return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){
                            private static final long serialVersionUID = 1L;

                            public CharSequence preDecorateScript(CharSequence script) {
                                return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "}";
                            }
                        };
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                panel.add(new Component[]{deleteLink});
                String allowedRoles = null;
                allowedRoles = TaskModalPage.this.xmlRolesReader.getAllAllowedRoles("Tasks", "delete");
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedRoles);
                cellItem.add(new Component[]{panel});
            }
        });
        AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("executionsTable", columns, (ISortableDataProvider)new TaskExecutionsProvider(taskTO), 10);
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{table});
        this.container.setOutputMarkupId(true);
        form.add(new Component[]{this.container});
        this.add(new Component[]{form});
    }

    public class DatePropertyColumn<T>
    extends PropertyColumn<T> {
        private static final long serialVersionUID = 1L;

        public DatePropertyColumn(IModel<String> displayModel, String sortProperty, String propertyExpression, DateConverter converter) {
            super(displayModel, sortProperty, propertyExpression);
        }

        public void populateItem(Item<ICellPopulator<T>> item, String componentId, IModel<T> rowModel) {
            IModel date = this.createLabelModel(rowModel);
            item.add(new Component[]{new Label(componentId, date.getObject().toString())});
        }
    }

    class TaskExecutionsProvider
    extends SortableDataProvider<TaskExecutionTO> {
        private SortableDataProviderComparator comparator = new SortableDataProviderComparator();
        private TaskTO taskTO;

        public TaskExecutionsProvider(TaskTO taskTO) {
            this.taskTO = taskTO;
            this.setSort("startDate", true);
        }

        public Iterator<TaskExecutionTO> iterator(int first, int count) {
            List<TaskExecutionTO> list = this.getTasksListDB();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return this.getTasksListDB().size();
        }

        public IModel<TaskExecutionTO> model(final TaskExecutionTO taskExecution) {
            return new AbstractReadOnlyModel<TaskExecutionTO>(){

                public TaskExecutionTO getObject() {
                    return taskExecution;
                }
            };
        }

        public List<TaskExecutionTO> getTasksListDB() {
            return this.taskTO.getExecutions();
        }

        class SortableDataProviderComparator
        implements Comparator<TaskExecutionTO>,
        Serializable {
            SortableDataProviderComparator() {
            }

            @Override
            public int compare(TaskExecutionTO o1, TaskExecutionTO o2) {
                PropertyModel model1 = new PropertyModel((Object)o1, TaskExecutionsProvider.this.getSort().getProperty());
                PropertyModel model2 = new PropertyModel((Object)o2, TaskExecutionsProvider.this.getSort().getProperty());
                int result = 1;
                result = model1.getObject() == null && model2.getObject() == null ? 0 : (model1.getObject() == null ? 1 : (model2.getObject() == null ? -1 : ((Comparable)model1.getObject()).compareTo(model2.getObject())));
                result = TaskExecutionsProvider.this.getSort().isAscending() ? result : -result;
                return result;
            }
        }
    }
}

