/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.wicket.markup.html.tree;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxPreprocessingCallDecorator;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.RoleTO;
import org.syncope.console.commons.XMLRolesReader;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.RoleModalPage;
import org.syncope.console.pages.Roles;
import org.syncope.console.rest.RolesRestClient;

public class NodeEditablePanel
extends Panel {
    @SpringBean(name="rolesRestClient")
    RolesRestClient restClient;
    @SpringBean(name="xmlRolesReader")
    protected XMLRolesReader xmlRolesReader;
    Fragment fragment;

    public NodeEditablePanel(String id, final Long idRole, IModel inputModel, final ModalWindow window, final BasePage basePage) {
        super(id);
        if (idRole == -1L) {
            this.fragment = new Fragment("menuPanel", "frag2", (MarkupContainer)this);
        } else {
            this.fragment = new Fragment("menuPanel", "frag1", (MarkupContainer)this);
            AjaxLink createRoleLink = new AjaxLink("createRoleLink"){

                public void onClick(AjaxRequestTarget target) {
                    window.setPageCreator(new ModalWindow.PageCreator(){

                        public Page createPage() {
                            RoleTO roleTO = new RoleTO();
                            roleTO.setParent(idRole.longValue());
                            RoleModalPage form = new RoleModalPage(basePage, window, roleTO, true);
                            return form;
                        }
                    });
                    window.show(target);
                }
            };
            String allowedCreateRoles = this.xmlRolesReader.getAllAllowedRoles("Roles", "create");
            MetaDataRoleAuthorizationStrategy.authorize((Component)createRoleLink, (Action)ENABLE, (String)allowedCreateRoles);
            this.fragment.add(new Component[]{createRoleLink});
            AjaxLink updateRoleLink = new AjaxLink("updateRoleLink"){

                public void onClick(AjaxRequestTarget target) {
                    window.setPageCreator(new ModalWindow.PageCreator(){

                        public Page createPage() {
                            RoleTO roleTO = NodeEditablePanel.this.restClient.readRole(idRole);
                            RoleModalPage form = new RoleModalPage(basePage, window, roleTO, false);
                            return form;
                        }
                    });
                    window.show(target);
                }
            };
            String allowedReadRoles = this.xmlRolesReader.getAllAllowedRoles("Roles", "read");
            MetaDataRoleAuthorizationStrategy.authorize((Component)updateRoleLink, (Action)ENABLE, (String)allowedReadRoles);
            this.fragment.add(new Component[]{updateRoleLink});
            AjaxLink dropRoleLink = new AjaxLink("dropRoleLink"){

                public void onClick(AjaxRequestTarget target) {
                    NodeEditablePanel.this.restClient.deleteRole(idRole);
                    this.getSession().info(this.getString("operation_succeded"));
                    this.setResponsePage((Page)new Roles(null));
                }

                protected IAjaxCallDecorator getAjaxCallDecorator() {
                    return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){
                        private static final long serialVersionUID = 1L;

                        public CharSequence preDecorateScript(CharSequence script) {
                            return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "}";
                        }
                    };
                }
            };
            String allowedDropRoles = this.xmlRolesReader.getAllAllowedRoles("Roles", "delete");
            MetaDataRoleAuthorizationStrategy.authorize((Component)dropRoleLink, (Action)ENABLE, (String)allowedDropRoles);
            this.fragment.add(new Component[]{dropRoleLink});
        }
        this.add(new Component[]{this.fragment});
    }
}

