/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.wicket.markup.html.tree;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.springframework.web.client.RestClientException;
import org.syncope.client.to.RoleTO;
import org.syncope.console.rest.RolesRestClient;
import org.syncope.console.wicket.markup.html.tree.SyncopeTreeNode;
import org.syncope.console.wicket.markup.html.tree.TreeModelBean;

public class SyncopeRoleTree {
    List<Long> parentsId;
    RolesRestClient restClient;

    public SyncopeRoleTree(RolesRestClient restClient) {
        this.restClient = restClient;
    }

    public TreeModel createTreeModel() throws RestClientException {
        List<RoleTO> roles = this.restClient.getAllRoles();
        ArrayList<SyncopeTreeNode> roleTree = new ArrayList<SyncopeTreeNode>();
        ArrayList<SyncopeTreeNode> parentNodes = new ArrayList<SyncopeTreeNode>();
        ArrayList<SyncopeTreeNode> childNodes = new ArrayList<SyncopeTreeNode>();
        this.parentsId = new ArrayList<Long>();
        for (RoleTO role : roles) {
            if (this.parentExists(role.getParent(), this.parentsId)) continue;
            this.parentsId.add(role.getParent());
        }
        for (RoleTO role : roles) {
            for (Long parentId : this.parentsId) {
                if (role.getId() != parentId.longValue()) continue;
                SyncopeTreeNode parentNode = new SyncopeTreeNode();
                parentNode.setId(role.getId());
                parentNode.setParentId(role.getParent());
                parentNode.setName(role.getName());
                parentNodes.add(parentNode);
            }
        }
        for (RoleTO role : roles) {
            if (this.parentExists(role.getId(), this.parentsId)) continue;
            SyncopeTreeNode childNode = new SyncopeTreeNode();
            childNode.setId(role.getId());
            childNode.setName(role.getName());
            childNode.setParentId(role.getParent());
            childNodes.add(childNode);
        }
        for (SyncopeTreeNode node : childNodes) {
            this.addChildToParent(parentNodes, node);
        }
        for (SyncopeTreeNode node : parentNodes) {
            this.addChildToParent(roleTree, node);
        }
        return this.convertToTreeModel(roleTree);
    }

    public boolean parentExists(Long parentId, List<Long> list) {
        boolean found = false;
        for (Long id : list) {
            if (found || id != parentId) continue;
            found = true;
        }
        return found;
    }

    public List<SyncopeTreeNode> addChildToParent(List<SyncopeTreeNode> nodes, SyncopeTreeNode child) {
        if (nodes.size() == 0) {
            nodes.add(child);
            return nodes;
        }
        if (child.getParentId() == child.getId()) {
            return nodes;
        }
        for (SyncopeTreeNode item : nodes) {
            if (item.getId() == child.getParentId()) {
                item.getChildren().add(child);
                break;
            }
            if (item.getId() == child.getParentId() || item.getChildren().size() <= 0) continue;
            this.addChildToParent(item.getChildren(), child);
        }
        return nodes;
    }

    public TreeModel convertToTreeModel(List<SyncopeTreeNode> list) {
        DefaultTreeModel model = null;
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(new TreeModelBean("Root"));
        this.add(rootNode, list);
        model = new DefaultTreeModel(rootNode);
        return model;
    }

    public void add(DefaultMutableTreeNode parent, List<SyncopeTreeNode> sub) {
        for (SyncopeTreeNode node : sub) {
            DefaultMutableTreeNode child;
            if (node.getChildren().size() > 0) {
                child = new DefaultMutableTreeNode(new TreeModelBean(node));
                parent.add(child);
                this.add(child, node.getChildren());
                continue;
            }
            child = new DefaultMutableTreeNode(new TreeModelBean(node));
            parent.add(child);
        }
    }
}

