/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console;

import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.Session;
import org.apache.wicket.application.IComponentInstantiationListener;
import org.apache.wicket.authentication.AuthenticatedWebApplication;
import org.apache.wicket.authentication.AuthenticatedWebSession;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authorization.strategies.role.IRoleCheckingStrategy;
import org.apache.wicket.authorization.strategies.role.RoleAuthorizationStrategy;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.spring.injection.annot.SpringComponentInjector;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.syncope.console.SyncopeRequestCycle;
import org.syncope.console.SyncopeRolesAuthorizer;
import org.syncope.console.SyncopeSession;
import org.syncope.console.SyncopeUser;
import org.syncope.console.pages.Configuration;
import org.syncope.console.pages.Connectors;
import org.syncope.console.pages.Login;
import org.syncope.console.pages.Report;
import org.syncope.console.pages.Resources;
import org.syncope.console.pages.Roles;
import org.syncope.console.pages.Schema;
import org.syncope.console.pages.Tasks;
import org.syncope.console.pages.Users;
import org.syncope.console.pages.WelcomePage;

public class SyncopeApplication
extends AuthenticatedWebApplication
implements ApplicationContextAware {
    SyncopeUser user = null;
    String file;
    private ApplicationContext applicationContext;

    protected void init() {
        this.file = this.getServletContext().getInitParameter("authenticationFile");
        this.addComponentInstantiationListener((IComponentInstantiationListener)new SpringComponentInjector((WebApplication)this));
        this.getResourceSettings().setThrowExceptionOnMissingResource(true);
        this.getSecuritySettings().setAuthorizationStrategy((IAuthorizationStrategy)new RoleAuthorizationStrategy((IRoleCheckingStrategy)new SyncopeRolesAuthorizer()));
        this.setupAuthorizations();
    }

    public void setupAuthorizations() {
        MetaDataRoleAuthorizationStrategy.authorize(Schema.class, (String)"SCHEMA_LIST");
        MetaDataRoleAuthorizationStrategy.authorize(Roles.class, (String)"ROLES_LIST");
        MetaDataRoleAuthorizationStrategy.authorize(Connectors.class, (String)"CONNECTORS_LIST");
        MetaDataRoleAuthorizationStrategy.authorize(Resources.class, (String)"RESOURCES_LIST");
        MetaDataRoleAuthorizationStrategy.authorize(Users.class, (String)"USER_LIST");
        MetaDataRoleAuthorizationStrategy.authorize(Report.class, (String)"REPORT_LIST");
        MetaDataRoleAuthorizationStrategy.authorize(Tasks.class, (String)"TASKS_LIST");
        MetaDataRoleAuthorizationStrategy.authorize(Configuration.class, (String)"CONFIGURATION_LIST");
    }

    public Session newSession(Request request, Response response) {
        SyncopeSession session = new SyncopeSession(request);
        if (this.user != null) {
            session.setUser(this.user);
        }
        return session;
    }

    public Class getHomePage() {
        return ((SyncopeSession)Session.get()).getUser() == null ? Login.class : WelcomePage.class;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public final RequestCycle newRequestCycle(Request request, Response response) {
        return new SyncopeRequestCycle((WebApplication)this, (WebRequest)request, (Response)((WebResponse)response));
    }

    protected Class<? extends AuthenticatedWebSession> getWebSessionClass() {
        return SyncopeSession.class;
    }

    protected Class<? extends WebPage> getSignInPageClass() {
        return Login.class;
    }
}

