/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBoxMultipleChoice;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.ConnectorBundleTO;
import org.syncope.client.to.ConnectorInstanceTO;
import org.syncope.client.to.PropertyTO;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.Connectors;
import org.syncope.console.pages.SyncopeModalPage;
import org.syncope.console.rest.ConnectorsRestClient;
import org.syncope.types.ConnectorCapability;

public class ConnectorsModalPage
extends SyncopeModalPage {
    public TextField connectorName;
    public DropDownChoice bundle;
    public TextField version;
    public CheckBoxMultipleChoice capabilitiesPalette;
    List<ConnectorBundleTO> bundlesTOs;
    ConnectorBundleTO selectedBundleTO = new ConnectorBundleTO();
    List<PropertyTO> connectorProperties = new ArrayList<PropertyTO>();
    public AjaxButton submit;
    @SpringBean(name="connectorsRestClient")
    ConnectorsRestClient restClient;
    WebMarkupContainer propertiesContainer;
    List<ConnectorCapability> selections;

    public ConnectorsModalPage(final BasePage basePage, final ModalWindow window, final ConnectorInstanceTO connectorTO, final boolean createFlag) {
        Form connectorForm = new Form("ConnectorForm");
        connectorForm.setModel((IModel)new CompoundPropertyModel((Object)connectorTO));
        if (!createFlag) {
            this.setupSelections(connectorTO);
        }
        LoadableDetachableModel bundles = new LoadableDetachableModel(){

            protected Object load() {
                return ConnectorsModalPage.this.restClient.getAllBundles();
            }
        };
        LoadableDetachableModel selectedBundleProperties = new LoadableDetachableModel(){

            protected Object load() {
                List<PropertyTO> list;
                if (createFlag) {
                    connectorTO.setConnectorName(ConnectorsModalPage.this.selectedBundleTO.getConnectorName());
                    connectorTO.setVersion(ConnectorsModalPage.this.selectedBundleTO.getVersion());
                    list = new ArrayList<PropertyTO>();
                    for (String key : ConnectorsModalPage.this.selectedBundleTO.getProperties()) {
                        PropertyTO propertyTO = new PropertyTO();
                        propertyTO.setKey(key);
                        list.add(propertyTO);
                    }
                } else {
                    ConnectorsModalPage.this.selectedBundleTO.setBundleName(connectorTO.getBundleName());
                    list = ConnectorsModalPage.this.hashSetToList(connectorTO.getConfiguration());
                }
                return list;
            }
        };
        this.connectorName = new TextField("connectorName");
        this.connectorName.setEnabled(false);
        this.connectorName.setOutputMarkupId(true);
        this.version = new TextField("version");
        this.version.setEnabled(false);
        this.version.setOutputMarkupId(true);
        ChoiceRenderer renderer = new ChoiceRenderer("displayName", "bundleName");
        this.bundle = new DropDownChoice("bundle", (IModel)bundles, (IChoiceRenderer)renderer);
        this.bundle.setModel(new IModel(){

            public Object getObject() {
                return ConnectorsModalPage.this.selectedBundleTO;
            }

            public void setObject(Object object) {
                ConnectorsModalPage.this.selectedBundleTO = (ConnectorBundleTO)object;
            }

            public void detach() {
            }
        });
        this.bundle.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                connectorTO.setConfiguration(new HashSet());
                target.addComponent((Component)ConnectorsModalPage.this.propertiesContainer);
                target.addComponent((Component)ConnectorsModalPage.this.connectorName);
                target.addComponent((Component)ConnectorsModalPage.this.version);
            }
        }});
        this.bundle.setRequired(true);
        this.bundle.setEnabled(createFlag);
        ListView propertiesView = new ListView("connectorProperties", (IModel)selectedBundleProperties){
            PropertyTO propertyTO;

            protected void populateItem(ListItem item) {
                this.propertyTO = (PropertyTO)item.getDefaultModelObject();
                item.add(new Component[]{new Label("key", this.propertyTO.getKey())});
                item.add(new Component[]{new TextField("value", (IModel)new PropertyModel((Object)this.propertyTO, "value"))});
                connectorTO.getConfiguration().add(this.propertyTO);
            }
        };
        this.propertiesContainer = new WebMarkupContainer("propertiesContainer");
        this.propertiesContainer.setOutputMarkupId(true);
        this.propertiesContainer.add(new Component[]{propertiesView});
        connectorForm.add(new Component[]{this.propertiesContainer});
        this.submit = new IndicatingAjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                ConnectorInstanceTO connector = (ConnectorInstanceTO)form.getDefaultModelObject();
                connector.setBundleName(ConnectorsModalPage.this.bundle.getModelValue());
                connector.setCapabilities(ConnectorsModalPage.this.getResourcesSet(ConnectorsModalPage.this.selections));
                try {
                    if (createFlag) {
                        ConnectorsModalPage.this.restClient.createConnector(connector);
                    } else {
                        ConnectorsModalPage.this.restClient.updateConnector(connector);
                    }
                    Connectors callerPage = (Connectors)basePage;
                    callerPage.setOperationResult(true);
                    window.close(target);
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)(this.getString("error") + ":" + e.getMessage())));
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent(form.get("feedback"));
            }
        };
        String allowedRoles = createFlag ? this.xmlRolesReader.getAllAllowedRoles("Connectors", "create") : this.xmlRolesReader.getAllAllowedRoles("Connectors", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.submit, (Action)ENABLE, (String)allowedRoles);
        connectorForm.add(new Component[]{new FeedbackPanel("feedback").setOutputMarkupId(true)});
        connectorForm.add(new Component[]{this.connectorName});
        connectorForm.add(new Component[]{this.bundle});
        connectorForm.add(new Component[]{this.version});
        LoadableDetachableModel capabilities = new LoadableDetachableModel(){

            protected Object load() {
                return Arrays.asList(ConnectorCapability.values());
            }
        };
        this.capabilitiesPalette = new CheckBoxMultipleChoice("capabilitiesPalette", (IModel)new PropertyModel((Object)this, "selections"), (IModel)capabilities);
        connectorForm.add(new Component[]{this.capabilitiesPalette});
        connectorForm.add(new Component[]{this.submit});
        this.add(new Component[]{connectorForm});
    }

    public void setupSelections(ConnectorInstanceTO connectorTO) {
        this.selections = new ArrayList<ConnectorCapability>();
        for (ConnectorCapability capability : connectorTO.getCapabilities()) {
            this.selections.add(capability);
        }
    }

    public Set<ConnectorCapability> getResourcesSet(Collection<ConnectorCapability> capabilitiesList) {
        HashSet<ConnectorCapability> capabilitiesSet = new HashSet<ConnectorCapability>();
        for (ConnectorCapability capability : capabilitiesList) {
            capabilitiesSet.add(capability);
        }
        return capabilitiesSet;
    }

    public List<ConnectorCapability> getSelectedCapabilities(ConnectorInstanceTO connectorTO) {
        ArrayList<ConnectorCapability> capabilities = new ArrayList<ConnectorCapability>();
        for (ConnectorCapability capability : connectorTO.getCapabilities()) {
            capabilities.add(capability);
        }
        return capabilities;
    }

    public List<ConnectorCapability> getAvailableCapabilities() {
        ArrayList<ConnectorCapability> capabilities = new ArrayList();
        capabilities = Arrays.asList(ConnectorCapability.values());
        return capabilities;
    }

    public List<PropertyTO> hashSetToList(Set<PropertyTO> set) {
        ArrayList<PropertyTO> list = new ArrayList<PropertyTO>();
        for (PropertyTO propertyTO : set) {
            list.add(propertyTO);
        }
        return list;
    }
}

