/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.Session;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.syncope.console.SyncopeSession;
import org.syncope.console.SyncopeUser;
import org.syncope.console.pages.WelcomePage;

public class Login
extends WebPage {
    public Form form = new Form("login");
    public TextField usernameField = new TextField("username", (IModel)new Model());
    public TextField passwordField;
    public DropDownChoice<String> languageSelect;
    public InputStream inputStream;

    public Login(PageParameters parameters) {
        super(parameters);
        this.usernameField.setMarkupId("username");
        this.form.add(new Component[]{this.usernameField});
        this.passwordField = new PasswordTextField("password", (IModel)new Model());
        this.passwordField.setMarkupId("password");
        this.form.add(new Component[]{this.passwordField});
        this.languageSelect = new LocaleDropDown("language", Arrays.asList(Locale.ENGLISH, Locale.ITALIAN));
        this.form.add(new Component[]{this.languageSelect});
        Button submitButton = new Button("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){

            public void onSubmit() {
                SyncopeUser user = Login.this.authenticate(Login.this.usernameField.getRawInput(), Login.this.passwordField.getRawInput());
                if (user != null) {
                    ((SyncopeSession)Session.get()).setUser(user);
                    this.setResponsePage((Page)new WelcomePage(null));
                } else {
                    this.error((Serializable)((Object)this.getString("login-error")));
                }
            }
        };
        submitButton.setDefaultFormProcessing(false);
        this.form.add(new Component[]{submitButton});
        this.add(new Component[]{this.form});
        this.add(new Component[]{new FeedbackPanel("feedback")});
    }

    public SyncopeUser authenticate(String username, String password) {
        SyncopeUser user = null;
        String roles = "";
        if ("admin".equals(username) && "password".equals(password)) {
            List<String> rolesList = this.getAdminRoles();
            for (int i = 0; i < rolesList.size(); ++i) {
                String role = rolesList.get(i);
                roles = roles + role;
                if (i == rolesList.size()) continue;
                roles = roles + ",";
            }
            user = new SyncopeUser(username, roles);
            return user;
        }
        if ("manager".equals(username) && "password".equals(password)) {
            List<String> rolesList = this.getManagerRoles();
            for (int i = 0; i < rolesList.size(); ++i) {
                String role = rolesList.get(i);
                roles = roles + role;
                if (i == rolesList.size()) continue;
                roles = roles + ",";
            }
            user = new SyncopeUser(username, roles);
            return user;
        }
        return null;
    }

    public List<String> getAdminRoles() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("USER_CREATE");
        roles.add("USER_LIST");
        roles.add("USER_READ");
        roles.add("USER_DELETE");
        roles.add("USER_UPDATE");
        roles.add("USER_VIEW");
        roles.add("SCHEMA_CREATE");
        roles.add("SCHEMA_LIST");
        roles.add("SCHEMA_READ");
        roles.add("SCHEMA_DELETE");
        roles.add("SCHEMA_UPDATE");
        roles.add("ROLES_CREATE");
        roles.add("ROLES_LIST");
        roles.add("ROLES_READ");
        roles.add("ROLES_DELETE");
        roles.add("ROLES_UPDATE");
        roles.add("RESOURCES_CREATE");
        roles.add("RESOURCES_LIST");
        roles.add("RESOURCES_READ");
        roles.add("RESOURCES_DELETE");
        roles.add("RESOURCES_UPDATE");
        roles.add("CONNECTORS_CREATE");
        roles.add("CONNECTORS_LIST");
        roles.add("CONNECTORS_READ");
        roles.add("CONNECTORS_DELETE");
        roles.add("CONNECTORS_UPDATE");
        roles.add("REPORT_LIST");
        roles.add("CONFIGURATION_CREATE");
        roles.add("CONFIGURATION_LIST");
        roles.add("CONFIGURATION_READ");
        roles.add("CONFIGURATION_DELETE");
        roles.add("CONFIGURATION_UPDATE");
        roles.add("TASKS_CREATE");
        roles.add("TASKS_LIST");
        roles.add("TASKS_READ");
        roles.add("TASKS_DELETE");
        roles.add("TASKS_UPDATE");
        roles.add("TASKS_EXECUTE");
        return roles;
    }

    public List<String> getManagerRoles() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("USER_LIST");
        roles.add("USER_READ");
        roles.add("USER_DELETE");
        roles.add("SCHEMA_LIST");
        roles.add("CONNECTORS_LIST");
        roles.add("REPORT_LIST");
        roles.add("ROLES_LIST");
        roles.add("ROLES_READ");
        roles.add("TASKS_LIST");
        return roles;
    }

    public class LocaleDropDown
    extends DropDownChoice {
        public LocaleDropDown(String id, List<Locale> supportedLocales) {
            super(id, supportedLocales);
            this.setChoiceRenderer((IChoiceRenderer)new LocaleRenderer());
            this.setModel(new IModel(){

                public Object getObject() {
                    return LocaleDropDown.this.getSession().getLocale();
                }

                public void setObject(Object object) {
                    LocaleDropDown.this.getSession().setLocale((Locale)object);
                }

                public void detach() {
                }
            });
            this.getModel().setObject((Object)Locale.ENGLISH);
        }

        protected boolean wantOnSelectionChangedNotifications() {
            return true;
        }

        private class LocaleRenderer
        extends ChoiceRenderer {
            private LocaleRenderer() {
            }

            public String getDisplayValue(Object locale) {
                return ((Locale)locale).getDisplayName(LocaleDropDown.this.getLocale());
            }
        }
    }
}

