/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.tree.BaseTree;
import org.apache.wicket.markup.html.tree.LinkTree;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.mod.AttributeMod;
import org.syncope.client.mod.MembershipMod;
import org.syncope.client.mod.UserMod;
import org.syncope.client.to.AttributeTO;
import org.syncope.client.to.MembershipTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.client.to.RoleTO;
import org.syncope.client.to.SchemaTO;
import org.syncope.client.to.UserTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.SyncopeApplication;
import org.syncope.console.commons.SchemaWrapper;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.MembershipModalPage;
import org.syncope.console.pages.RoleModalPage;
import org.syncope.console.pages.SyncopeModalPage;
import org.syncope.console.pages.Users;
import org.syncope.console.rest.ResourcesRestClient;
import org.syncope.console.rest.RolesRestClient;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.rest.UsersRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.syncope.console.wicket.markup.html.form.DateFieldPanel;
import org.syncope.console.wicket.markup.html.tree.SyncopeRoleTree;
import org.syncope.console.wicket.markup.html.tree.TreeModelBean;

public class UserModalPage
extends SyncopeModalPage {
    @SpringBean(name="usersRestClient")
    UsersRestClient usersRestClient;
    @SpringBean(name="rolesRestClient")
    RolesRestClient rolesRestClient;
    WebMarkupContainer container;
    WebMarkupContainer membershipsContainer;
    AjaxButton submit;
    List<SchemaWrapper> schemaWrappers;
    List<MembershipTO> membershipTOs;
    final ModalWindow createUserWin;
    UserTO oldUser;
    UserMod userMod;
    Map rolesMap;

    public UserModalPage(final BasePage basePage, final ModalWindow window, UserTO userTO, final boolean createFlag) {
        if (!createFlag) {
            this.cloneOldUserTO(userTO);
        }
        this.setupRolesMap();
        Component[] componentArray = new Component[1];
        this.createUserWin = new ModalWindow("membershipWin");
        componentArray[0] = this.createUserWin;
        this.add(componentArray);
        this.createUserWin.setCssClassName("w_silver");
        this.createUserWin.setPageMapName("create-membership-modal");
        this.createUserWin.setCookieName("create-membership-modal");
        final Form userForm = new Form("UserForm");
        userForm.setModel((IModel)new CompoundPropertyModel((Object)userTO));
        this.setupSchemaWrappers(createFlag, userTO);
        this.setupMemberships(createFlag, userTO);
        ListView userAttributesView = new ListView("userSchemas", this.schemaWrappers){

            protected void populateItem(ListItem item) {
                final SchemaWrapper schemaWrapper = (SchemaWrapper)item.getDefaultModelObject();
                final SchemaTO schemaTO = schemaWrapper.getSchemaTO();
                item.add(new Component[]{new Label("name", schemaWrapper.getSchemaTO().getName())});
                item.add(new Component[]{new ListView("fields", schemaWrapper.getValues()){
                    Panel panel;

                    protected void populateItem(final ListItem item) {
                        String mandatoryCondition = schemaTO.getMandatoryCondition();
                        boolean required = false;
                        if (mandatoryCondition.equalsIgnoreCase("true")) {
                            required = true;
                        }
                        this.panel = schemaTO.getType().getClassName().equals("java.lang.String") ? new AjaxTextFieldPanel("panel", schemaTO.getName(), (IModel)new Model(){

                            public Serializable getObject() {
                                return (String)item.getModelObject();
                            }

                            public void setObject(Serializable object) {
                                item.setModelObject((Object)((String)((Object)object)));
                            }
                        }, required, schemaTO.isReadonly()) : (schemaTO.getType().getClassName().equals("java.lang.Boolean") ? new AjaxCheckBoxPanel("panel", schemaTO.getName(), (IModel<Boolean>)new Model(){

                            public Serializable getObject() {
                                return (String)item.getModelObject();
                            }

                            public void setObject(Serializable object) {
                                Boolean val = (Boolean)object;
                                item.setModelObject((Object)val.toString());
                            }
                        }, required, schemaTO.isReadonly()) : (schemaTO.getType().getClassName().equals("java.util.Date") ? new DateFieldPanel("panel", schemaTO.getName(), (IModel<Date>)new Model(){

                            public Serializable getObject() {
                                SimpleDateFormat formatter = new SimpleDateFormat(schemaTO.getConversionPattern());
                                Date date = new Date();
                                try {
                                    String dateValue = (String)item.getModelObject();
                                    date = !dateValue.equals("") ? formatter.parse(dateValue) : null;
                                }
                                catch (ParseException ex) {
                                    Logger.getLogger(RoleModalPage.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                return date;
                            }

                            public void setObject(Serializable object) {
                                Date date = (Date)object;
                                SimpleDateFormat formatter = new SimpleDateFormat(schemaTO.getConversionPattern());
                                String val = formatter.format((Object)date);
                                item.setModelObject((Object)val);
                            }
                        }, schemaTO.getConversionPattern(), required, schemaTO.isReadonly(), userForm) : new AjaxTextFieldPanel("panel", schemaTO.getName(), (IModel)new Model(){

                            public Serializable getObject() {
                                return (String)item.getModelObject();
                            }

                            public void setObject(Serializable object) {
                                item.setModelObject((Object)((String)((Object)object)));
                            }
                        }, required, schemaTO.isReadonly())));
                        item.add(new Component[]{this.panel});
                    }
                }});
                AjaxButton addButton = new AjaxButton("add", (IModel)new Model((Serializable)((Object)this.getString("add")))){

                    protected void onSubmit(AjaxRequestTarget target, Form form) {
                        schemaWrapper.getValues().add("");
                        target.addComponent((Component)UserModalPage.this.container);
                    }
                };
                AjaxButton dropButton = new AjaxButton("drop", (IModel)new Model((Serializable)((Object)this.getString("drop")))){

                    protected void onSubmit(AjaxRequestTarget target, Form form) {
                        schemaWrapper.getValues().remove(schemaWrapper.getValues().size() - 1);
                        target.addComponent((Component)UserModalPage.this.container);
                    }
                };
                if (schemaTO.getType().getClassName().equals("java.lang.Boolean")) {
                    addButton.setVisible(false);
                    dropButton.setVisible(false);
                }
                addButton.setDefaultFormProcessing(false);
                addButton.setVisible(schemaTO.isMultivalue());
                dropButton.setDefaultFormProcessing(false);
                dropButton.setVisible(schemaTO.isMultivalue());
                if (schemaWrapper.getValues().size() == 1) {
                    dropButton.setVisible(false);
                }
                if (schemaTO.isReadonly()) {
                    addButton.setEnabled(false);
                    dropButton.setEnabled(false);
                }
                item.add(new Component[]{addButton});
                item.add(new Component[]{dropButton});
            }
        };
        userForm.add(new Component[]{userAttributesView});
        ListModel selectedResources = new ListModel();
        selectedResources.setObject(this.getSelectedResources(userTO));
        ListModel availableResources = new ListModel();
        availableResources.setObject(this.getAvailableResources(userTO));
        ChoiceRenderer paletteRenderer = new ChoiceRenderer("name", "name");
        final Palette resourcesPalette = new Palette("resourcesPalette", (IModel)selectedResources, (IModel)availableResources, (IChoiceRenderer)paletteRenderer, 8, false);
        userForm.add(new Component[]{resourcesPalette});
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{userAttributesView});
        PasswordTextField password = new PasswordTextField("password");
        password.setRequired(createFlag);
        password.setResetPassword(false);
        this.container.add(new Component[]{password});
        this.container.setOutputMarkupId(true);
        userForm.add(new Component[]{this.container});
        this.submit = new IndicatingAjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                UserTO userTO = (UserTO)form.getDefaultModelObject();
                boolean res = false;
                try {
                    userTO.setResources(UserModalPage.this.getResourcesSet(resourcesPalette.getModelCollection()));
                    userTO.setAttributes(UserModalPage.this.getUserAttributesList());
                    userTO.setMemberships(UserModalPage.this.getMembershipsSet());
                    if (createFlag) {
                        UserModalPage.this.usersRestClient.createUser(userTO);
                    } else {
                        UserModalPage.this.setupUserMod(userTO);
                        if (UserModalPage.this.userMod != null) {
                            res = UserModalPage.this.usersRestClient.updateUser(UserModalPage.this.userMod);
                            if (!res) {
                                this.error((Serializable)((Object)this.getString("error_updating")));
                            }
                            Users callerPage = (Users)basePage;
                            callerPage.setOperationResult(true);
                        }
                    }
                    window.close(target);
                }
                catch (SyncopeClientCompositeErrorException e) {
                    e.printStackTrace();
                    this.error((Serializable)((Object)(this.getString("error") + ":" + e.getMessage())));
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent(form.get("feedback"));
            }
        };
        String allowedRoles = null;
        allowedRoles = createFlag ? this.xmlRolesReader.getAllAllowedRoles("Users", "create") : this.xmlRolesReader.getAllAllowedRoles("Users", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.submit, (Action)RENDER, (String)allowedRoles);
        userForm.add(new Component[]{this.submit});
        userForm.add(new Component[]{new FeedbackPanel("feedback").setOutputMarkupId(true)});
        SyncopeRoleTree roleTree = new SyncopeRoleTree(this.rolesRestClient);
        LinkTree tree = new LinkTree("treeTable", roleTree.createTreeModel()){

            protected IModel<Object> getNodeTextModel(IModel<Object> model) {
                return new PropertyModel(model, "userObject.treeNode.displayName");
            }

            protected void onNodeLinkClicked(Object node, BaseTree tree, AjaxRequestTarget target) {
                DefaultMutableTreeNode syncopeTreeNode = (DefaultMutableTreeNode)node;
                final TreeModelBean treeModel = (TreeModelBean)syncopeTreeNode.getUserObject();
                if (treeModel.getTreeNode() != null) {
                    UserModalPage.this.createUserWin.setPageCreator(new ModalWindow.PageCreator(){
                        MembershipTO membershipTO;

                        public Page createPage() {
                            this.membershipTO = new MembershipTO();
                            this.membershipTO.setRoleId(treeModel.getTreeNode().getId().longValue());
                            String title = treeModel.getTreeNode().getName();
                            MembershipModalPage form = new MembershipModalPage(this.getPage(), UserModalPage.this.createUserWin, this.membershipTO, true);
                            return form;
                        }
                    });
                    UserModalPage.this.createUserWin.show(target);
                }
            }
        };
        tree.getTreeState().expandAll();
        tree.updateTree();
        userForm.add(new Component[]{tree});
        ListView membershipsView = new ListView("memberships", this.membershipTOs){

            protected void populateItem(ListItem item) {
                final MembershipTO membershipTO = (MembershipTO)item.getDefaultModelObject();
                item.add(new Component[]{new Label("roleId", (IModel)new Model((Serializable)Long.valueOf(membershipTO.getRoleId())))});
                item.add(new Component[]{new Label("roleName", (IModel)new Model((Serializable)((Object)((String)UserModalPage.this.rolesMap.get(membershipTO.getRoleId())))))});
                AjaxLink editLink = new AjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        UserModalPage.this.createUserWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                MembershipModalPage window = new MembershipModalPage(this.getPage(), UserModalPage.this.createUserWin, membershipTO, false);
                                return window;
                            }
                        });
                        UserModalPage.this.createUserWin.show(target);
                    }
                };
                item.add(new Component[]{editLink});
                AjaxLink deleteLink = new AjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        int componentId = new Integer(this.getParent().getId());
                        UserModalPage.this.membershipTOs.remove(componentId);
                        target.addComponent((Component)UserModalPage.this.membershipsContainer);
                    }
                };
                item.add(new Component[]{deleteLink});
            }
        };
        this.membershipsContainer = new WebMarkupContainer("membershipsContainer");
        this.membershipsContainer.add(new Component[]{membershipsView});
        this.membershipsContainer.setOutputMarkupId(true);
        this.setWindowClosedCallback(this.createUserWin, this.membershipsContainer);
        userForm.add(new Component[]{this.membershipsContainer});
        this.add(new Component[]{userForm});
    }

    public List<ResourceTO> getSelectedResources(UserTO userTO) {
        ArrayList<ResourceTO> resources = new ArrayList<ResourceTO>();
        for (String resourceName : userTO.getResources()) {
            ResourceTO clusterableResourceTO = new ResourceTO();
            clusterableResourceTO.setName(resourceName);
            resources.add(clusterableResourceTO);
        }
        return resources;
    }

    public List<ResourceTO> getAvailableResources(UserTO userTO) {
        ArrayList<ResourceTO> resources = new ArrayList<ResourceTO>();
        ResourcesRestClient resourcesRestClient = (ResourcesRestClient)((SyncopeApplication)Application.get()).getApplicationContext().getBean("resourcesRestClient");
        List<ResourceTO> resourcesTos = resourcesRestClient.getAllResources();
        for (ResourceTO resourceTO : resourcesTos) {
            resources.add(resourceTO);
        }
        return resources;
    }

    public void cloneOldUserTO(UserTO userTO) {
        this.oldUser = new UserTO();
        this.oldUser.setId(userTO.getId());
        this.oldUser.setPassword(userTO.getPassword());
        for (AttributeTO attribute : userTO.getAttributes()) {
            AttributeTO tempAttr = new AttributeTO();
            tempAttr.setReadonly(attribute.isReadonly());
            tempAttr.setSchema(attribute.getSchema());
            for (String tempVal : attribute.getValues()) {
                tempAttr.getValues().add(tempVal);
            }
            this.oldUser.getAttributes().add(tempAttr);
        }
        this.oldUser.setResources(userTO.getResources());
        this.oldUser.setMemberships(new ArrayList());
        for (MembershipTO membershipTO : userTO.getMemberships()) {
            MembershipTO membership = new MembershipTO();
            membership.setId(membershipTO.getId());
            membership.setRoleId(membershipTO.getRoleId());
            membership.setAttributes(membershipTO.getAttributes());
            this.oldUser.getMemberships().add(membership);
        }
    }

    public void setupRolesMap() {
        this.rolesMap = new HashMap();
        List<RoleTO> roleTOs = this.rolesRestClient.getAllRoles();
        for (RoleTO roleTO : roleTOs) {
            this.rolesMap.put(roleTO.getId(), roleTO.getName());
        }
    }

    public void setWindowClosedCallback(ModalWindow window, final WebMarkupContainer container) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                target.addComponent((Component)container);
            }
        });
    }

    public void setupSchemaWrappers(boolean create, UserTO userTO) {
        this.schemaWrappers = new ArrayList<SchemaWrapper>();
        SchemaRestClient schemaRestClient = (SchemaRestClient)((SyncopeApplication)Application.get()).getApplicationContext().getBean("schemaRestClient");
        List<SchemaTO> schemas = schemaRestClient.getAllUserSchemas();
        boolean found = false;
        if (create) {
            for (SchemaTO schema : schemas) {
                SchemaWrapper schemaWrapper = new SchemaWrapper(schema);
                this.schemaWrappers.add(schemaWrapper);
            }
        } else {
            for (SchemaTO schema : schemas) {
                SchemaWrapper schemaWrapper;
                for (AttributeTO attribute : userTO.getAttributes()) {
                    if (!schema.getName().equals(attribute.getSchema())) continue;
                    schemaWrapper = new SchemaWrapper(schema);
                    schemaWrapper.setValues(attribute.getValues());
                    this.schemaWrappers.add(schemaWrapper);
                    found = true;
                }
                if (!found) {
                    schemaWrapper = new SchemaWrapper(schema);
                    this.schemaWrappers.add(schemaWrapper);
                    continue;
                }
                found = false;
            }
        }
    }

    public void setupMemberships(boolean create, UserTO userTO) {
        this.membershipTOs = new ArrayList<MembershipTO>();
        if (!create) {
            List memberships = userTO.getMemberships();
            for (MembershipTO membership : memberships) {
                this.membershipTOs.add(membership);
            }
        }
    }

    public List<AttributeTO> getUserAttributesList() {
        ArrayList<AttributeTO> attributes = new ArrayList<AttributeTO>();
        for (SchemaWrapper schemaWrapper : this.schemaWrappers) {
            AttributeTO attribute = new AttributeTO();
            attribute.setSchema(schemaWrapper.getSchemaTO().getName());
            attribute.setValues(new ArrayList());
            attribute.setReadonly(schemaWrapper.getSchemaTO().isReadonly());
            for (String value : schemaWrapper.getValues()) {
                attribute.getValues().add(value);
            }
            attributes.add(attribute);
        }
        return attributes;
    }

    public List<MembershipTO> getMembershipsSet() {
        ArrayList<MembershipTO> memberships = new ArrayList<MembershipTO>();
        for (MembershipTO membership : this.membershipTOs) {
            memberships.add(membership);
        }
        return memberships;
    }

    public Set<String> getResourcesSet(Collection<ResourceTO> resourcesList) {
        HashSet<String> resourcesSet = new HashSet<String>();
        for (ResourceTO resourceTO : resourcesList) {
            resourcesSet.add(resourceTO.getName());
        }
        return resourcesSet;
    }

    public List<MembershipTO> getMembershipTOs() {
        return this.membershipTOs;
    }

    public void setMembershipTOs(List<MembershipTO> membershipTOs) {
        this.membershipTOs = membershipTOs;
    }

    public void setupUserMod(UserTO userTO) {
        if (!this.oldUser.getPassword().equals(userTO.getPassword())) {
            this.userMod = new UserMod();
            this.userMod.setPassword(userTO.getPassword());
        }
        for (AttributeTO attributeTO : userTO.getAttributes()) {
            this.searchAndUpdateAttribute(attributeTO);
        }
        for (String resource : userTO.getResources()) {
            this.searchAndAddResource(resource);
        }
        for (String resource : this.oldUser.getResources()) {
            this.searchAndDropResource(resource, userTO);
        }
        for (MembershipTO membership : userTO.getMemberships()) {
            this.searchAndUpdateMembership(membership);
        }
        for (MembershipTO membership : this.oldUser.getMemberships()) {
            this.searchAndDropMembership(membership, userTO);
        }
        if (this.userMod != null) {
            this.userMod.setId(this.oldUser.getId());
        }
    }

    public void searchAndUpdateAttribute(AttributeTO attributeTO) {
        boolean found = false;
        boolean changed = false;
        AttributeMod attributeMod = new AttributeMod();
        attributeMod.setSchema(attributeTO.getSchema());
        for (AttributeTO oldAttribute : this.oldUser.getAttributes()) {
            if (!attributeTO.getSchema().equals(oldAttribute.getSchema())) continue;
            if (!attributeTO.equals((Object)oldAttribute) && !oldAttribute.isReadonly()) {
                if (attributeTO.getValues().size() > 1) {
                    attributeMod.setValuesToBeAdded(attributeTO.getValues());
                } else {
                    attributeMod.addValueToBeAdded((String)attributeTO.getValues().iterator().next());
                }
                if (this.userMod == null) {
                    this.userMod = new UserMod();
                }
                this.userMod.addAttributeToBeRemoved(oldAttribute.getSchema());
                this.userMod.addAttributeToBeUpdated(attributeMod);
                changed = true;
                break;
            }
            found = true;
        }
        if (!found & !changed && !attributeTO.isReadonly() && attributeTO.getValues() != null) {
            if (attributeTO.getValues().iterator().next() != null) {
                attributeMod.setValuesToBeAdded(attributeTO.getValues());
                if (this.userMod == null) {
                    this.userMod = new UserMod();
                }
                this.userMod.addAttributeToBeUpdated(attributeMod);
            } else {
                attributeMod = null;
            }
        }
    }

    public void searchAndAddResource(String resource) {
        boolean found = false;
        for (String oldResource : this.oldUser.getResources()) {
            if (!resource.equals(oldResource)) continue;
            found = true;
        }
        if (!found) {
            if (this.userMod == null) {
                this.userMod = new UserMod();
            }
            this.userMod.addResourceToBeAdded(resource);
        }
    }

    public void searchAndDropResource(String resource, UserTO userTO) {
        boolean found = false;
        for (String newResource : userTO.getResources()) {
            if (!resource.equals(newResource)) continue;
            found = true;
        }
        if (!found) {
            if (this.userMod == null) {
                this.userMod = new UserMod();
            }
            this.userMod.addResourceToBeRemoved(resource);
        }
    }

    public void searchAndUpdateMembership(MembershipTO newMembership) {
        AttributeMod attributeMod;
        boolean found = false;
        boolean attrFound = false;
        MembershipMod membershipMod = new MembershipMod();
        membershipMod.setRole(newMembership.getRoleId());
        for (MembershipTO oldMembership : this.oldUser.getMemberships()) {
            if (newMembership.getRoleId() != oldMembership.getRoleId()) continue;
            for (AttributeTO newAttribute : newMembership.getAttributes()) {
                for (AttributeTO oldAttribute : oldMembership.getAttributes()) {
                    if (!oldAttribute.getSchema().equals(newAttribute.getSchema())) continue;
                    attributeMod = new AttributeMod();
                    attributeMod.setSchema(newAttribute.getSchema());
                    attributeMod.setValuesToBeAdded(newAttribute.getValues());
                    membershipMod.addAttributeToBeUpdated(attributeMod);
                    attrFound = true;
                    break;
                }
                if (!attrFound) {
                    attributeMod = new AttributeMod();
                    attributeMod.setSchema(newAttribute.getSchema());
                    attributeMod.setValuesToBeAdded(newAttribute.getValues());
                    membershipMod.addAttributeToBeUpdated(attributeMod);
                }
                attrFound = false;
            }
            if (this.userMod == null) {
                this.userMod = new UserMod();
            }
            this.userMod.addMembershipToBeRemoved(Long.valueOf(oldMembership.getId()));
            this.userMod.addMembershipToBeAdded(membershipMod);
            found = true;
            break;
        }
        if (!found) {
            HashSet<AttributeMod> attributes = new HashSet<AttributeMod>();
            for (AttributeTO newAttribute : newMembership.getAttributes()) {
                attributeMod = new AttributeMod();
                attributeMod.setSchema(newAttribute.getSchema());
                attributeMod.setValuesToBeAdded(newAttribute.getValues());
                attributes.add(attributeMod);
            }
            membershipMod.setAttributesToBeUpdated(attributes);
            if (this.userMod == null) {
                this.userMod = new UserMod();
            }
            this.userMod.addMembershipToBeAdded(membershipMod);
        }
    }

    public void searchAndDropMembership(MembershipTO oldMembership, UserTO userTO) {
        boolean found = false;
        for (MembershipTO newMembership : userTO.getMemberships()) {
            if (newMembership.getId() != oldMembership.getId()) continue;
            found = true;
        }
        if (!found) {
            if (this.userMod == null) {
                this.userMod = new UserMod();
            }
            this.userMod.addMembershipToBeRemoved(Long.valueOf(oldMembership.getId()));
        }
    }
}

