/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.rest;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestClientException;
import org.syncope.client.to.ConfigurationTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.rest.RestClient;

public class ConfigurationsRestClient {
    RestClient restClient;

    public List<ConfigurationTO> getAllConfigurations() throws RestClientException {
        List<Object> configurations = null;
        configurations = Arrays.asList((Object[])this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "configuration/list.json", ConfigurationTO[].class, new Object[0]));
        return configurations;
    }

    public ConfigurationTO readConfiguration(String confKey) throws SyncopeClientCompositeErrorException, RestClientException {
        ConfigurationTO configurationTO = (ConfigurationTO)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "configuration/read/{confKey}.json", ConfigurationTO.class, new Object[]{confKey});
        return configurationTO;
    }

    public boolean createConfiguration(ConfigurationTO configurationTO) {
        ConfigurationTO newConfigurationTO = (ConfigurationTO)this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "configuration/create", (Object)configurationTO, ConfigurationTO.class, new Object[0]);
        return configurationTO.equals((Object)newConfigurationTO);
    }

    public boolean updateConfiguration(ConfigurationTO configurationTO) {
        ConfigurationTO newConfigurationTO = (ConfigurationTO)this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "configuration/update", (Object)configurationTO, ConfigurationTO.class, new Object[0]);
        return configurationTO.equals((Object)newConfigurationTO);
    }

    public void deleteConfiguration(String confKey) throws UnsupportedEncodingException, HttpStatusCodeException {
        this.restClient.getRestTemplate().delete(this.restClient.getBaseURL() + "configuration/delete/{confKey}.json", new Object[]{confKey});
    }

    public RestClient getRestClient() {
        return this.restClient;
    }

    public void setRestClient(RestClient restClient) {
        this.restClient = restClient;
    }
}

