/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console;

import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.Response;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.markup.html.pages.AccessDeniedPage;
import org.apache.wicket.markup.html.pages.ExceptionErrorPage;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.springframework.web.client.RestClientException;
import org.syncope.console.SyncopeSession;
import org.syncope.console.pages.ErrorPage;

public class SyncopeRequestCycle
extends WebRequestCycle {
    public SyncopeRequestCycle(WebApplication application, WebRequest request, Response response) {
        super(application, request, response);
    }

    public final Page onRuntimeException(Page cause, RuntimeException e) {
        if (e instanceof UnauthorizedInstantiationException) {
            return new AccessDeniedPage();
        }
        SyncopeSession session = (SyncopeSession)this.getSession();
        if (e instanceof PageExpiredException || !session.isAuthenticated()) {
            PageParameters errorParameters = new PageParameters();
            errorParameters.add("errorTitle", new StringResourceModel("alert", null).getString());
            errorParameters.add("errorMessage", new StringResourceModel("pageExpiredException", null).getString());
            return new ErrorPage(errorParameters);
        }
        if (e.getCause().getCause() instanceof RestClientException) {
            PageParameters errorParameters = new PageParameters();
            errorParameters.add("errorTitle", new StringResourceModel("alert", null).getString());
            errorParameters.add("errorMessage", new StringResourceModel("restClientException", null).getString());
            return new ErrorPage(errorParameters);
        }
        return new ExceptionErrorPage((Throwable)e, cause);
    }
}

