/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxPreprocessingCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.ConfigurationTO;
import org.syncope.console.commons.Utility;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.ConfigurationModalPage;
import org.syncope.console.rest.ConfigurationsRestClient;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.EditLinkPanel;

public class Configuration
extends BasePage {
    @SpringBean(name="configurationsRestClient")
    ConfigurationsRestClient restClient;
    @SpringBean(name="utility")
    Utility utility;
    final ModalWindow createConfigWin;
    final ModalWindow editConfigWin;
    final int WIN_USER_HEIGHT = 680;
    final int WIN_USER_WIDTH = 1133;
    WebMarkupContainer container;
    boolean operationResult = false;
    FeedbackPanel feedbackPanel = new FeedbackPanel("feedback");
    private int paginatorRows;

    public Configuration(PageParameters parameters) {
        super(parameters);
        this.feedbackPanel.setOutputMarkupId(true);
        this.add(new Component[]{this.feedbackPanel});
        Component[] componentArray = new Component[1];
        this.createConfigWin = new ModalWindow("createConfigurationWin");
        componentArray[0] = this.createConfigWin;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.editConfigWin = new ModalWindow("editConfigurationWin");
        componentArray2[0] = this.editConfigWin;
        this.add(componentArray2);
        this.paginatorRows = this.utility.getPaginatorRowsToDisplay("configuration.paginator.rows");
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("key"))), "confKey", "confKey"));
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("value"))), "confValue", "confValue"));
        columns.add(new AbstractColumn<ConfigurationTO>((IModel)new Model((Serializable)((Object)this.getString("edit")))){

            public void populateItem(Item<ICellPopulator<ConfigurationTO>> cellItem, String componentId, IModel<ConfigurationTO> model) {
                final ConfigurationTO configurationTO = (ConfigurationTO)model.getObject();
                AjaxLink editLink = new AjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Configuration.this.editConfigWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                ConfigurationModalPage window = new ConfigurationModalPage(Configuration.this, Configuration.this.editConfigWin, configurationTO, false);
                                return window;
                            }
                        });
                        Configuration.this.editConfigWin.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                panel.add(new Component[]{editLink});
                String allowedRoles = Configuration.this.xmlRolesReader.getAllAllowedRoles("Configuration", "read");
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedRoles);
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<ConfigurationTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<ConfigurationTO>> cellItem, String componentId, IModel<ConfigurationTO> model) {
                final ConfigurationTO configurationTO = (ConfigurationTO)model.getObject();
                AjaxLink deleteLink = new AjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            Configuration.this.restClient.deleteConfiguration(configurationTO.getConfKey());
                        }
                        catch (UnsupportedEncodingException ex) {
                            Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, null, ex);
                            this.error((Serializable)((Object)ex.getMessage()));
                            return;
                        }
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Configuration.this.feedbackPanel);
                        target.addComponent((Component)Configuration.this.container);
                    }

                    protected IAjaxCallDecorator getAjaxCallDecorator() {
                        return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){
                            private static final long serialVersionUID = 1L;

                            public CharSequence preDecorateScript(CharSequence script) {
                                return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "}";
                            }
                        };
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                panel.add(new Component[]{deleteLink});
                String allowedRoles = Configuration.this.xmlRolesReader.getAllAllowedRoles("Configuration", "delete");
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedRoles);
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("datatable", columns, (ISortableDataProvider)new ConfigurationsProvider(), this.paginatorRows);
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{table});
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.createConfigWin.setCssClassName("w_silver");
        this.createConfigWin.setInitialHeight(680);
        this.createConfigWin.setInitialWidth(1133);
        this.createConfigWin.setPageMapName("create-configuration-modal");
        this.createConfigWin.setCookieName("create-configuration-modal");
        this.editConfigWin.setCssClassName("w_silver");
        this.editConfigWin.setInitialHeight(680);
        this.editConfigWin.setInitialWidth(680);
        this.editConfigWin.setPageMapName("edit-configuration-modal");
        this.editConfigWin.setCookieName("edit-configuration-modal");
        this.setWindowClosedCallback(this.createConfigWin, this.container);
        this.setWindowClosedCallback(this.editConfigWin, this.container);
        AjaxLink createConfigurationLink = new AjaxLink("createConfigurationLink"){

            public void onClick(AjaxRequestTarget target) {
                Configuration.this.createConfigWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        ConfigurationModalPage window = new ConfigurationModalPage(Configuration.this, Configuration.this.createConfigWin, new ConfigurationTO(), true);
                        return window;
                    }
                });
                Configuration.this.createConfigWin.show(target);
            }
        };
        String allowedRoles = this.xmlRolesReader.getAllAllowedRoles("Configuration", "create");
        MetaDataRoleAuthorizationStrategy.authorize((Component)createConfigurationLink, (Action)ENABLE, (String)allowedRoles);
        this.add(new Component[]{createConfigurationLink});
        Form paginatorForm = new Form("PaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.utility.paginatorRowsChooser());
        rowsChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Configuration.this.utility.updatePaginatorRows("configuration.paginator.rows", Configuration.this.paginatorRows);
                table.setRowsPerPage(Configuration.this.paginatorRows);
                target.addComponent((Component)Configuration.this.container);
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
        this.add(new Component[]{paginatorForm});
    }

    public void setWindowClosedCallback(ModalWindow window, final WebMarkupContainer container) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                target.addComponent((Component)container);
                if (Configuration.this.operationResult) {
                    Configuration.this.info(Configuration.this.getString("operation_succeded"));
                    target.addComponent((Component)Configuration.this.feedbackPanel);
                    Configuration.this.operationResult = false;
                }
            }
        });
    }

    public boolean isOperationResult() {
        return this.operationResult;
    }

    public void setOperationResult(boolean operationResult) {
        this.operationResult = operationResult;
    }

    class ConfigurationsProvider
    extends SortableDataProvider<ConfigurationTO> {
        private SortableDataProviderComparator comparator = new SortableDataProviderComparator();

        public ConfigurationsProvider() {
            this.setSort("confKey", true);
        }

        public Iterator<ConfigurationTO> iterator(int first, int count) {
            List<ConfigurationTO> list = this.getConfigurationsListDB();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return this.getConfigurationsListDB().size();
        }

        public IModel<ConfigurationTO> model(final ConfigurationTO configuration) {
            return new AbstractReadOnlyModel<ConfigurationTO>(){

                public ConfigurationTO getObject() {
                    return configuration;
                }
            };
        }

        public List<ConfigurationTO> getConfigurationsListDB() {
            List<ConfigurationTO> list = null;
            list = Configuration.this.restClient.getAllConfigurations();
            return list;
        }

        class SortableDataProviderComparator
        implements Comparator<ConfigurationTO>,
        Serializable {
            SortableDataProviderComparator() {
            }

            @Override
            public int compare(ConfigurationTO o1, ConfigurationTO o2) {
                PropertyModel model1 = new PropertyModel((Object)o1, ConfigurationsProvider.this.getSort().getProperty());
                PropertyModel model2 = new PropertyModel((Object)o2, ConfigurationsProvider.this.getSort().getProperty());
                int result = 1;
                result = model1.getObject() == null && model2.getObject() == null ? 0 : (model1.getObject() == null ? 1 : (model2.getObject() == null ? -1 : ((Comparable)model1.getObject()).compareTo(model2.getObject())));
                result = ConfigurationsProvider.this.getSort().isAscending() ? result : -result;
                return result;
            }
        }
    }
}

