/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxPreprocessingCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.DerivedSchemaTO;
import org.syncope.client.to.SchemaTO;
import org.syncope.console.commons.Utility;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.DerivedSchemaModalPage;
import org.syncope.console.pages.SchemaModalPage;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.EditLinkPanel;

public class Schema
extends BasePage {
    @SpringBean(name="schemaRestClient")
    SchemaRestClient restClient;
    @SpringBean(name="utility")
    Utility utility;
    final ModalWindow createUserSchemaWin;
    final ModalWindow editUserSchemaWin;
    final ModalWindow createUserDerivedSchemaWin;
    final ModalWindow editUserDerivedSchemaWin;
    final ModalWindow createRoleSchemaWin;
    final ModalWindow editRoleSchemaWin;
    final ModalWindow createRoleDerivedSchemaWin;
    final ModalWindow editRoleDerivedSchemaWin;
    final ModalWindow createMembershipSchemaWin;
    final ModalWindow editMembershipSchemaWin;
    final ModalWindow createMembershipDerivedSchemaWin;
    final ModalWindow editMembershipDerivedSchemaWin;
    WebMarkupContainer userSchemaContainer;
    WebMarkupContainer userDerivedSchemaContainer;
    WebMarkupContainer roleSchemasContainer;
    WebMarkupContainer roleDerivedSchemasContainer;
    WebMarkupContainer membershipSchemaContainer;
    WebMarkupContainer membershipDerivedSchemaContainer;
    private int userSchemaPageRows;
    private int userDerSchemaPageRows;
    private int rolePageRows;
    private int roleDerPageRows;
    private int membershipPageRows;
    private int membershipDerPageRows;
    boolean operationResult = false;
    FeedbackPanel feedbackPanel;

    public Schema(PageParameters parameters) {
        super(parameters);
        Component[] componentArray = new Component[1];
        this.createRoleSchemaWin = new ModalWindow("createRoleSchemaWin");
        componentArray[0] = this.createRoleSchemaWin;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.editRoleSchemaWin = new ModalWindow("editRoleSchemaWin");
        componentArray2[0] = this.editRoleSchemaWin;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.createRoleDerivedSchemaWin = new ModalWindow("createRoleDerivedSchemaWin");
        componentArray3[0] = this.createRoleDerivedSchemaWin;
        this.add(componentArray3);
        Component[] componentArray4 = new Component[1];
        this.editRoleDerivedSchemaWin = new ModalWindow("editRoleDerivedSchemaWin");
        componentArray4[0] = this.editRoleDerivedSchemaWin;
        this.add(componentArray4);
        Component[] componentArray5 = new Component[1];
        this.createUserSchemaWin = new ModalWindow("createUserSchemaWin");
        componentArray5[0] = this.createUserSchemaWin;
        this.add(componentArray5);
        Component[] componentArray6 = new Component[1];
        this.editUserSchemaWin = new ModalWindow("editUserSchemaWin");
        componentArray6[0] = this.editUserSchemaWin;
        this.add(componentArray6);
        Component[] componentArray7 = new Component[1];
        this.createUserDerivedSchemaWin = new ModalWindow("createUserDerSchemaWin");
        componentArray7[0] = this.createUserDerivedSchemaWin;
        this.add(componentArray7);
        Component[] componentArray8 = new Component[1];
        this.editUserDerivedSchemaWin = new ModalWindow("editUserDerSchemaWin");
        componentArray8[0] = this.editUserDerivedSchemaWin;
        this.add(componentArray8);
        Component[] componentArray9 = new Component[1];
        this.createMembershipSchemaWin = new ModalWindow("createMembershipSchemaWin");
        componentArray9[0] = this.createMembershipSchemaWin;
        this.add(componentArray9);
        Component[] componentArray10 = new Component[1];
        this.editMembershipSchemaWin = new ModalWindow("editMembershipSchemaWin");
        componentArray10[0] = this.editMembershipSchemaWin;
        this.add(componentArray10);
        Component[] componentArray11 = new Component[1];
        this.createMembershipDerivedSchemaWin = new ModalWindow("createMembershipDerSchemaWin");
        componentArray11[0] = this.createMembershipDerivedSchemaWin;
        this.add(componentArray11);
        Component[] componentArray12 = new Component[1];
        this.editMembershipDerivedSchemaWin = new ModalWindow("editMembershipDerSchemaWin");
        componentArray12[0] = this.editMembershipDerivedSchemaWin;
        this.add(componentArray12);
        this.feedbackPanel = new FeedbackPanel("feedback");
        this.feedbackPanel.setOutputMarkupId(true);
        this.add(new Component[]{this.feedbackPanel});
        this.rolePageRows = this.utility.getPaginatorRowsToDisplay("role.schema.paginator.rows");
        this.roleDerPageRows = this.utility.getPaginatorRowsToDisplay("role.derived.schema.paginator.rows");
        this.userSchemaPageRows = this.utility.getPaginatorRowsToDisplay("user.schema.paginator.rows");
        this.userDerSchemaPageRows = this.utility.getPaginatorRowsToDisplay("user.derived.schema.paginator.rows");
        this.membershipPageRows = this.utility.getPaginatorRowsToDisplay("membership.schema.paginator.rows");
        this.membershipDerPageRows = this.utility.getPaginatorRowsToDisplay("membership.derived.aschema.paginator.rows");
        String allowedCreateRoles = this.xmlRolesReader.getAllAllowedRoles("Schema", "create");
        final String allowedReadRoles = this.xmlRolesReader.getAllAllowedRoles("Schema", "read");
        final String allowedDeleteRoles = this.xmlRolesReader.getAllAllowedRoles("Schema", "delete");
        ArrayList<Object> rolesColumns = new ArrayList<Object>();
        rolesColumns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("name"))), "name", "name"));
        rolesColumns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("type"))), "type", "type"));
        rolesColumns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("attributes"))), "attributes", "attributes"));
        rolesColumns.add(new AbstractColumn<SchemaTO>((IModel)new Model((Serializable)((Object)this.getString("name")))){

            public void populateItem(Item<ICellPopulator<SchemaTO>> cellItem, String componentId, IModel<SchemaTO> model) {
                final SchemaTO schemaTO = (SchemaTO)model.getObject();
                AjaxLink editLink = new AjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.editRoleSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                SchemaModalPage window = new SchemaModalPage(Schema.this, Schema.this.editRoleSchemaWin, schemaTO, false);
                                window.setEntity(SchemaModalPage.Entity.ROLE);
                                return window;
                            }
                        });
                        Schema.this.editRoleSchemaWin.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                panel.add(new Component[]{editLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedReadRoles);
                cellItem.add(new Component[]{panel});
            }
        });
        rolesColumns.add(new AbstractColumn<SchemaTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<SchemaTO>> cellItem, String componentId, IModel<SchemaTO> model) {
                final SchemaTO schemaTO = (SchemaTO)model.getObject();
                AjaxLink deleteLink = new AjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.restClient.deleteRoleSchema(schemaTO.getName());
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Schema.this.feedbackPanel);
                        target.addComponent((Component)Schema.this.roleSchemasContainer);
                    }

                    protected IAjaxCallDecorator getAjaxCallDecorator() {
                        return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){
                            private static final long serialVersionUID = 1L;

                            public CharSequence preDecorateScript(CharSequence script) {
                                return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "}";
                            }
                        };
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedDeleteRoles);
                panel.add(new Component[]{deleteLink});
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable tableRoles = new AjaxFallbackDefaultDataTable("datatable", rolesColumns, (ISortableDataProvider)new SchemaProvider(SchemaType.RoleSchema), this.rolePageRows);
        Form rolesPaginatorForm = new Form("RolesPaginatorForm");
        DropDownChoice rowsRoleChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "rolePageRows"), this.utility.paginatorRowsChooser());
        rowsRoleChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Schema.this.utility.updatePaginatorRows("role.schema.paginator.rows", Schema.this.rolePageRows);
                tableRoles.setRowsPerPage(Schema.this.rolePageRows);
                target.addComponent((Component)Schema.this.roleSchemasContainer);
            }
        }});
        rolesPaginatorForm.add(new Component[]{rowsRoleChooser});
        this.add(new Component[]{rolesPaginatorForm});
        ArrayList<Object> columnsRolesDer = new ArrayList<Object>();
        columnsRolesDer.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("name"))), "name", "name"));
        columnsRolesDer.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("expression"))), "expression", "expression"));
        columnsRolesDer.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("attributes"))), "derivedAttributes", "derivedAttributes"));
        columnsRolesDer.add(new AbstractColumn<DerivedSchemaTO>((IModel)new Model((Serializable)((Object)this.getString("edit")))){

            public void populateItem(Item<ICellPopulator<DerivedSchemaTO>> cellItem, String componentId, IModel<DerivedSchemaTO> model) {
                final DerivedSchemaTO schemaTO = (DerivedSchemaTO)model.getObject();
                AjaxLink editLink = new AjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.editRoleDerivedSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                DerivedSchemaModalPage form = new DerivedSchemaModalPage(Schema.this, Schema.this.editRoleDerivedSchemaWin, schemaTO, false);
                                form.setEntity(DerivedSchemaModalPage.Entity.ROLE);
                                return form;
                            }
                        });
                        Schema.this.editRoleDerivedSchemaWin.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedReadRoles);
                panel.add(new Component[]{editLink});
                cellItem.add(new Component[]{panel});
            }
        });
        columnsRolesDer.add(new AbstractColumn<DerivedSchemaTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<DerivedSchemaTO>> cellItem, String componentId, IModel<DerivedSchemaTO> model) {
                final DerivedSchemaTO schemaTO = (DerivedSchemaTO)model.getObject();
                AjaxLink deleteLink = new AjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.restClient.deleteRoleDerivedSchema(schemaTO.getName());
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Schema.this.feedbackPanel);
                        target.addComponent((Component)Schema.this.roleDerivedSchemasContainer);
                    }

                    protected IAjaxCallDecorator getAjaxCallDecorator() {
                        return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){
                            private static final long serialVersionUID = 1L;

                            public CharSequence preDecorateScript(CharSequence script) {
                                return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "}";
                            }
                        };
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedDeleteRoles);
                panel.add(new Component[]{deleteLink});
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable tableRolesDer = new AjaxFallbackDefaultDataTable("datatable", columnsRolesDer, (ISortableDataProvider)new DerivedSchemaProvider(SchemaDerivedType.RoleDerivedSchema), this.roleDerPageRows);
        Form rolesDerPaginatorForm = new Form("RolesDerPaginatorForm");
        DropDownChoice rowsRolesDerChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "roleDerPageRows"), this.utility.paginatorRowsChooser());
        rowsRolesDerChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Schema.this.utility.updatePaginatorRows("role.derived.schema.paginator.rows", Schema.this.rolePageRows);
                tableRolesDer.setRowsPerPage(Schema.this.roleDerPageRows);
                target.addComponent((Component)Schema.this.roleDerivedSchemasContainer);
            }
        }});
        rolesDerPaginatorForm.add(new Component[]{rowsRolesDerChooser});
        this.add(new Component[]{rolesDerPaginatorForm});
        ArrayList<Object> userColumns = new ArrayList<Object>();
        userColumns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("name"))), "name", "name"));
        userColumns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("type"))), "type", "type"));
        userColumns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("attributes"))), "attributes", "attributes"));
        userColumns.add(new AbstractColumn<SchemaTO>((IModel)new Model((Serializable)((Object)this.getString("edit")))){

            public void populateItem(Item<ICellPopulator<SchemaTO>> cellItem, String componentId, IModel<SchemaTO> model) {
                final SchemaTO schemaTO = (SchemaTO)model.getObject();
                AjaxLink editLink = new AjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.editUserSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                SchemaModalPage form = new SchemaModalPage(Schema.this, Schema.this.editUserSchemaWin, schemaTO, false);
                                form.setEntity(SchemaModalPage.Entity.USER);
                                return form;
                            }
                        });
                        Schema.this.editUserSchemaWin.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedReadRoles);
                panel.add(new Component[]{editLink});
                cellItem.add(new Component[]{panel});
            }
        });
        userColumns.add(new AbstractColumn<SchemaTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<SchemaTO>> cellItem, String componentId, IModel<SchemaTO> model) {
                final SchemaTO schemaTO = (SchemaTO)model.getObject();
                AjaxLink deleteLink = new AjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.restClient.deleteUserSchema(schemaTO.getName());
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Schema.this.feedbackPanel);
                        target.addComponent((Component)Schema.this.userSchemaContainer);
                    }

                    protected IAjaxCallDecorator getAjaxCallDecorator() {
                        return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){
                            private static final long serialVersionUID = 1L;

                            public CharSequence preDecorateScript(CharSequence script) {
                                return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "}";
                            }
                        };
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedDeleteRoles);
                panel.add(new Component[]{deleteLink});
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable tableUsers = new AjaxFallbackDefaultDataTable("datatable", userColumns, (ISortableDataProvider)new SchemaProvider(SchemaType.UserSchema), this.userSchemaPageRows);
        Form usersPaginatorForm = new Form("UsersPaginatorForm");
        DropDownChoice usersRowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "userSchemaPageRows"), this.utility.paginatorRowsChooser());
        usersRowsChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Schema.this.utility.updatePaginatorRows("user.schema.paginator.rows", Schema.this.userSchemaPageRows);
                tableUsers.setRowsPerPage(Schema.this.userSchemaPageRows);
                target.addComponent((Component)Schema.this.userSchemaContainer);
            }
        }});
        usersPaginatorForm.add(new Component[]{usersRowsChooser});
        this.add(new Component[]{usersPaginatorForm});
        ArrayList<Object> columnsUsersDer = new ArrayList<Object>();
        columnsUsersDer.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("name"))), "name", "name"));
        columnsUsersDer.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("expression"))), "expression", "expression"));
        columnsUsersDer.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("attributes"))), "derivedAttributes", "derivedAttributes"));
        columnsUsersDer.add(new AbstractColumn<DerivedSchemaTO>((IModel)new Model((Serializable)((Object)this.getString("edit")))){

            public void populateItem(Item<ICellPopulator<DerivedSchemaTO>> cellItem, String componentId, IModel<DerivedSchemaTO> model) {
                final DerivedSchemaTO schemaTO = (DerivedSchemaTO)model.getObject();
                AjaxLink editLink = new AjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.editUserDerivedSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                DerivedSchemaModalPage window = new DerivedSchemaModalPage(Schema.this, Schema.this.editUserDerivedSchemaWin, schemaTO, false);
                                window.setEntity(DerivedSchemaModalPage.Entity.USER);
                                return window;
                            }
                        });
                        Schema.this.editUserDerivedSchemaWin.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedReadRoles);
                panel.add(new Component[]{editLink});
                cellItem.add(new Component[]{panel});
            }
        });
        columnsUsersDer.add(new AbstractColumn<DerivedSchemaTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<DerivedSchemaTO>> cellItem, String componentId, IModel<DerivedSchemaTO> model) {
                final DerivedSchemaTO schemaTO = (DerivedSchemaTO)model.getObject();
                AjaxLink deleteLink = new AjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.restClient.deleteUserDerivedSchema(schemaTO.getName());
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Schema.this.feedbackPanel);
                        target.addComponent((Component)Schema.this.userDerivedSchemaContainer);
                    }

                    protected IAjaxCallDecorator getAjaxCallDecorator() {
                        return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){
                            private static final long serialVersionUID = 1L;

                            public CharSequence preDecorateScript(CharSequence script) {
                                return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "}";
                            }
                        };
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedDeleteRoles);
                panel.add(new Component[]{deleteLink});
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable tableUsersDer = new AjaxFallbackDefaultDataTable("datatable", columnsUsersDer, (ISortableDataProvider)new DerivedSchemaProvider(SchemaDerivedType.UserDerivedSchema), this.userDerSchemaPageRows);
        Form usersDerPaginatorForm = new Form("UsersDerPaginatorForm");
        DropDownChoice usersDerRowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "userDerSchemaPageRows"), this.utility.paginatorRowsChooser());
        usersDerRowsChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Schema.this.utility.updatePaginatorRows("user.derived.schema.paginator.rows", Schema.this.userDerSchemaPageRows);
                tableUsersDer.setRowsPerPage(Schema.this.userDerSchemaPageRows);
                target.addComponent((Component)Schema.this.userDerivedSchemaContainer);
            }
        }});
        usersDerPaginatorForm.add(new Component[]{usersDerRowsChooser});
        this.add(new Component[]{usersDerPaginatorForm});
        ArrayList<Object> membershipsColumns = new ArrayList<Object>();
        membershipsColumns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("name"))), "name", "name"));
        membershipsColumns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("type"))), "type", "type"));
        membershipsColumns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("attributes"))), "attributes", "attributes"));
        membershipsColumns.add(new AbstractColumn<SchemaTO>((IModel)new Model((Serializable)((Object)this.getString("name")))){

            public void populateItem(Item<ICellPopulator<SchemaTO>> cellItem, String componentId, IModel<SchemaTO> model) {
                final SchemaTO schemaTO = (SchemaTO)model.getObject();
                AjaxLink editLink = new AjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.editMembershipSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                SchemaModalPage form = new SchemaModalPage(Schema.this, Schema.this.editMembershipSchemaWin, schemaTO, false);
                                form.setEntity(SchemaModalPage.Entity.MEMBERSHIP);
                                return form;
                            }
                        });
                        Schema.this.editMembershipSchemaWin.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedReadRoles);
                panel.add(new Component[]{editLink});
                cellItem.add(new Component[]{panel});
            }
        });
        membershipsColumns.add(new AbstractColumn<SchemaTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<SchemaTO>> cellItem, String componentId, IModel<SchemaTO> model) {
                final SchemaTO schemaTO = (SchemaTO)model.getObject();
                AjaxLink deleteLink = new AjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.restClient.deleteMemberhipSchema(schemaTO.getName());
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Schema.this.feedbackPanel);
                        target.addComponent((Component)Schema.this.membershipSchemaContainer);
                    }

                    protected IAjaxCallDecorator getAjaxCallDecorator() {
                        return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){
                            private static final long serialVersionUID = 1L;

                            public CharSequence preDecorateScript(CharSequence script) {
                                return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "}";
                            }
                        };
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedDeleteRoles);
                panel.add(new Component[]{deleteLink});
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable tableMemberships = new AjaxFallbackDefaultDataTable("datatable", membershipsColumns, (ISortableDataProvider)new SchemaProvider(SchemaType.MembershipSchema), this.membershipPageRows);
        Form membershipPaginatorForm = new Form("MembershipPaginatorForm");
        DropDownChoice membershipRowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "membershipPageRows"), this.utility.paginatorRowsChooser());
        membershipRowsChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Schema.this.utility.updatePaginatorRows("membership.schema.paginator.rows", Schema.this.membershipPageRows);
                tableMemberships.setRowsPerPage(Schema.this.membershipPageRows);
                target.addComponent((Component)Schema.this.membershipSchemaContainer);
            }
        }});
        membershipPaginatorForm.add(new Component[]{membershipRowsChooser});
        this.add(new Component[]{membershipPaginatorForm});
        ArrayList<Object> columnsMembershipsDer = new ArrayList<Object>();
        columnsMembershipsDer.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("name"))), "name", "name"));
        columnsMembershipsDer.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("expression"))), "expression", "expression"));
        columnsMembershipsDer.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("attributes"))), "derivedAttributes", "derivedAttributes"));
        columnsMembershipsDer.add(new AbstractColumn<DerivedSchemaTO>((IModel)new Model((Serializable)((Object)this.getString("edit")))){

            public void populateItem(Item<ICellPopulator<DerivedSchemaTO>> cellItem, String componentId, IModel<DerivedSchemaTO> model) {
                final DerivedSchemaTO schemaTO = (DerivedSchemaTO)model.getObject();
                AjaxLink editLink = new AjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.editMembershipDerivedSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                DerivedSchemaModalPage window = new DerivedSchemaModalPage(Schema.this, Schema.this.editMembershipDerivedSchemaWin, schemaTO, false);
                                window.setEntity(DerivedSchemaModalPage.Entity.MEMBERSHIP);
                                return window;
                            }
                        });
                        Schema.this.editMembershipDerivedSchemaWin.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedReadRoles);
                panel.add(new Component[]{editLink});
                cellItem.add(new Component[]{panel});
            }
        });
        columnsMembershipsDer.add(new AbstractColumn<DerivedSchemaTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<DerivedSchemaTO>> cellItem, String componentId, IModel<DerivedSchemaTO> model) {
                final DerivedSchemaTO schemaTO = (DerivedSchemaTO)model.getObject();
                AjaxLink deleteLink = new AjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.restClient.deleteMembershipDerivedSchema(schemaTO.getName());
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Schema.this.feedbackPanel);
                        target.addComponent((Component)Schema.this.membershipDerivedSchemaContainer);
                    }

                    protected IAjaxCallDecorator getAjaxCallDecorator() {
                        return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){
                            private static final long serialVersionUID = 1L;

                            public CharSequence preDecorateScript(CharSequence script) {
                                return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "}";
                            }
                        };
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedDeleteRoles);
                panel.add(new Component[]{deleteLink});
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable tableMembershipsDer = new AjaxFallbackDefaultDataTable("datatable", columnsMembershipsDer, (ISortableDataProvider)new DerivedSchemaProvider(SchemaDerivedType.MembershipDerivedSchema), this.membershipDerPageRows);
        Form membershipDerPaginatorForm = new Form("MembershipDerPaginatorForm");
        DropDownChoice membershipDerRowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "membershipDerPageRows"), this.utility.paginatorRowsChooser());
        membershipDerRowsChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Schema.this.utility.updatePaginatorRows("membership.derived.aschema.paginator.rows", Schema.this.membershipDerPageRows);
                tableMembershipsDer.setRowsPerPage(Schema.this.membershipDerPageRows);
                target.addComponent((Component)Schema.this.membershipDerivedSchemaContainer);
            }
        }});
        membershipDerPaginatorForm.add(new Component[]{membershipDerRowsChooser});
        this.add(new Component[]{membershipDerPaginatorForm});
        this.roleSchemasContainer = new WebMarkupContainer("roleSchemasContainer");
        this.roleSchemasContainer.add(new Component[]{tableRoles});
        this.roleSchemasContainer.setOutputMarkupId(true);
        this.roleDerivedSchemasContainer = new WebMarkupContainer("roleDerivedSchemasContainer");
        this.roleDerivedSchemasContainer.add(new Component[]{tableRolesDer});
        this.roleDerivedSchemasContainer.setOutputMarkupId(true);
        this.userSchemaContainer = new WebMarkupContainer("userSchemaContainer");
        this.userSchemaContainer.add(new Component[]{tableUsers});
        this.userSchemaContainer.setOutputMarkupId(true);
        this.userDerivedSchemaContainer = new WebMarkupContainer("userDerivedSchemaContainer");
        this.userDerivedSchemaContainer.add(new Component[]{tableUsersDer});
        this.userDerivedSchemaContainer.setOutputMarkupId(true);
        this.membershipSchemaContainer = new WebMarkupContainer("membershipSchemaContainer");
        this.membershipSchemaContainer.add(new Component[]{tableMemberships});
        this.membershipSchemaContainer.setOutputMarkupId(true);
        this.membershipDerivedSchemaContainer = new WebMarkupContainer("membershipDerivedSchemaContainer");
        this.membershipDerivedSchemaContainer.add(new Component[]{tableMembershipsDer});
        this.membershipDerivedSchemaContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.roleSchemasContainer});
        this.add(new Component[]{this.roleDerivedSchemasContainer});
        this.add(new Component[]{this.userSchemaContainer});
        this.add(new Component[]{this.userDerivedSchemaContainer});
        this.add(new Component[]{this.membershipSchemaContainer});
        this.add(new Component[]{this.membershipDerivedSchemaContainer});
        this.createUserSchemaWin.setCssClassName("w_silver");
        this.createUserSchemaWin.setPageMapName("modal-1");
        this.createUserSchemaWin.setCookieName("modal-1");
        this.editUserSchemaWin.setCssClassName("w_silver");
        this.editUserSchemaWin.setPageMapName("modal-2");
        this.editUserSchemaWin.setCookieName("modal-2");
        this.createUserDerivedSchemaWin.setCssClassName("w_silver");
        this.createUserDerivedSchemaWin.setPageMapName("modal-3");
        this.createUserDerivedSchemaWin.setCookieName("modal-3");
        this.editUserDerivedSchemaWin.setCssClassName("w_silver");
        this.editUserDerivedSchemaWin.setPageMapName("modal-4");
        this.editUserDerivedSchemaWin.setCookieName("modal-4");
        this.createRoleSchemaWin.setCssClassName("w_silver");
        this.createRoleSchemaWin.setPageMapName("modal-5");
        this.createRoleSchemaWin.setCookieName("modal-5");
        this.editRoleSchemaWin.setCssClassName("w_silver");
        this.editRoleSchemaWin.setPageMapName("modal-6");
        this.editRoleSchemaWin.setCookieName("modal-6");
        this.createRoleDerivedSchemaWin.setCssClassName("w_silver");
        this.createRoleDerivedSchemaWin.setPageMapName("modal-7");
        this.createRoleDerivedSchemaWin.setCookieName("modal-7");
        this.editRoleDerivedSchemaWin.setCssClassName("w_silver");
        this.editRoleDerivedSchemaWin.setPageMapName("modal-8");
        this.editRoleDerivedSchemaWin.setCookieName("modal-8");
        this.createMembershipSchemaWin.setCssClassName("w_silver");
        this.createMembershipSchemaWin.setPageMapName("modal-9");
        this.createMembershipSchemaWin.setCookieName("modal-9");
        this.createMembershipSchemaWin.setCssClassName("w_silver");
        this.createMembershipSchemaWin.setPageMapName("modal-10");
        this.createMembershipSchemaWin.setCookieName("modal-10");
        this.createMembershipDerivedSchemaWin.setCssClassName("w_silver");
        this.createMembershipDerivedSchemaWin.setPageMapName("modal-11");
        this.createMembershipDerivedSchemaWin.setCookieName("modal-11");
        this.editMembershipDerivedSchemaWin.setCssClassName("w_silver");
        this.editMembershipDerivedSchemaWin.setPageMapName("modal-12");
        this.editMembershipDerivedSchemaWin.setCookieName("modal-12");
        this.setWindowClosedCallback(this.createUserSchemaWin, this.userSchemaContainer);
        this.setWindowClosedCallback(this.editUserSchemaWin, this.userSchemaContainer);
        this.setWindowClosedCallback(this.createUserDerivedSchemaWin, this.userDerivedSchemaContainer);
        this.setWindowClosedCallback(this.editUserDerivedSchemaWin, this.userDerivedSchemaContainer);
        this.setWindowClosedCallback(this.createRoleSchemaWin, this.roleSchemasContainer);
        this.setWindowClosedCallback(this.editRoleSchemaWin, this.roleSchemasContainer);
        this.setWindowClosedCallback(this.createRoleDerivedSchemaWin, this.roleDerivedSchemasContainer);
        this.setWindowClosedCallback(this.editRoleDerivedSchemaWin, this.roleDerivedSchemasContainer);
        this.setWindowClosedCallback(this.createMembershipSchemaWin, this.membershipSchemaContainer);
        this.setWindowClosedCallback(this.editMembershipSchemaWin, this.membershipSchemaContainer);
        this.setWindowClosedCallback(this.createMembershipDerivedSchemaWin, this.membershipDerivedSchemaContainer);
        this.setWindowClosedCallback(this.editMembershipDerivedSchemaWin, this.membershipDerivedSchemaContainer);
        AjaxLink createRoleSchemaWinLink = new AjaxLink("createRoleSchemaWinLink"){

            public void onClick(AjaxRequestTarget target) {
                Schema.this.createRoleSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        SchemaModalPage form = new SchemaModalPage(Schema.this, new ModalWindow("createRoleSchemaWin"), null, true);
                        form.setEntity(SchemaModalPage.Entity.ROLE);
                        return form;
                    }
                });
                Schema.this.createRoleSchemaWin.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createRoleSchemaWinLink, (Action)ENABLE, (String)allowedCreateRoles);
        this.add(new Component[]{createRoleSchemaWinLink});
        AjaxLink createRoleDerivedSchemaWinLink = new AjaxLink("createRoleDerivedSchemaWinLink"){

            public void onClick(AjaxRequestTarget target) {
                Schema.this.createRoleDerivedSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        DerivedSchemaModalPage form = new DerivedSchemaModalPage(Schema.this, new ModalWindow("createRoleDerivedSchemaWin"), null, true);
                        form.setEntity(DerivedSchemaModalPage.Entity.ROLE);
                        return form;
                    }
                });
                Schema.this.createRoleDerivedSchemaWin.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createRoleDerivedSchemaWinLink, (Action)ENABLE, (String)allowedCreateRoles);
        this.add(new Component[]{createRoleDerivedSchemaWinLink});
        AjaxLink createUserSchemaWinLink = new AjaxLink("createUserSchemaWinLink"){

            public void onClick(AjaxRequestTarget target) {
                Schema.this.createUserSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        SchemaModalPage form = new SchemaModalPage(Schema.this, new ModalWindow("createUserSchemaWin"), null, true);
                        form.setEntity(SchemaModalPage.Entity.USER);
                        return form;
                    }
                });
                Schema.this.createUserSchemaWin.show(target);
            }
        };
        this.add(new Component[]{createUserSchemaWinLink});
        MetaDataRoleAuthorizationStrategy.authorize((Component)createUserSchemaWinLink, (Action)ENABLE, (String)allowedCreateRoles);
        AjaxLink createUserDerSchemaWinLink = new AjaxLink("createUserDerSchemaWinLink"){

            public void onClick(AjaxRequestTarget target) {
                Schema.this.createUserDerivedSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        DerivedSchemaModalPage form = new DerivedSchemaModalPage(Schema.this, new ModalWindow("createUserDerSchemaModalWin"), null, true);
                        form.setEntity(DerivedSchemaModalPage.Entity.USER);
                        return form;
                    }
                });
                Schema.this.createUserDerivedSchemaWin.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createUserDerSchemaWinLink, (Action)ENABLE, (String)allowedCreateRoles);
        this.add(new Component[]{createUserDerSchemaWinLink});
        AjaxLink createMembershipSchemaWinLink = new AjaxLink("createMembershipSchemaWinLink"){

            public void onClick(AjaxRequestTarget target) {
                Schema.this.createMembershipSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        SchemaModalPage form = new SchemaModalPage(Schema.this, new ModalWindow("createMembershipSchemaModalWin"), null, true);
                        form.setEntity(SchemaModalPage.Entity.MEMBERSHIP);
                        return form;
                    }
                });
                Schema.this.createMembershipSchemaWin.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createMembershipSchemaWinLink, (Action)ENABLE, (String)allowedCreateRoles);
        this.add(new Component[]{createMembershipSchemaWinLink});
        AjaxLink createMembershipDerSchemaWinLink = new AjaxLink("createMembershipDerSchemaWinLink"){

            public void onClick(AjaxRequestTarget target) {
                Schema.this.createMembershipDerivedSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        DerivedSchemaModalPage form = new DerivedSchemaModalPage(Schema.this, new ModalWindow("createMembershipDerivedSchemaWin"), null, true);
                        form.setEntity(DerivedSchemaModalPage.Entity.MEMBERSHIP);
                        return form;
                    }
                });
                Schema.this.createMembershipDerivedSchemaWin.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createMembershipDerSchemaWinLink, (Action)ENABLE, (String)allowedCreateRoles);
        this.add(new Component[]{createMembershipDerSchemaWinLink});
    }

    public void setWindowClosedCallback(ModalWindow window, final WebMarkupContainer container) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                target.addComponent((Component)container);
                if (Schema.this.operationResult) {
                    Schema.this.info(Schema.this.getString("operation_succeded"));
                    target.addComponent((Component)Schema.this.feedbackPanel);
                    Schema.this.operationResult = false;
                }
            }
        });
    }

    public boolean isOperationResult() {
        return this.operationResult;
    }

    public void setOperationResult(boolean operationResult) {
        this.operationResult = operationResult;
    }

    class DerivedSchemaProvider
    extends SortableDataProvider<DerivedSchemaTO> {
        private SortableDataProviderComparator comparator = new SortableDataProviderComparator();
        private SchemaDerivedType schema;

        public DerivedSchemaProvider(SchemaDerivedType schema2) {
            this.schema = schema2;
            this.setSort("name", true);
        }

        public Iterator<DerivedSchemaTO> iterator(int first, int count) {
            List<DerivedSchemaTO> list = this.getAttributesSchemaListDB();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return this.getAttributesSchemaListDB().size();
        }

        public IModel<DerivedSchemaTO> model(final DerivedSchemaTO schema) {
            return new AbstractReadOnlyModel<DerivedSchemaTO>(){

                public DerivedSchemaTO getObject() {
                    return schema;
                }
            };
        }

        public List<DerivedSchemaTO> getAttributesSchemaListDB() {
            List<DerivedSchemaTO> list = null;
            if (this.schema == SchemaDerivedType.RoleDerivedSchema) {
                list = Schema.this.restClient.getAllRoleDerivedSchemas();
            } else if (this.schema == SchemaDerivedType.UserDerivedSchema) {
                list = Schema.this.restClient.getAllUserDerivedSchemas();
            } else if (this.schema == SchemaDerivedType.MembershipDerivedSchema) {
                list = Schema.this.restClient.getAllMembershipDerivedSchemas();
            }
            return list;
        }

        class SortableDataProviderComparator
        implements Comparator<DerivedSchemaTO>,
        Serializable {
            SortableDataProviderComparator() {
            }

            @Override
            public int compare(DerivedSchemaTO o1, DerivedSchemaTO o2) {
                PropertyModel model1 = new PropertyModel((Object)o1, DerivedSchemaProvider.this.getSort().getProperty());
                PropertyModel model2 = new PropertyModel((Object)o2, DerivedSchemaProvider.this.getSort().getProperty());
                int result = 1;
                result = model1.getObject() == null && model2.getObject() == null ? 0 : (model1.getObject() == null ? 1 : (model2.getObject() == null ? -1 : ((Comparable)model1.getObject()).compareTo(model2.getObject())));
                result = DerivedSchemaProvider.this.getSort().isAscending() ? result : -result;
                return result;
            }
        }
    }

    class SchemaProvider
    extends SortableDataProvider<SchemaTO> {
        private SortableDataProviderComparator comparator = new SortableDataProviderComparator();
        private SchemaType schema;

        public SchemaProvider(SchemaType schema2) {
            this.schema = schema2;
            this.setSort("name", true);
        }

        public Iterator<SchemaTO> iterator(int first, int count) {
            List<SchemaTO> list = this.getAttributesSchemaListDB();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return this.getAttributesSchemaListDB().size();
        }

        public IModel<SchemaTO> model(final SchemaTO user) {
            return new AbstractReadOnlyModel<SchemaTO>(){

                public SchemaTO getObject() {
                    return user;
                }
            };
        }

        public List<SchemaTO> getAttributesSchemaListDB() {
            List<SchemaTO> list = null;
            if (this.schema == SchemaType.RoleSchema) {
                list = Schema.this.restClient.getAllRoleSchemas();
            } else if (this.schema == SchemaType.UserSchema) {
                list = Schema.this.restClient.getAllUserSchemas();
            } else if (this.schema == SchemaType.MembershipSchema) {
                list = Schema.this.restClient.getAllMemberhipSchemas();
            }
            return list;
        }

        class SortableDataProviderComparator
        implements Comparator<SchemaTO>,
        Serializable {
            SortableDataProviderComparator() {
            }

            @Override
            public int compare(SchemaTO o1, SchemaTO o2) {
                PropertyModel model1 = new PropertyModel((Object)o1, SchemaProvider.this.getSort().getProperty());
                PropertyModel model2 = new PropertyModel((Object)o2, SchemaProvider.this.getSort().getProperty());
                int result = 1;
                result = model1.getObject() == null && model2.getObject() == null ? 0 : (model1.getObject() == null ? 1 : (model2.getObject() == null ? -1 : ((Comparable)model1.getObject()).compareTo(model2.getObject())));
                result = SchemaProvider.this.getSort().isAscending() ? result : -result;
                return result;
            }
        }
    }

    protected static enum SchemaDerivedType {
        RoleDerivedSchema,
        UserDerivedSchema,
        MembershipDerivedSchema;

    }

    protected static enum SchemaType {
        RoleSchema,
        UserSchema,
        MembershipSchema;

    }
}

