/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxPreprocessingCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.TaskTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.commons.Utility;
import org.syncope.console.commons.XMLRolesReader;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.TaskModalPage;
import org.syncope.console.rest.TasksRestClient;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.EditLinkPanel;
import org.syncope.console.wicket.markup.html.form.LinkPanel;

public class Tasks
extends BasePage {
    @SpringBean(name="tasksRestClient")
    TasksRestClient restClient;
    @SpringBean(name="utility")
    Utility utility;
    @SpringBean(name="xmlRolesReader")
    XMLRolesReader xmlRolesReader;
    private int paginatorRows;
    WebMarkupContainer container;
    boolean operationResult = false;
    FeedbackPanel feedbackPanel;
    ModalWindow window;
    final int WIN_INITIAL_HEIGHT = 515;
    final int WIN_INITIAL_WIDTH = 775;

    public Tasks(PageParameters parameters) {
        super(parameters);
        Component[] componentArray = new Component[1];
        this.window = new ModalWindow("taskWin");
        componentArray[0] = this.window;
        this.add(componentArray);
        this.add(new Component[]{new FeedbackPanel("feedback").setOutputMarkupId(true)});
        this.paginatorRows = this.utility.getPaginatorRowsToDisplay("tasks.paginator.rows");
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("id"))), "id", "id"));
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("accountId"))), "accountId", "accountId"));
        columns.add(new AbstractColumn<TaskTO>((IModel)new Model((Serializable)((Object)this.getString("open")))){

            public void populateItem(Item<ICellPopulator<TaskTO>> cellItem, String componentId, IModel<TaskTO> model) {
                final TaskTO taskTO = (TaskTO)model.getObject();
                AjaxLink viewLink = new AjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Tasks.this.window.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                TaskModalPage modalPage = new TaskModalPage(Tasks.this, Tasks.this.window, taskTO);
                                return modalPage;
                            }
                        });
                        Tasks.this.window.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                panel.add(new Component[]{viewLink});
                String allowedRoles = null;
                allowedRoles = Tasks.this.xmlRolesReader.getAllAllowedRoles("Tasks", "read");
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedRoles);
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<TaskTO>((IModel)new Model((Serializable)((Object)this.getString("execute")))){

            public void populateItem(Item<ICellPopulator<TaskTO>> cellItem, String componentId, IModel<TaskTO> model) {
                final TaskTO taskTO = (TaskTO)model.getObject();
                AjaxLink executeLink = new AjaxLink("link"){

                    public void onClick(AjaxRequestTarget target) {
                        boolean res = false;
                        try {
                            res = Tasks.this.restClient.startTaskExecution(taskTO.getId());
                        }
                        catch (SyncopeClientCompositeErrorException scce) {
                            this.error((Serializable)((Object)scce.getMessage()));
                        }
                        if (res) {
                            this.getSession().info(this.getString("operation_succeded"));
                        }
                        target.addComponent(this.getPage().get("feedback"));
                        target.addComponent((Component)Tasks.this.container);
                    }
                };
                executeLink.add(new Component[]{new Label("linkTitle", Tasks.this.getString("execute"))});
                LinkPanel panel = new LinkPanel(componentId);
                panel.add(new Component[]{executeLink});
                String allowedRoles = null;
                allowedRoles = Tasks.this.xmlRolesReader.getAllAllowedRoles("Tasks", "execute");
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedRoles);
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<TaskTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<TaskTO>> cellItem, String componentId, IModel<TaskTO> model) {
                final TaskTO taskTO = (TaskTO)model.getObject();
                AjaxLink deleteLink = new AjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            Tasks.this.restClient.deleteTask(taskTO.getId());
                        }
                        catch (SyncopeClientCompositeErrorException scce) {
                            this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.addComponent((Component)Tasks.this.container);
                    }

                    protected IAjaxCallDecorator getAjaxCallDecorator() {
                        return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){
                            private static final long serialVersionUID = 1L;

                            public CharSequence preDecorateScript(CharSequence script) {
                                return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "}";
                            }
                        };
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                panel.add(new Component[]{deleteLink});
                String allowedRoles = null;
                allowedRoles = Tasks.this.xmlRolesReader.getAllAllowedRoles("Tasks", "delete");
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedRoles);
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("datatable", columns, (ISortableDataProvider)new TasksProvider(), this.paginatorRows);
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{table});
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                target.addComponent((Component)Tasks.this.container);
                if (Tasks.this.operationResult) {
                    Tasks.this.info(Tasks.this.getString("operation_succeded"));
                    target.addComponent((Component)Tasks.this.feedbackPanel);
                    Tasks.this.operationResult = false;
                }
            }
        });
        this.window.setCssClassName("w_silver");
        this.window.setInitialHeight(515);
        this.window.setInitialWidth(775);
        this.window.setPageMapName("view-task-win");
        this.window.setCookieName("view-task-win");
        Form paginatorForm = new Form("PaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.utility.paginatorRowsChooser());
        rowsChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Tasks.this.utility.updatePaginatorRows("tasks.paginator.rows", Tasks.this.paginatorRows);
                table.setRowsPerPage(Tasks.this.paginatorRows);
                target.addComponent((Component)Tasks.this.container);
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
    }

    class TasksProvider
    extends SortableDataProvider<TaskTO> {
        private SortableDataProviderComparator comparator = new SortableDataProviderComparator();

        public TasksProvider() {
            this.setSort("id", true);
        }

        public Iterator<TaskTO> iterator(int first, int count) {
            List<TaskTO> list = this.getTasksListDB();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return this.getTasksListDB().size();
        }

        public IModel<TaskTO> model(final TaskTO task) {
            return new AbstractReadOnlyModel<TaskTO>(){

                public TaskTO getObject() {
                    return task;
                }
            };
        }

        public List<TaskTO> getTasksListDB() {
            List<TaskTO> list = Tasks.this.restClient.getAllTasks();
            return list;
        }

        class SortableDataProviderComparator
        implements Comparator<TaskTO>,
        Serializable {
            SortableDataProviderComparator() {
            }

            @Override
            public int compare(TaskTO o1, TaskTO o2) {
                PropertyModel model1 = new PropertyModel((Object)o1, TasksProvider.this.getSort().getProperty());
                PropertyModel model2 = new PropertyModel((Object)o2, TasksProvider.this.getSort().getProperty());
                int result = 1;
                result = model1.getObject() == null && model2.getObject() == null ? 0 : (model1.getObject() == null ? 1 : (model2.getObject() == null ? -1 : ((Comparable)model1.getObject()).compareTo(model2.getObject())));
                result = TasksProvider.this.getSort().isAscending() ? result : -result;
                return result;
            }
        }
    }
}

