/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.rest;

import java.util.Arrays;
import java.util.List;
import org.syncope.client.to.TaskExecutionTO;
import org.syncope.client.to.TaskTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.rest.RestClient;
import org.syncope.types.TaskExecutionStatus;

public class TasksRestClient {
    RestClient restClient;

    public List<TaskTO> getAllTasks() {
        List<Object> tasks = Arrays.asList((Object[])this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "task/list.json", TaskTO[].class, new Object[0]));
        return tasks;
    }

    public TaskTO readTask(String taskId) {
        TaskTO taskTO;
        try {
            taskTO = (TaskTO)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "task/read/{taskId}", TaskTO.class, new Object[]{taskId});
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
            return null;
        }
        return taskTO;
    }

    public List<TaskExecutionTO> listExecutions() {
        List<Object> executions = Arrays.asList((Object[])this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "task/execution/list", TaskExecutionTO[].class, new Object[0]));
        return executions;
    }

    public void deleteTask(Long taskId) {
        try {
            this.restClient.getRestTemplate().delete(this.restClient.getBaseURL() + "task/delete/{taskId}", new Object[]{taskId});
        }
        catch (SyncopeClientCompositeErrorException scce) {
            scce.printStackTrace();
            throw scce;
        }
    }

    public boolean startTaskExecution(Long taskId) {
        TaskExecutionTO execution;
        try {
            execution = (TaskExecutionTO)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "task/execute/{taskId}", TaskExecutionTO.class, new Object[]{taskId});
        }
        catch (SyncopeClientCompositeErrorException scce) {
            scce.printStackTrace();
            throw scce;
        }
        return execution.getStatus() == TaskExecutionStatus.SUBMITTED;
    }

    public boolean deleteTaskExecution(Long execId) {
        try {
            this.restClient.getRestTemplate().delete(this.restClient.getBaseURL() + "task/execution/delete/{execId}", new Object[]{execId});
        }
        catch (SyncopeClientCompositeErrorException scce) {
            scce.printStackTrace();
            throw scce;
        }
        return true;
    }

    public RestClient getRestClient() {
        return this.restClient;
    }

    public void setRestClient(RestClient restClient) {
        this.restClient = restClient;
    }
}

