/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxPreprocessingCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.ConnectorInstanceTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.console.commons.Utility;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.ConnectorsModalPage;
import org.syncope.console.rest.ConnectorsRestClient;
import org.syncope.console.rest.ResourcesRestClient;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.EditLinkPanel;

public class Connectors
extends BasePage {
    @SpringBean(name="connectorsRestClient")
    ConnectorsRestClient restClient;
    @SpringBean(name="resourcesRestClient")
    ResourcesRestClient resourcesRestClient;
    @SpringBean(name="utility")
    Utility utility;
    final ModalWindow createConnectorWin;
    final ModalWindow editConnectorWin;
    WebMarkupContainer container;
    boolean operationResult = false;
    FeedbackPanel feedbackPanel;
    private int paginatorRows;

    public Connectors(PageParameters parameters) {
        super(parameters);
        Component[] componentArray = new Component[1];
        this.createConnectorWin = new ModalWindow("createConnectorWin");
        componentArray[0] = this.createConnectorWin;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.editConnectorWin = new ModalWindow("editConnectorWin");
        componentArray2[0] = this.editConnectorWin;
        this.add(componentArray2);
        this.feedbackPanel = new FeedbackPanel("feedback");
        this.feedbackPanel.setOutputMarkupId(true);
        this.add(new Component[]{this.feedbackPanel});
        this.paginatorRows = this.utility.getPaginatorRowsToDisplay("connectors.paginator.rows");
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("id"))), "id", "id"));
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("name"))), "connectorName", "connectorName"));
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("version"))), "version", "version"));
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("bundleName"))), "bundleName", "bundleName"));
        columns.add(new AbstractColumn<ConnectorInstanceTO>((IModel)new Model((Serializable)((Object)this.getString("edit")))){

            public void populateItem(Item<ICellPopulator<ConnectorInstanceTO>> cellItem, String componentId, IModel<ConnectorInstanceTO> model) {
                final ConnectorInstanceTO connectorTO = (ConnectorInstanceTO)model.getObject();
                AjaxLink editLink = new AjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Connectors.this.editConnectorWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                ConnectorsModalPage form = new ConnectorsModalPage(Connectors.this, Connectors.this.editConnectorWin, connectorTO, false);
                                return form;
                            }
                        });
                        Connectors.this.editConnectorWin.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                panel.add(new Component[]{editLink});
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<ConnectorInstanceTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<ConnectorInstanceTO>> cellItem, String componentId, IModel<ConnectorInstanceTO> model) {
                final ConnectorInstanceTO connectorTO = (ConnectorInstanceTO)model.getObject();
                AjaxLink deleteLink = new AjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        if (!Connectors.this.checkDeleteIsForbidden(connectorTO)) {
                            Connectors.this.restClient.deleteConnector(connectorTO.getId());
                            this.info(this.getString("operation_succeded"));
                        } else {
                            this.error((Serializable)((Object)this.getString("delete_error")));
                        }
                        target.addComponent((Component)Connectors.this.container);
                        target.addComponent((Component)Connectors.this.feedbackPanel);
                    }

                    protected IAjaxCallDecorator getAjaxCallDecorator() {
                        return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){
                            private static final long serialVersionUID = 1L;

                            public CharSequence preDecorateScript(CharSequence script) {
                                return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "}";
                            }
                        };
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                panel.add(new Component[]{deleteLink});
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("datatable", columns, (ISortableDataProvider)new ConnectorsProvider(), this.paginatorRows);
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{table});
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.setWindowClosedCallback(this.createConnectorWin, this.container);
        this.setWindowClosedCallback(this.editConnectorWin, this.container);
        this.createConnectorWin.setCssClassName("w_silver");
        this.createConnectorWin.setPageMapName("create-conn-modal");
        this.createConnectorWin.setCookieName("create-conn-modal");
        this.editConnectorWin.setCssClassName("w_silver");
        this.editConnectorWin.setPageMapName("edit-conn-modal");
        this.editConnectorWin.setCookieName("edit-conn-modal");
        this.add(new Component[]{new AjaxLink("createConnectorLink"){

            public void onClick(AjaxRequestTarget target) {
                Connectors.this.createConnectorWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        ConnectorsModalPage form = new ConnectorsModalPage(Connectors.this, Connectors.this.editConnectorWin, new ConnectorInstanceTO(), true);
                        return form;
                    }
                });
                Connectors.this.createConnectorWin.show(target);
            }
        }});
        Form paginatorForm = new Form("PaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.utility.paginatorRowsChooser());
        rowsChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Connectors.this.utility.updatePaginatorRows("connectors.paginator.rows", Connectors.this.paginatorRows);
                table.setRowsPerPage(Connectors.this.paginatorRows);
                target.addComponent((Component)Connectors.this.container);
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
    }

    public boolean checkDeleteIsForbidden(ConnectorInstanceTO connectorTO) {
        boolean forbidden = false;
        List<ResourceTO> resources = this.resourcesRestClient.getAllResources();
        for (ResourceTO resourceTO : resources) {
            if (resourceTO.getConnectorId() != connectorTO.getId()) continue;
            forbidden = true;
        }
        return forbidden;
    }

    public void setWindowClosedCallback(ModalWindow window, final WebMarkupContainer container) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                target.addComponent((Component)container);
                if (Connectors.this.operationResult) {
                    Connectors.this.info(Connectors.this.getString("operation_succeded"));
                    target.addComponent((Component)Connectors.this.feedbackPanel);
                    Connectors.this.operationResult = false;
                }
            }
        });
    }

    public boolean isOperationResult() {
        return this.operationResult;
    }

    public void setOperationResult(boolean operationResult) {
        this.operationResult = operationResult;
    }

    class ConnectorsProvider
    extends SortableDataProvider<ConnectorInstanceTO> {
        private SortableDataProviderComparator comparator = new SortableDataProviderComparator();

        public ConnectorsProvider() {
            this.setSort("id", true);
        }

        public Iterator<ConnectorInstanceTO> iterator(int first, int count) {
            List<ConnectorInstanceTO> list = this.getConnectorsListDB();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return this.getConnectorsListDB().size();
        }

        public IModel<ConnectorInstanceTO> model(final ConnectorInstanceTO connector) {
            return new AbstractReadOnlyModel<ConnectorInstanceTO>(){

                public ConnectorInstanceTO getObject() {
                    return connector;
                }
            };
        }

        public List<ConnectorInstanceTO> getConnectorsListDB() {
            List<ConnectorInstanceTO> list = Connectors.this.restClient.getAllConnectors();
            return list;
        }

        class SortableDataProviderComparator
        implements Comparator<ConnectorInstanceTO>,
        Serializable {
            SortableDataProviderComparator() {
            }

            @Override
            public int compare(ConnectorInstanceTO o1, ConnectorInstanceTO o2) {
                PropertyModel model1 = new PropertyModel((Object)o1, ConnectorsProvider.this.getSort().getProperty());
                PropertyModel model2 = new PropertyModel((Object)o2, ConnectorsProvider.this.getSort().getProperty());
                int result = 1;
                result = model1.getObject() == null && model2.getObject() == null ? 0 : (model1.getObject() == null ? 1 : (model2.getObject() == null ? -1 : ((Comparable)model1.getObject()).compareTo(model2.getObject())));
                result = ConnectorsProvider.this.getSort().isAscending() ? result : -result;
                return result;
            }
        }
    }
}

