/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.Session;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.syncope.console.SyncopeApplication;
import org.syncope.console.SyncopeSession;
import org.syncope.console.SyncopeUser;
import org.syncope.console.pages.Authentication;
import org.syncope.console.pages.WelcomePage;

public class Login
extends WebPage {
    public Form form = new Form("login");
    public TextField usernameField = new TextField("username", (IModel)new Model());
    public TextField passwordField;
    public DropDownChoice<String> languageSelect;
    public InputStream inputStream;

    public Login(PageParameters parameters) {
        super(parameters);
        this.usernameField.setMarkupId("username");
        this.form.add(new Component[]{this.usernameField});
        this.passwordField = new PasswordTextField("password", (IModel)new Model());
        this.passwordField.setMarkupId("password");
        this.form.add(new Component[]{this.passwordField});
        this.languageSelect = new LocaleDropDown("language", Arrays.asList(Locale.ENGLISH, Locale.ITALIAN));
        this.form.add(new Component[]{this.languageSelect});
        Button submitButton = new Button("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){

            public void onSubmit() {
                Login.this.inputStream = ((SyncopeApplication)this.getApplication()).getAuthenticationFile();
                Authentication auth = new Authentication();
                Boolean authenticated = auth.authentication(Login.this.usernameField.getRawInput(), Login.this.passwordField.getRawInput(), Login.this.inputStream);
                if (authenticated.booleanValue()) {
                    SyncopeUser user = new SyncopeUser();
                    user.setUsername(Login.this.usernameField.getRawInput());
                    ((SyncopeSession)Session.get()).setUser(user);
                    this.setResponsePage((Page)new WelcomePage(null));
                    try {
                        Login.this.inputStream.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(Login.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    this.error((Serializable)((Object)this.getString("login-error")));
                }
            }
        };
        submitButton.setDefaultFormProcessing(false);
        this.form.add(new Component[]{submitButton});
        this.add(new Component[]{this.form});
        this.add(new Component[]{new FeedbackPanel("feedback")});
    }

    public class LocaleDropDown
    extends DropDownChoice {
        public LocaleDropDown(String id, List<Locale> supportedLocales) {
            super(id, supportedLocales);
            this.setChoiceRenderer((IChoiceRenderer)new LocaleRenderer());
            this.setModel(new IModel(){

                public Object getObject() {
                    return LocaleDropDown.this.getSession().getLocale();
                }

                public void setObject(Object object) {
                    LocaleDropDown.this.getSession().setLocale((Locale)object);
                }

                public void detach() {
                }
            });
            this.getModel().setObject((Object)Locale.ENGLISH);
        }

        protected boolean wantOnSelectionChangedNotifications() {
            return true;
        }

        private class LocaleRenderer
        extends ChoiceRenderer {
            private LocaleRenderer() {
            }

            public String getDisplayValue(Object locale) {
                return ((Locale)locale).getDisplayName(LocaleDropDown.this.getLocale());
            }
        }
    }
}

