/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;
import org.syncope.client.to.ConnectorInstanceTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.client.to.SchemaMappingTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.SyncopeApplication;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.Resources;
import org.syncope.console.pages.SyncopeModalPage;
import org.syncope.console.rest.ConnectorsRestClient;
import org.syncope.console.rest.ResourcesRestClient;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.wicket.markup.html.form.UpdatingAutoCompleteTextField;
import org.syncope.console.wicket.markup.html.form.UpdatingCheckBox;
import org.syncope.console.wicket.markup.html.form.UpdatingDropDownChoice;
import org.syncope.console.wicket.markup.html.form.UpdatingTextField;
import org.syncope.types.SchemaType;

public class ResourceModalPage
extends SyncopeModalPage {
    public TextField resourceName;
    public DropDownChoice connector;
    public CheckBox forceMandatoryConstraint;
    ConnectorInstanceTO connectorTO = new ConnectorInstanceTO();
    private ResourceTO resource;
    public AjaxButton submit;
    public AjaxButton addSchemaMappingBtn;
    private List<String> accountIdAttributesNames;
    private List<String> passwordAttributesNames;
    private List<String> userSchemaAttributesNames;
    private List<String> roleSchemaAttributesNames;
    private List<String> membershipSchemaAttributesNames;
    private Map<String, String> errors = new HashMap<String, String>();
    ListView mappingUserSchemaView;
    @SpringBean(name="resourcesRestClient")
    ResourcesRestClient restClient;
    WebMarkupContainer mappingUserSchemaContainer;
    SchemaRestClient schemaRestClient;

    public ResourceModalPage(final BasePage basePage, final ModalWindow window, final ResourceTO resourceTO, final boolean createFlag) {
        this.resource = resourceTO;
        this.schemaRestClient = (SchemaRestClient)((SyncopeApplication)Application.get()).getApplicationContext().getBean("schemaRestClient");
        this.setupChoiceListsPopulators();
        Form resourceForm = new Form("ResourceForm");
        resourceForm.setModel((IModel)new CompoundPropertyModel((Object)resourceTO));
        if (!createFlag) {
            this.connectorTO.setId(resourceTO.getConnectorId());
        }
        LoadableDetachableModel connectors = new LoadableDetachableModel(){

            protected Object load() {
                ConnectorsRestClient connectorRestClient = (ConnectorsRestClient)((SyncopeApplication)Application.get()).getApplicationContext().getBean("connectorsRestClient");
                return connectorRestClient.getAllConnectors();
            }
        };
        LoadableDetachableModel schemaTypesList = new LoadableDetachableModel(){

            protected Object load() {
                return Arrays.asList(SchemaType.values());
            }
        };
        this.resourceName = new TextField("name");
        this.resourceName.setEnabled(createFlag);
        this.resourceName.setRequired(true);
        this.resourceName.setOutputMarkupId(true);
        resourceForm.add(new Component[]{this.resourceName});
        this.forceMandatoryConstraint = new CheckBox("forceMandatoryConstraint");
        this.forceMandatoryConstraint.setOutputMarkupId(true);
        resourceForm.add(new Component[]{this.forceMandatoryConstraint});
        ChoiceRenderer renderer = new ChoiceRenderer("displayName", "id");
        this.connector = new DropDownChoice("connectors", (IModel)new Model((Serializable)this.connectorTO), (IModel)connectors, (IChoiceRenderer)renderer);
        this.connector.setEnabled(createFlag);
        this.connector.setModel(new IModel(){

            public Object getObject() {
                return ResourceModalPage.this.connectorTO;
            }

            public void setObject(Object object) {
                ConnectorInstanceTO connector = (ConnectorInstanceTO)object;
                resourceTO.setConnectorId(connector.getId());
            }

            public void detach() {
            }
        });
        this.connector.setRequired(true);
        this.connector.setEnabled(createFlag);
        resourceForm.add(new Component[]{this.connector});
        this.mappingUserSchemaView = new ListView("mappingsUserSchema", resourceTO.getMappings(), (IModel)schemaTypesList){
            SchemaMappingTO mappingTO;
            UpdatingDropDownChoice schemaAttributeChoice;
            final /* synthetic */ IModel val$schemaTypesList;
            {
                this.val$schemaTypesList = iModel;
                super(x0, x1);
                this.mappingTO = null;
                this.schemaAttributeChoice = null;
            }

            protected void populateItem(ListItem item) {
                this.mappingTO = (SchemaMappingTO)item.getDefaultModelObject();
                item.add(new Component[]{new AjaxCheckBox("toRemove", (IModel)new Model((Serializable)new Boolean(""))){

                    protected void onUpdate(AjaxRequestTarget target) {
                        int id = new Integer(this.getParent().getId());
                        resourceTO.getMappings().remove(id);
                        target.addComponent((Component)ResourceModalPage.this.mappingUserSchemaContainer);
                    }
                }});
                item.add(new Component[]{new UpdatingTextField("field", (IModel)new PropertyModel((Object)this.mappingTO, "field")).setRequired(true).setLabel((IModel)new Model((Serializable)((Object)this.getString("fieldName"))))});
                this.schemaAttributeChoice = new UpdatingDropDownChoice("schemaAttributes", new PropertyModel((Object)this.mappingTO, "schemaName"), null);
                if (this.mappingTO.getSchemaType() == null) {
                    this.schemaAttributeChoice.setChoices(Collections.emptyList());
                } else if (this.mappingTO.getSchemaType().equals((Object)SchemaType.UserSchema)) {
                    this.schemaAttributeChoice.setChoices(ResourceModalPage.this.userSchemaAttributesNames);
                    this.schemaAttributeChoice.setRequired(true);
                } else if (this.mappingTO.getSchemaType().equals((Object)SchemaType.RoleSchema)) {
                    this.schemaAttributeChoice.setChoices(ResourceModalPage.this.roleSchemaAttributesNames);
                    this.schemaAttributeChoice.setRequired(true);
                } else if (this.mappingTO.getSchemaType().equals((Object)SchemaType.MembershipSchema)) {
                    this.schemaAttributeChoice.setChoices(ResourceModalPage.this.membershipSchemaAttributesNames);
                    this.schemaAttributeChoice.setRequired(true);
                } else if (this.mappingTO.getSchemaType().equals((Object)SchemaType.AccountId)) {
                    this.schemaAttributeChoice.setEnabled(false);
                    this.schemaAttributeChoice.setRequired(false);
                    this.schemaAttributeChoice.setChoices(Collections.emptyList());
                    this.mappingTO.setSchemaName("AccountId");
                } else if (this.mappingTO.getSchemaType().equals((Object)SchemaType.Password)) {
                    this.schemaAttributeChoice.setEnabled(false);
                    this.schemaAttributeChoice.setRequired(false);
                    this.schemaAttributeChoice.setChoices(Collections.emptyList());
                    this.mappingTO.setSchemaName("Password");
                }
                this.schemaAttributeChoice.setOutputMarkupId(true);
                item.add(new Component[]{this.schemaAttributeChoice});
                item.add(new Component[]{new SchemaTypesDropDownChoice("schemaTypes", new PropertyModel((Object)this.mappingTO, "schemaType"), this.val$schemaTypesList, this.schemaAttributeChoice).setRequired(true).setOutputMarkupId(true)});
                item.add(new Component[]{new UpdatingAutoCompleteTextField("mandatoryCondition", (IModel)new PropertyModel((Object)this.mappingTO, "mandatoryCondition")){

                    protected Iterator getChoices(String input) {
                        List<Object> choices = new ArrayList();
                        if (Strings.isEmpty((CharSequence)input)) {
                            choices = Collections.emptyList();
                            return choices.iterator();
                        }
                        if ("true".startsWith(input.toLowerCase())) {
                            choices.add("true");
                        } else if ("false".startsWith(input.toLowerCase())) {
                            choices.add("false");
                        }
                        return choices.iterator();
                    }
                }});
                item.add(new Component[]{new UpdatingCheckBox("accountId", (IModel<Boolean>)new PropertyModel((Object)this.mappingTO, "accountid"))});
                item.add(new Component[]{new UpdatingCheckBox("password", (IModel<Boolean>)new PropertyModel((Object)this.mappingTO, "password"))});
            }
        };
        this.mappingUserSchemaContainer = new WebMarkupContainer("mappingUserSchemaContainer");
        this.mappingUserSchemaContainer.add(new Component[]{this.mappingUserSchemaView});
        this.mappingUserSchemaContainer.setOutputMarkupId(true);
        resourceForm.add(new Component[]{this.mappingUserSchemaContainer});
        this.addSchemaMappingBtn = new AjaxButton("addUserSchemaMappingBtn", (IModel)new Model((Serializable)((Object)this.getString("add")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                resourceTO.getMappings().add(new SchemaMappingTO());
                target.addComponent((Component)ResourceModalPage.this.mappingUserSchemaContainer);
            }
        };
        this.addSchemaMappingBtn.setDefaultFormProcessing(false);
        resourceForm.add(new Component[]{this.addSchemaMappingBtn});
        this.submit = new AjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                ResourceTO resourceTO = (ResourceTO)form.getDefaultModelObject();
                try {
                    ResourceModalPage.this.resourceFormCustomValidation();
                }
                catch (IllegalArgumentException e) {
                    for (String error : ResourceModalPage.this.errors.values()) {
                        this.error((Serializable)((Object)error));
                    }
                    ResourceModalPage.this.errors.clear();
                    return;
                }
                try {
                    if (createFlag) {
                        ResourceModalPage.this.restClient.createResource(resourceTO);
                    } else {
                        ResourceModalPage.this.restClient.updateResource(resourceTO);
                    }
                    Resources callerPage = (Resources)basePage;
                    callerPage.setOperationResult(true);
                    window.close(target);
                }
                catch (SyncopeClientCompositeErrorException e) {
                    this.error((Serializable)((Object)(this.getString("error") + ":" + e.getMessage())));
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent(form.get("feedback"));
            }
        };
        resourceForm.add(new Component[]{this.submit});
        resourceForm.add(new Component[]{new FeedbackPanel("feedback").setOutputMarkupId(true)});
        this.add(new Component[]{resourceForm});
    }

    public void resourceFormCustomValidation() {
        int count = 0;
        for (SchemaMappingTO schemaMapping : this.resource.getMappings()) {
            if (schemaMapping.isAccountid()) {
                ++count;
            }
            if (count <= 1) continue;
            this.errors.put("accountId", this.getString("accountIdValidation"));
            break;
        }
        count = 0;
        for (SchemaMappingTO schemaMapping : this.resource.getMappings()) {
            if (schemaMapping.isPassword()) {
                ++count;
            }
            if (count <= 1) continue;
            this.errors.put("password", this.getString("passwordValidation"));
            break;
        }
        if (this.errors.size() > 0) {
            throw new IllegalArgumentException(this.getString("customValidation"));
        }
    }

    public void setupChoiceListsPopulators() {
        ArrayList<String> accountIdList = new ArrayList<String>();
        accountIdList.add("accountId");
        this.setAccountIdAttributesNames(accountIdList);
        ArrayList<String> passwordList = new ArrayList<String>();
        passwordList.add("password");
        this.setPasswordAttributesNames(passwordList);
        this.setRoleSchemaAttributesNames(this.schemaRestClient.getAllRoleSchemasNames());
        this.setUserSchemaAttributesNames(this.schemaRestClient.getAllUserSchemasNames());
        this.setMembershipSchemaAttributesNames(this.schemaRestClient.getAllMembershipSchemasNames());
    }

    public List<String> getMembershipSchemaAttributesNames() {
        return this.membershipSchemaAttributesNames;
    }

    public void setMembershipSchemaAttributesNames(List<String> membershipSchemaAttributesNames) {
        this.membershipSchemaAttributesNames = membershipSchemaAttributesNames;
    }

    public List<String> getRoleSchemaAttributesNames() {
        return this.roleSchemaAttributesNames;
    }

    public void setRoleSchemaAttributesNames(List<String> roleSchemaAttributesNames) {
        this.roleSchemaAttributesNames = roleSchemaAttributesNames;
    }

    public List<String> getUserSchemaAttributesNames() {
        return this.userSchemaAttributesNames;
    }

    public void setUserSchemaAttributesNames(List<String> userSchemaAttributesNames) {
        this.userSchemaAttributesNames = userSchemaAttributesNames;
    }

    public List<String> getAccountIdAttributesNames() {
        return this.accountIdAttributesNames;
    }

    public void setAccountIdAttributesNames(List<String> accountIdAttributesNames) {
        this.accountIdAttributesNames = accountIdAttributesNames;
    }

    public List<String> getPasswordAttributesNames() {
        return this.passwordAttributesNames;
    }

    public void setPasswordAttributesNames(List<String> passwordAttributesNames) {
        this.passwordAttributesNames = passwordAttributesNames;
    }

    public class SchemaTypesDropDownChoice
    extends DropDownChoice {
        SchemaMappingTO schemaMappingModel;

        public SchemaTypesDropDownChoice(String id, PropertyModel model, IModel imodel, final DropDownChoice chooserToPopulate) {
            super(id, (IModel)model, imodel);
            this.schemaMappingModel = (SchemaMappingTO)model.getTarget();
            this.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

                protected void onUpdate(AjaxRequestTarget target) {
                    chooserToPopulate.setChoices((IModel)new LoadableDetachableModel(){

                        protected Object load() {
                            SchemaType schemaType = SchemaTypesDropDownChoice.this.schemaMappingModel.getSchemaType();
                            if (schemaType == null) {
                                return Collections.emptyList();
                            }
                            if (schemaType.equals((Object)SchemaType.RoleSchema)) {
                                return ResourceModalPage.this.roleSchemaAttributesNames;
                            }
                            if (schemaType.equals((Object)SchemaType.UserSchema)) {
                                return ResourceModalPage.this.userSchemaAttributesNames;
                            }
                            if (schemaType.equals((Object)SchemaType.MembershipSchema)) {
                                return ResourceModalPage.this.membershipSchemaAttributesNames;
                            }
                            if (schemaType.equals((Object)SchemaType.AccountId)) {
                                return Collections.emptyList();
                            }
                            if (schemaType.equals((Object)SchemaType.Password)) {
                                return Collections.emptyList();
                            }
                            return Collections.emptyList();
                        }
                    });
                    target.addComponent((Component)chooserToPopulate);
                    target.addComponent((Component)ResourceModalPage.this.mappingUserSchemaContainer);
                }
            }});
        }
    }
}

