/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxPreprocessingCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.ResourceTO;
import org.syncope.console.commons.Utility;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.ResourceModalPage;
import org.syncope.console.rest.ResourcesRestClient;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.EditLinkPanel;

public class Resources
extends BasePage {
    @SpringBean(name="resourcesRestClient")
    ResourcesRestClient restClient;
    @SpringBean(name="utility")
    Utility utility;
    final ModalWindow createResourceWin;
    final ModalWindow editResourceWin;
    final int WIN_INITIAL_HEIGHT = 515;
    final int WIN_INITIAL_WIDTH = 775;
    WebMarkupContainer container;
    boolean operationResult = false;
    FeedbackPanel feedbackPanel;
    private int paginatorRows;

    public Resources(PageParameters parameters) {
        super(parameters);
        Component[] componentArray = new Component[1];
        this.createResourceWin = new ModalWindow("createResourceWin");
        componentArray[0] = this.createResourceWin;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.editResourceWin = new ModalWindow("editResourceWin");
        componentArray2[0] = this.editResourceWin;
        this.add(componentArray2);
        this.feedbackPanel = new FeedbackPanel("feedback");
        this.feedbackPanel.setOutputMarkupId(true);
        this.add(new Component[]{this.feedbackPanel});
        this.paginatorRows = this.utility.getPaginatorRowsToDisplay("resources.paginator.rows");
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("name"))), "name", "name"));
        columns.add(new AbstractColumn<ResourceTO>((IModel)new Model((Serializable)((Object)this.getString("edit")))){

            public void populateItem(Item<ICellPopulator<ResourceTO>> cellItem, String componentId, IModel<ResourceTO> model) {
                final ResourceTO resourceTO = (ResourceTO)model.getObject();
                AjaxLink editLink = new AjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Resources.this.editResourceWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                ResourceModalPage form = new ResourceModalPage(Resources.this, Resources.this.editResourceWin, resourceTO, false);
                                return form;
                            }
                        });
                        Resources.this.editResourceWin.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                panel.add(new Component[]{editLink});
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<ResourceTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<ResourceTO>> cellItem, String componentId, IModel<ResourceTO> model) {
                final ResourceTO resourceTO = (ResourceTO)model.getObject();
                AjaxLink deleteLink = new AjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Resources.this.restClient.deleteResource(resourceTO.getName());
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Resources.this.feedbackPanel);
                        target.addComponent((Component)Resources.this.container);
                    }

                    protected IAjaxCallDecorator getAjaxCallDecorator() {
                        return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){
                            private static final long serialVersionUID = 1L;

                            public CharSequence preDecorateScript(CharSequence script) {
                                return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "}";
                            }
                        };
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                panel.add(new Component[]{deleteLink});
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("datatable", columns, (ISortableDataProvider)new ResourcesProvider(), this.paginatorRows);
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{table});
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.setWindowClosedCallback(this.createResourceWin, this.container);
        this.setWindowClosedCallback(this.editResourceWin, this.container);
        this.createResourceWin.setCssClassName("w_silver");
        this.createResourceWin.setInitialHeight(515);
        this.createResourceWin.setInitialWidth(775);
        this.createResourceWin.setPageMapName("create-res-modal");
        this.createResourceWin.setCookieName("create-res-modal");
        this.editResourceWin.setCssClassName("w_silver");
        this.editResourceWin.setInitialHeight(515);
        this.editResourceWin.setInitialWidth(775);
        this.editResourceWin.setPageMapName("edit-res-modal");
        this.editResourceWin.setCookieName("edit-res-modal");
        this.add(new Component[]{new AjaxLink("createResourceLink"){

            public void onClick(AjaxRequestTarget target) {
                Resources.this.createResourceWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        ResourceModalPage windows = new ResourceModalPage(Resources.this, Resources.this.editResourceWin, new ResourceTO(), true);
                        return windows;
                    }
                });
                Resources.this.createResourceWin.show(target);
            }
        }});
        Form paginatorForm = new Form("PaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.utility.paginatorRowsChooser());
        rowsChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Resources.this.utility.updatePaginatorRows("resources.paginator.rows", Resources.this.paginatorRows);
                table.setRowsPerPage(Resources.this.paginatorRows);
                target.addComponent((Component)Resources.this.container);
                target.addComponent(Resources.this.getPage().get("resourcesNavigator"));
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
    }

    public boolean isOperationResult() {
        return this.operationResult;
    }

    public void setOperationResult(boolean operationResult) {
        this.operationResult = operationResult;
    }

    public void setWindowClosedCallback(ModalWindow window, final WebMarkupContainer container) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                target.addComponent((Component)container);
                if (Resources.this.operationResult) {
                    Resources.this.info(Resources.this.getString("operation_succeded"));
                    target.addComponent((Component)Resources.this.feedbackPanel);
                    Resources.this.operationResult = false;
                }
            }
        });
    }

    class ResourcesProvider
    extends SortableDataProvider<ResourceTO> {
        private SortableDataProviderComparator comparator = new SortableDataProviderComparator();

        public ResourcesProvider() {
            this.setSort("name", true);
        }

        public Iterator<ResourceTO> iterator(int first, int count) {
            List<ResourceTO> list = this.getResourcesListDB();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return this.getResourcesListDB().size();
        }

        public IModel<ResourceTO> model(final ResourceTO resource) {
            return new AbstractReadOnlyModel<ResourceTO>(){

                public ResourceTO getObject() {
                    return resource;
                }
            };
        }

        public List<ResourceTO> getResourcesListDB() {
            List<ResourceTO> list = Resources.this.restClient.getAllResources();
            return list;
        }

        class SortableDataProviderComparator
        implements Comparator<ResourceTO>,
        Serializable {
            SortableDataProviderComparator() {
            }

            @Override
            public int compare(ResourceTO o1, ResourceTO o2) {
                PropertyModel model1 = new PropertyModel((Object)o1, ResourcesProvider.this.getSort().getProperty());
                PropertyModel model2 = new PropertyModel((Object)o2, ResourcesProvider.this.getSort().getProperty());
                int result = 1;
                result = model1.getObject() == null && model2.getObject() == null ? 0 : (model1.getObject() == null ? 1 : (model2.getObject() == null ? -1 : ((Comparable)model1.getObject()).compareTo(model2.getObject())));
                result = ResourcesProvider.this.getSort().isAscending() ? result : -result;
                return result;
            }
        }
    }
}

