/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxPreprocessingCallDecorator;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.mod.AttributeMod;
import org.syncope.client.mod.RoleMod;
import org.syncope.client.to.AttributeTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.client.to.RoleTO;
import org.syncope.client.to.SchemaTO;
import org.syncope.console.SyncopeApplication;
import org.syncope.console.commons.SchemaWrapper;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.Roles;
import org.syncope.console.pages.SyncopeModalPage;
import org.syncope.console.rest.ResourcesRestClient;
import org.syncope.console.rest.RolesRestClient;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.syncope.console.wicket.markup.html.form.DateFieldPanel;

public class RoleModalPage
extends SyncopeModalPage {
    @SpringBean(name="rolesRestClient")
    RolesRestClient restClient;
    AjaxButton submit;
    WebMarkupContainer container;
    List<SchemaWrapper> schemaWrappers = new ArrayList<SchemaWrapper>();
    RoleTO oldRole;
    RoleMod roleMod;

    public RoleModalPage(final BasePage basePage, final ModalWindow window, RoleTO roleTO, final boolean createFlag) {
        if (!createFlag) {
            this.cloneOldRoleTO(roleTO);
        }
        final Form form = new Form("RoleForm");
        form.setModel((IModel)new CompoundPropertyModel((Object)roleTO));
        this.setupSchemaWrappers(createFlag, roleTO);
        ListView roleAttributesView = new ListView("roleSchemas", this.schemaWrappers){

            protected void populateItem(ListItem item) {
                final SchemaWrapper schemaWrapper = (SchemaWrapper)item.getDefaultModelObject();
                final SchemaTO schemaTO = schemaWrapper.getSchemaTO();
                item.add(new Component[]{new Label("name", schemaWrapper.getSchemaTO().getName())});
                item.add(new Component[]{new ListView("fields", schemaWrapper.getValues()){
                    Panel panel;

                    protected void populateItem(final ListItem item) {
                        String mandatoryCondition = schemaTO.getMandatoryCondition();
                        boolean required = false;
                        if (mandatoryCondition.equalsIgnoreCase("true")) {
                            required = true;
                        }
                        this.panel = schemaTO.getType().getClassName().equals("java.lang.Boolean") ? new AjaxCheckBoxPanel("panel", schemaTO.getName(), (IModel<Boolean>)new Model(){

                            public Serializable getObject() {
                                return (String)item.getModelObject();
                            }

                            public void setObject(Serializable object) {
                                Boolean val = (Boolean)object;
                                item.setModelObject((Object)val.toString());
                            }
                        }, required) : (schemaTO.getType().getClassName().equals("java.util.Date") ? new DateFieldPanel("panel", schemaTO.getName(), (IModel<Date>)new Model(){

                            public Serializable getObject() {
                                SimpleDateFormat formatter = new SimpleDateFormat(schemaTO.getConversionPattern());
                                Date date = new Date();
                                try {
                                    String dateValue = (String)item.getModelObject();
                                    date = !dateValue.equals("") ? formatter.parse(dateValue) : null;
                                }
                                catch (ParseException ex) {
                                    Logger.getLogger(RoleModalPage.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                return date;
                            }

                            public void setObject(Serializable object) {
                                Date date = (Date)object;
                                SimpleDateFormat formatter = new SimpleDateFormat(schemaTO.getConversionPattern());
                                String val = formatter.format((Object)date);
                                item.setModelObject((Object)val);
                            }
                        }, schemaTO.getConversionPattern(), required, schemaTO.isReadonly(), form) : new AjaxTextFieldPanel("panel", schemaTO.getName(), (IModel)new Model(){

                            public Serializable getObject() {
                                return (String)item.getModelObject();
                            }

                            public void setObject(Serializable object) {
                                item.setModelObject((Object)((String)((Object)object)));
                            }
                        }, required));
                        item.add(new Component[]{this.panel});
                    }
                }});
                AjaxButton addButton = new AjaxButton("add", (IModel)new Model((Serializable)((Object)this.getString("add")))){

                    protected void onSubmit(AjaxRequestTarget target, Form form) {
                        schemaWrapper.getValues().add("");
                        target.addComponent((Component)RoleModalPage.this.container);
                    }
                };
                AjaxButton dropButton = new AjaxButton("drop", (IModel)new Model((Serializable)((Object)this.getString("drop")))){

                    protected void onSubmit(AjaxRequestTarget target, Form form) {
                        schemaWrapper.getValues().remove(schemaWrapper.getValues().size() - 1);
                        target.addComponent((Component)RoleModalPage.this.container);
                    }

                    protected IAjaxCallDecorator getAjaxCallDecorator() {
                        return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){
                            private static final long serialVersionUID = 1L;

                            public CharSequence preDecorateScript(CharSequence script) {
                                return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "}";
                            }
                        };
                    }
                };
                if (schemaTO.getType().getClassName().equals("java.lang.Boolean")) {
                    addButton.setVisible(false);
                    dropButton.setVisible(false);
                }
                addButton.setDefaultFormProcessing(false);
                addButton.setVisible(schemaTO.isMultivalue());
                dropButton.setDefaultFormProcessing(false);
                dropButton.setVisible(schemaTO.isMultivalue());
                if (schemaWrapper.getValues().size() == 1) {
                    dropButton.setVisible(false);
                }
                item.add(new Component[]{addButton});
                item.add(new Component[]{dropButton});
            }
        };
        form.add(new Component[]{roleAttributesView});
        ListModel selectedResources = new ListModel();
        selectedResources.setObject(this.getSelectedResources(roleTO));
        ListModel availableResources = new ListModel();
        availableResources.setObject(this.getAvailableResources(roleTO));
        ChoiceRenderer paletteRenderer = new ChoiceRenderer("name", "name");
        final Palette resourcesPalette = new Palette("resourcesPalette", (IModel)selectedResources, (IModel)availableResources, (IChoiceRenderer)paletteRenderer, 8, false);
        form.add(new Component[]{resourcesPalette});
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{roleAttributesView});
        this.container.setOutputMarkupId(true);
        form.add(new Component[]{this.container});
        TextField name = new TextField("name");
        name.setRequired(true);
        this.container.add(new Component[]{name});
        this.submit = new AjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                RoleTO roleTO = (RoleTO)form.getDefaultModelObject();
                boolean res = false;
                try {
                    roleTO.setResources(RoleModalPage.this.getResourcesSet(resourcesPalette.getModelCollection()));
                    roleTO.setAttributes(RoleModalPage.this.getRoleAttributes());
                    if (createFlag) {
                        RoleModalPage.this.restClient.createRole(roleTO);
                        Roles callerPage = (Roles)basePage;
                        callerPage.setOperationResult(true);
                        window.close(target);
                    } else {
                        RoleModalPage.this.setupRoleMod(roleTO);
                        if (RoleModalPage.this.roleMod != null) {
                            res = RoleModalPage.this.restClient.updateRole(RoleModalPage.this.roleMod);
                            if (!res) {
                                this.error((Serializable)((Object)this.getString("error")));
                            } else {
                                Roles callerPage = (Roles)basePage;
                                callerPage.setOperationResult(true);
                            }
                        }
                        window.close(target);
                    }
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)(this.getString("error") + ":" + e.getMessage())));
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent(form.get("feedback"));
            }
        };
        form.add(new Component[]{this.submit});
        form.add(new Component[]{new FeedbackPanel("feedback").setOutputMarkupId(true)});
        this.add(new Component[]{form});
    }

    public Set<String> getResourcesSet(Collection<ResourceTO> resourcesList) {
        HashSet<String> resourcesSet = new HashSet<String>();
        for (ResourceTO resourceTO : resourcesList) {
            resourcesSet.add(resourceTO.getName());
        }
        return resourcesSet;
    }

    public List<ResourceTO> getSelectedResources(RoleTO roleTO) {
        ArrayList<ResourceTO> resources = new ArrayList<ResourceTO>();
        for (String resourceName : roleTO.getResources()) {
            ResourceTO clusterableResourceTO = new ResourceTO();
            clusterableResourceTO.setName(resourceName);
            resources.add(clusterableResourceTO);
        }
        return resources;
    }

    public List<ResourceTO> getAvailableResources(RoleTO roleTO) {
        ArrayList<ResourceTO> resources = new ArrayList<ResourceTO>();
        ResourcesRestClient resourcesRestClient = (ResourcesRestClient)((SyncopeApplication)Application.get()).getApplicationContext().getBean("resourcesRestClient");
        List<ResourceTO> resourcesTos = resourcesRestClient.getAllResources();
        for (ResourceTO resourceTO : resourcesTos) {
            resources.add(resourceTO);
        }
        return resources;
    }

    public void setupSchemaWrappers(boolean create, RoleTO roleTO) {
        this.schemaWrappers = new ArrayList<SchemaWrapper>();
        SchemaRestClient schemaRestClient = (SchemaRestClient)((SyncopeApplication)Application.get()).getApplicationContext().getBean("schemaRestClient");
        List<SchemaTO> schemas = schemaRestClient.getAllRoleSchemas();
        boolean found = false;
        if (create) {
            for (SchemaTO schema : schemas) {
                SchemaWrapper schemaWrapper = new SchemaWrapper(schema);
                this.schemaWrappers.add(schemaWrapper);
            }
        } else {
            for (SchemaTO schema : schemas) {
                SchemaWrapper schemaWrapper;
                for (AttributeTO attribute : roleTO.getAttributes()) {
                    if (!schema.getName().equals(attribute.getSchema())) continue;
                    schemaWrapper = new SchemaWrapper(schema);
                    schemaWrapper.setValues(attribute.getValues());
                    this.schemaWrappers.add(schemaWrapper);
                    found = true;
                }
                if (!found) {
                    schemaWrapper = new SchemaWrapper(schema);
                    this.schemaWrappers.add(schemaWrapper);
                    continue;
                }
                found = false;
            }
        }
    }

    public List<AttributeTO> getRoleAttributes() {
        ArrayList<AttributeTO> attributes = new ArrayList<AttributeTO>();
        for (SchemaWrapper schemaWrapper : this.schemaWrappers) {
            AttributeTO attribute = new AttributeTO();
            attribute.setSchema(schemaWrapper.getSchemaTO().getName());
            attribute.setValues(new ArrayList());
            for (String value : schemaWrapper.getValues()) {
                attribute.getValues().add(value);
            }
            attributes.add(attribute);
        }
        return attributes;
    }

    public Set<String> getResourcesSet(List<String> resourcesList) {
        HashSet<String> resourcesSet = new HashSet<String>();
        for (String resource : resourcesList) {
            resourcesSet.add(resource);
        }
        return resourcesSet;
    }

    public void cloneOldRoleTO(RoleTO roleTO) {
        this.oldRole = new RoleTO();
        this.oldRole.setId(roleTO.getId());
        this.oldRole.setName(new String(roleTO.getName()));
        this.oldRole.setParent(new Long(roleTO.getParent()).longValue());
        ArrayList<AttributeTO> attributes = new ArrayList<AttributeTO>();
        for (AttributeTO attribute : roleTO.getAttributes()) {
            AttributeTO attributeTO = new AttributeTO();
            attributeTO.setSchema(new String(attribute.getSchema()));
            ArrayList<String> values = new ArrayList<String>();
            for (String val : attribute.getValues()) {
                values.add(val);
            }
            attributeTO.setValues(values);
            attributes.add(attributeTO);
        }
        this.oldRole.setAttributes(attributes);
        this.oldRole.setResources(roleTO.getResources());
    }

    public void setupRoleMod(RoleTO roleTO) {
        if (!this.oldRole.getName().equals(roleTO.getName())) {
            this.roleMod = new RoleMod();
            this.roleMod.setName(roleTO.getName());
        }
        for (AttributeTO attributeTO : roleTO.getAttributes()) {
            this.searchAndUpdateAttribute(attributeTO);
        }
        for (String resource : roleTO.getResources()) {
            this.searchAndAddResource(resource);
        }
        for (String resource : this.oldRole.getResources()) {
            this.searchAndDropResource(resource, roleTO);
        }
        if (this.roleMod != null) {
            this.roleMod.setId(this.oldRole.getId());
        }
    }

    public void searchAndAddResource(String resource) {
        boolean found = false;
        for (String oldResource : this.oldRole.getResources()) {
            if (!resource.equals(oldResource)) continue;
            found = true;
        }
        if (!found) {
            if (this.roleMod == null) {
                this.roleMod = new RoleMod();
            }
            this.roleMod.addResourceToBeAdded(resource);
        }
    }

    public void searchAndDropResource(String resource, RoleTO roleTO) {
        boolean found = false;
        for (String newResource : roleTO.getResources()) {
            if (!resource.equals(newResource)) continue;
            found = true;
        }
        if (!found) {
            if (this.roleMod == null) {
                this.roleMod = new RoleMod();
            }
            this.roleMod.addResourceToBeRemoved(resource);
        }
    }

    public void searchAndUpdateAttribute(AttributeTO attributeTO) {
        boolean found = false;
        boolean changed = false;
        AttributeMod attributeMod = new AttributeMod();
        attributeMod.setSchema(attributeTO.getSchema());
        for (AttributeTO oldAttribute : this.oldRole.getAttributes()) {
            if (!attributeTO.getSchema().equals(oldAttribute.getSchema()) || !attributeTO.getSchema().equals(oldAttribute.getSchema())) continue;
            if (!attributeTO.equals((Object)oldAttribute) && !oldAttribute.isReadonly()) {
                if (attributeTO.getValues().size() > 1) {
                    attributeMod.setValuesToBeAdded(attributeTO.getValues());
                } else {
                    attributeMod.addValueToBeAdded((String)attributeTO.getValues().iterator().next());
                }
                if (this.roleMod == null) {
                    this.roleMod = new RoleMod();
                }
                this.roleMod.addAttributeToBeRemoved(oldAttribute.getSchema());
                this.roleMod.addAttributeToBeUpdated(attributeMod);
                changed = true;
                break;
            }
            found = true;
        }
        if (!(found || changed || attributeTO.isReadonly() || attributeTO.getValues() == null)) {
            if (attributeTO.getValues().iterator().next() != null) {
                attributeMod.setValuesToBeAdded(attributeTO.getValues());
                if (this.roleMod == null) {
                    this.roleMod = new RoleMod();
                }
                this.roleMod.addAttributeToBeUpdated(attributeMod);
            } else {
                attributeMod = null;
            }
        }
    }
}

