/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxPreprocessingCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.list.PageableListView;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.springframework.web.client.HttpServerErrorException;
import org.syncope.client.search.AttributeCond;
import org.syncope.client.search.MembershipCond;
import org.syncope.client.search.NodeCond;
import org.syncope.client.to.AttributeTO;
import org.syncope.client.to.ConfigurationTO;
import org.syncope.client.to.RoleTO;
import org.syncope.client.to.UserTO;
import org.syncope.console.commons.SearchConditionWrapper;
import org.syncope.console.commons.Utility;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.DisplayAttributesModalPage;
import org.syncope.console.pages.UserModalPage;
import org.syncope.console.rest.ConfigurationsRestClient;
import org.syncope.console.rest.RolesRestClient;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.rest.UsersRestClient;
import org.syncope.console.wicket.markup.html.form.UpdatingCheckBox;
import org.syncope.console.wicket.markup.html.form.UpdatingDropDownChoice;
import org.syncope.console.wicket.markup.html.form.UpdatingTextField;

public class Users
extends BasePage {
    @SpringBean(name="usersRestClient")
    private UsersRestClient usersRestClient;
    @SpringBean(name="schemaRestClient")
    private SchemaRestClient schemaRestClient;
    @SpringBean(name="rolesRestClient")
    private RolesRestClient rolesRestClient;
    @SpringBean(name="configurationsRestClient")
    private ConfigurationsRestClient configurationsRestClient;
    @SpringBean(name="utility")
    Utility utility;
    final ModalWindow createUserWin;
    final ModalWindow editUserWin;
    final ModalWindow changeAttribsViewWin;
    final int WIN_ATTRIBUTES_HEIGHT = 515;
    final int WIN_ATTRIBUTES_WIDTH = 775;
    final int WIN_USER_HEIGHT = 680;
    final int WIN_USER_WIDTH = 1133;
    WebMarkupContainer usersTableSearchContainer;
    WebMarkupContainer usersTableContainer;
    boolean operationResult = false;
    FeedbackPanel feedbackPanel;
    List<SearchConditionWrapper> searchConditionsList;
    List<UserTO> searchMatchedUsers;
    private int paginatorRows;
    private int paginatorSearchRows;
    int currentViewPage = 1;
    int currentSearchPage = 1;
    AjaxLink incrementUserViewLink;
    AjaxLink decrementUserViewLink;
    Label currentPageUserViewLabel;
    AjaxLink incrementUserSearchLink;
    AjaxLink decrementUserSearchLink;
    Label currentPageUserSearchLabel;
    List<String> columnsList;
    NodeCond nodeCond;

    public Users(PageParameters parameters) {
        super(parameters);
        this.setupSearchConditionsList();
        this.searchMatchedUsers = new ArrayList<UserTO>();
        Component[] componentArray = new Component[1];
        this.createUserWin = new ModalWindow("createUserWin");
        componentArray[0] = this.createUserWin;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.editUserWin = new ModalWindow("editUserWin");
        componentArray2[0] = this.editUserWin;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.changeAttribsViewWin = new ModalWindow("changeAttributesViewWin");
        componentArray3[0] = this.changeAttribsViewWin;
        this.add(componentArray3);
        this.feedbackPanel = new FeedbackPanel("feedback");
        this.feedbackPanel.setOutputMarkupId(true);
        this.add(new Component[]{this.feedbackPanel});
        LoadableDetachableModel columns = new LoadableDetachableModel(){

            protected Object load() {
                ConfigurationTO configuration = Users.this.configurationsRestClient.readConfiguration("users.attributes.view");
                Users.this.columnsList = new ArrayList<String>();
                if (configuration != null && !configuration.getConfValue().equals("")) {
                    String conf = configuration.getConfValue();
                    StringTokenizer st = new StringTokenizer(conf, ";");
                    while (st.hasMoreTokens()) {
                        Users.this.columnsList.add(st.nextToken());
                    }
                }
                Collections.sort(Users.this.columnsList);
                return Users.this.columnsList;
            }
        };
        ListView columnsView = new ListView("usersSchema", (IModel)columns){

            protected void populateItem(ListItem item) {
                String name = (String)item.getDefaultModelObject();
                item.add(new Component[]{new Label("attribute", name)});
            }
        };
        this.paginatorRows = this.utility.getPaginatorRowsToDisplay("users.paginator.rows");
        this.paginatorSearchRows = this.utility.getPaginatorRowsToDisplay("users.paginator.search.rows");
        LoadableDetachableModel usersModel = new LoadableDetachableModel(){

            protected Object load() {
                List<UserTO> list = Users.this.usersRestClient.getPaginatedUsersList(Users.this.currentViewPage, Users.this.paginatorRows);
                List<UserTO> nextList = Users.this.usersRestClient.getPaginatedUsersList(Users.this.currentViewPage + 1, Users.this.paginatorRows);
                if (nextList.size() == 0) {
                    Users.this.incrementUserViewLink.setVisible(false);
                } else {
                    Users.this.incrementUserViewLink.setVisible(true);
                }
                if (Users.this.currentViewPage <= 1) {
                    Users.this.decrementUserViewLink.setVisible(false);
                } else {
                    Users.this.decrementUserViewLink.setVisible(true);
                }
                return list;
            }
        };
        this.usersTableContainer = new WebMarkupContainer("usersTableContainer");
        final PageableListView usersView = new PageableListView("results", (IModel)usersModel, this.paginatorRows){

            protected void populateItem(final ListItem item) {
                final UserTO userTO = (UserTO)item.getModelObject();
                item.add(new Component[]{new Label("id", String.valueOf(userTO.getId()))});
                item.add(new Component[]{new Label("status", String.valueOf(userTO.getStatus()))});
                if (userTO.getToken() != null && !userTO.getToken().equals("")) {
                    item.add(new Component[]{new Label("token", this.getString("tokenValued"))});
                } else {
                    item.add(new Component[]{new Label("token", this.getString("tokenNotValued"))});
                }
                item.add(new Component[]{new ListView("selectedAttributes", Users.this.attributesToDisplay(userTO)){

                    protected void populateItem(ListItem item) {
                        AttributeWrapper attribute = (AttributeWrapper)item.getDefaultModelObject();
                        for (String name : Users.this.columnsList) {
                            if (name.equalsIgnoreCase(attribute.getKey())) {
                                item.add(new Component[]{new Label("name", attribute.getValue())});
                                continue;
                            }
                            if (name.equalsIgnoreCase(attribute.getKey())) continue;
                        }
                    }
                }});
                AjaxLink editLink = new AjaxLink("editLink", (IModel)new Model((Serializable)((Object)this.getString("edit")))){

                    public void onClick(AjaxRequestTarget target) {
                        final UserTO userTO = (UserTO)item.getDefaultModelObject();
                        Users.this.editUserWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                UserModalPage window = new UserModalPage(Users.this, Users.this.editUserWin, userTO, false);
                                return window;
                            }
                        });
                        Users.this.editUserWin.show(target);
                    }
                };
                item.add(new Component[]{editLink});
                item.add(new Component[]{new AjaxLink("deleteLink", (IModel)new Model((Serializable)((Object)this.getString("delete")))){

                    public void onClick(AjaxRequestTarget target) {
                        Users.this.usersRestClient.deleteUser(String.valueOf(userTO.getId()));
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Users.this.feedbackPanel);
                        target.addComponent((Component)Users.this.usersTableSearchContainer);
                    }

                    protected IAjaxCallDecorator getAjaxCallDecorator() {
                        return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){
                            private static final long serialVersionUID = 1L;

                            public CharSequence preDecorateScript(CharSequence script) {
                                return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "}";
                            }
                        };
                    }
                }});
            }
        };
        this.usersTableContainer.add(new Component[]{usersView});
        this.usersTableContainer.setOutputMarkupId(true);
        this.currentPageUserViewLabel = new Label("currentPageLabel", (IModel)new Model((Serializable)((Object)String.valueOf(this.currentViewPage))));
        this.incrementUserViewLink = new AjaxLink("incrementLink"){

            public void onClick(AjaxRequestTarget target) {
                ++Users.this.currentViewPage;
                Users.this.currentPageUserViewLabel.setDefaultModelObject((Object)String.valueOf(Users.this.currentViewPage));
                target.addComponent((Component)Users.this.usersTableContainer);
            }
        };
        this.decrementUserViewLink = new AjaxLink("decrementLink"){

            public void onClick(AjaxRequestTarget target) {
                --Users.this.currentViewPage;
                Users.this.currentPageUserViewLabel.setDefaultModelObject((Object)String.valueOf(Users.this.currentViewPage));
                target.addComponent((Component)Users.this.usersTableContainer);
            }
        };
        this.usersTableContainer.add(new Component[]{this.incrementUserViewLink});
        this.usersTableContainer.add(new Component[]{this.currentPageUserViewLabel});
        this.usersTableContainer.add(new Component[]{this.decrementUserViewLink});
        this.usersTableContainer.add(new Component[]{columnsView});
        this.add(new Component[]{this.usersTableContainer});
        this.createUserWin.setCssClassName("w_silver");
        this.createUserWin.setInitialHeight(680);
        this.createUserWin.setInitialWidth(1133);
        this.createUserWin.setPageMapName("create-user-modal");
        this.createUserWin.setCookieName("create-user-modal");
        this.editUserWin.setCssClassName("w_silver");
        this.editUserWin.setInitialHeight(680);
        this.editUserWin.setInitialWidth(680);
        this.editUserWin.setPageMapName("edit-user-modal");
        this.editUserWin.setCookieName("edit-user-modal");
        this.changeAttribsViewWin.setCssClassName("w_silver");
        this.changeAttribsViewWin.setInitialHeight(515);
        this.changeAttribsViewWin.setInitialWidth(775);
        this.changeAttribsViewWin.setPageMapName("change-attribs-modal");
        this.changeAttribsViewWin.setCookieName("change-attribs-modal");
        this.setWindowClosedCallback(this.createUserWin, this.usersTableSearchContainer);
        this.setWindowClosedCallback(this.editUserWin, this.usersTableSearchContainer);
        this.changeAttribsViewWin.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                if (Users.this.operationResult) {
                    Users.this.getSession().info(Users.this.getString("operation_succeded"));
                    Users.this.setResponsePage(Users.class);
                } else {
                    target.addComponent((Component)Users.this.feedbackPanel);
                }
            }
        });
        this.add(new Component[]{new AjaxLink("createUserLink"){

            public void onClick(AjaxRequestTarget target) {
                Users.this.createUserWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        UserModalPage window = new UserModalPage(Users.this, Users.this.createUserWin, new UserTO(), true);
                        return window;
                    }
                });
                Users.this.createUserWin.show(target);
            }
        }});
        Form paginatorForm = new Form("PaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.utility.paginatorRowsChooser());
        rowsChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Users.this.utility.updatePaginatorRows("users.paginator.rows", Users.this.paginatorRows);
                usersView.setRowsPerPage(Users.this.paginatorRows);
                target.addComponent((Component)Users.this.usersTableContainer);
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
        this.add(new Component[]{new AjaxLink("changeAttributesViewLink"){

            public void onClick(AjaxRequestTarget target) {
                Users.this.changeAttribsViewWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        DisplayAttributesModalPage window = new DisplayAttributesModalPage(Users.this, Users.this.changeAttribsViewWin, true);
                        return window;
                    }
                });
                Users.this.changeAttribsViewWin.show(target);
            }
        }});
        LoadableDetachableModel userAttributes = new LoadableDetachableModel(){

            protected Object load() {
                return Users.this.schemaRestClient.getAllUserSchemasNames();
            }
        };
        LoadableDetachableModel roleNames = new LoadableDetachableModel(){

            protected Object load() {
                List<RoleTO> roleTOs = Users.this.rolesRestClient.getAllRoles();
                ArrayList<String> roleNames = new ArrayList<String>();
                for (RoleTO role : roleTOs) {
                    roleNames.add(role.getName());
                }
                return roleNames;
            }
        };
        LoadableDetachableModel attributeTypes = new LoadableDetachableModel(){

            protected Object load() {
                return Arrays.asList(AttributeCond.Type.values());
            }
        };
        LoadableDetachableModel filterTypes = new LoadableDetachableModel(){

            protected Object load() {
                return Arrays.asList(SearchConditionWrapper.FilterType.values());
            }
        };
        Form form = new Form("UserSearchForm");
        form.add(new Component[]{new FeedbackPanel("feedback").setOutputMarkupId(true)});
        this.usersTableSearchContainer = new WebMarkupContainer("container");
        this.usersTableSearchContainer.setOutputMarkupId(true);
        ListView searchView = new ListView("searchView", this.searchConditionsList, (IModel)userAttributes, (IModel)roleNames, (IModel)attributeTypes, (IModel)filterTypes){
            final /* synthetic */ IModel val$userAttributes;
            final /* synthetic */ IModel val$roleNames;
            final /* synthetic */ IModel val$attributeTypes;
            final /* synthetic */ IModel val$filterTypes;
            {
                this.val$userAttributes = iModel;
                this.val$roleNames = iModel2;
                this.val$attributeTypes = iModel3;
                this.val$filterTypes = iModel4;
                super(x0, x1);
            }

            protected void populateItem(ListItem item) {
                final SearchConditionWrapper searchCondition = (SearchConditionWrapper)item.getDefaultModelObject();
                if (item.getIndex() == 0) {
                    item.add(new Component[]{new Label("operationType", "")});
                } else {
                    item.add(new Component[]{new Label("operationType", searchCondition.getOperationType().toString())});
                }
                item.add(new Component[]{new UpdatingCheckBox("notOperator", (IModel<Boolean>)new PropertyModel((Object)searchCondition, "notOperator"))});
                final UpdatingDropDownChoice filterNameChooser = new UpdatingDropDownChoice("filterName", new PropertyModel((Object)searchCondition, "filterName"), null);
                if (searchCondition.getFilterType() == null) {
                    filterNameChooser.setChoices(Collections.emptyList());
                } else if (searchCondition.getFilterType() == SearchConditionWrapper.FilterType.ATTRIBUTE) {
                    filterNameChooser.setChoices(this.val$userAttributes);
                } else {
                    filterNameChooser.setChoices(this.val$roleNames);
                }
                filterNameChooser.setRequired(true);
                item.add(new Component[]{filterNameChooser});
                UpdatingDropDownChoice type = new UpdatingDropDownChoice("type", new PropertyModel((Object)searchCondition, "type"), this.val$attributeTypes);
                item.add(new Component[]{type});
                UpdatingTextField filterValue = new UpdatingTextField("filterValue", (IModel)new PropertyModel((Object)searchCondition, "filterValue"));
                item.add(new Component[]{filterValue});
                if (searchCondition.getFilterType() == SearchConditionWrapper.FilterType.MEMBERSHIP) {
                    type.setEnabled(false);
                    type.setRequired(false);
                    type.setModelObject(null);
                    filterValue.setEnabled(false);
                    filterValue.setModelObject("");
                } else {
                    if (!type.isEnabled()) {
                        type.setEnabled(true);
                        type.setRequired(true);
                    }
                    if (!filterValue.isEnabled()) {
                        filterValue.setEnabled(true);
                    }
                }
                UpdatingDropDownChoice filterTypeChooser = new UpdatingDropDownChoice("filterType", new PropertyModel((Object)searchCondition, "filterType"), this.val$filterTypes);
                filterTypeChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

                    protected void onUpdate(AjaxRequestTarget target) {
                        filterNameChooser.setChoices((IModel)new LoadableDetachableModel(){

                            protected Object load() {
                                SearchConditionWrapper.FilterType schemaType = searchCondition.getFilterType();
                                if (schemaType == SearchConditionWrapper.FilterType.ATTRIBUTE) {
                                    return val$userAttributes;
                                }
                                return val$roleNames;
                            }
                        });
                        target.addComponent((Component)filterNameChooser);
                        target.addComponent((Component)Users.this.usersTableSearchContainer);
                    }
                }});
                filterTypeChooser.setRequired(true);
                item.add(new Component[]{filterTypeChooser});
                AjaxButton dropButton = new AjaxButton("dropButton", (IModel)new Model((Serializable)((Object)this.getString("dropButton")))){

                    protected void onSubmit(AjaxRequestTarget target, Form form) {
                        int parentId = new Integer(this.getParent().getId());
                        Users.this.searchConditionsList.remove(parentId);
                        target.addComponent((Component)Users.this.usersTableSearchContainer);
                    }
                };
                dropButton.setDefaultFormProcessing(false);
                if (item.getIndex() == 0) {
                    dropButton.setVisible(false);
                }
                item.add(new Component[]{dropButton});
            }
        };
        this.usersTableSearchContainer.add(new Component[]{searchView});
        AjaxButton addAndButton = new AjaxButton("addAndButton", (IModel)new Model((Serializable)((Object)this.getString("addAndButton")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                SearchConditionWrapper conditionWrapper = new SearchConditionWrapper();
                conditionWrapper.setOperationType(SearchConditionWrapper.OperationType.AND);
                Users.this.searchConditionsList.add(conditionWrapper);
                target.addComponent((Component)Users.this.usersTableSearchContainer);
            }
        };
        addAndButton.setDefaultFormProcessing(false);
        this.usersTableSearchContainer.add(new Component[]{addAndButton});
        AjaxButton addOrButton = new AjaxButton("addOrButton", (IModel)new Model((Serializable)((Object)this.getString("addOrButton")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                SearchConditionWrapper conditionWrapper = new SearchConditionWrapper();
                conditionWrapper.setOperationType(SearchConditionWrapper.OperationType.OR);
                Users.this.searchConditionsList.add(conditionWrapper);
                target.addComponent((Component)Users.this.usersTableSearchContainer);
            }
        };
        addOrButton.setDefaultFormProcessing(false);
        this.usersTableSearchContainer.add(new Component[]{addOrButton});
        form.add(new Component[]{this.usersTableSearchContainer});
        this.currentPageUserSearchLabel = new Label("currentSearchPage", (IModel)new Model((Serializable)((Object)String.valueOf(this.currentSearchPage))));
        LoadableDetachableModel resultsModel = new LoadableDetachableModel(){

            protected Object load() {
                if (Users.this.nodeCond != null) {
                    Users.this.searchMatchedUsers = Users.this.usersRestClient.paginatedSearchUsers(Users.this.nodeCond, Users.this.currentSearchPage, Users.this.paginatorSearchRows);
                    List<UserTO> nextList = Users.this.usersRestClient.paginatedSearchUsers(Users.this.nodeCond, Users.this.currentSearchPage + 1, Users.this.paginatorSearchRows);
                    if (nextList.size() == 0) {
                        Users.this.incrementUserSearchLink.setVisible(false);
                    } else {
                        Users.this.incrementUserSearchLink.setVisible(true);
                    }
                    if (Users.this.currentSearchPage <= 1) {
                        Users.this.decrementUserSearchLink.setVisible(false);
                    } else {
                        Users.this.decrementUserSearchLink.setVisible(true);
                    }
                    Users.this.currentPageUserSearchLabel.setVisible(true);
                } else {
                    Users.this.currentPageUserSearchLabel.setVisible(false);
                    Users.this.incrementUserSearchLink.setVisible(false);
                    Users.this.decrementUserSearchLink.setVisible(false);
                }
                return Users.this.searchMatchedUsers;
            }
        };
        final PageableListView resultsView = new PageableListView("results", (IModel)resultsModel, this.paginatorSearchRows){

            protected void populateItem(ListItem item) {
                final UserTO userTO = (UserTO)item.getModelObject();
                item.add(new Component[]{new Label("id", String.valueOf(userTO.getId()))});
                item.add(new Component[]{new Label("status", String.valueOf(userTO.getStatus()))});
                if (userTO.getToken() != null && !userTO.getToken().equals("")) {
                    item.add(new Component[]{new Label("token", this.getString("tokenValued"))});
                } else {
                    item.add(new Component[]{new Label("token", this.getString("tokenNotValued"))});
                }
                AjaxButton editButton = new AjaxButton("editLink", (IModel)new Model((Serializable)((Object)this.getString("edit")))){

                    protected void onSubmit(AjaxRequestTarget target, Form form) {
                        Users.this.editUserWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                UserModalPage window = new UserModalPage(Users.this, Users.this.editUserWin, userTO, false);
                                return window;
                            }
                        });
                        Users.this.editUserWin.show(target);
                    }
                };
                item.add(new Component[]{editButton});
                item.add(new Component[]{new AjaxLink("deleteLink", (IModel)new Model((Serializable)((Object)this.getString("delete")))){

                    public void onClick(AjaxRequestTarget target) {
                        Users.this.usersRestClient.deleteUser(String.valueOf(userTO.getId()));
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Users.this.feedbackPanel);
                        target.addComponent((Component)Users.this.usersTableContainer);
                    }
                }});
            }
        };
        final WebMarkupContainer searchResultsContainer = new WebMarkupContainer("searchResultsContainer");
        searchResultsContainer.setOutputMarkupId(true);
        searchResultsContainer.add(new Component[]{resultsView});
        this.incrementUserSearchLink = new AjaxLink("incrementLink"){

            public void onClick(AjaxRequestTarget target) {
                ++Users.this.currentSearchPage;
                Users.this.currentPageUserSearchLabel.setDefaultModelObject((Object)String.valueOf(Users.this.currentSearchPage));
                target.addComponent((Component)searchResultsContainer);
            }
        };
        this.decrementUserSearchLink = new AjaxLink("decrementLink"){

            public void onClick(AjaxRequestTarget target) {
                --Users.this.currentSearchPage;
                Users.this.currentPageUserSearchLabel.setDefaultModelObject((Object)String.valueOf(Users.this.currentSearchPage));
                target.addComponent((Component)searchResultsContainer);
            }
        };
        searchResultsContainer.add(new Component[]{this.incrementUserSearchLink});
        searchResultsContainer.add(new Component[]{this.currentPageUserSearchLabel});
        searchResultsContainer.add(new Component[]{this.decrementUserSearchLink});
        final Label noResults = new Label("noResults", (IModel)new Model((Serializable)((Object)"")));
        noResults.setOutputMarkupId(true);
        searchResultsContainer.add(new Component[]{noResults});
        this.setWindowClosedCallback(this.editUserWin, searchResultsContainer);
        form.add(new Component[]{new AjaxButton("search", (IModel)new Model((Serializable)((Object)this.getString("search")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                Users.this.nodeCond = Users.this.buildSearchExpression(Users.this.searchConditionsList);
                if (Users.this.nodeCond != null) {
                    try {
                        Users.this.currentViewPage = 1;
                        Users.this.searchMatchedUsers = Users.this.usersRestClient.paginatedSearchUsers(Users.this.nodeCond, 1, Users.this.paginatorSearchRows);
                        target.addComponent(form.get("feedback"));
                    }
                    catch (HttpServerErrorException e) {
                        e.printStackTrace();
                        this.error((Serializable)((Object)e.getMessage()));
                        return;
                    }
                } else {
                    this.error((Serializable)((Object)this.getString("search_error")));
                }
                if (Users.this.searchMatchedUsers.isEmpty()) {
                    noResults.setDefaultModel((IModel)new Model((Serializable)((Object)this.getString("search_noResults"))));
                } else {
                    noResults.setDefaultModel((IModel)new Model((Serializable)((Object)"")));
                }
                target.addComponent((Component)searchResultsContainer);
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent(form.get("feedback"));
            }
        }});
        this.add(new Component[]{form});
        form.add(new Component[]{searchResultsContainer});
        Form paginatorSearchForm = new Form("PaginatorSearchForm");
        DropDownChoice rowsSearchChooser = new DropDownChoice("rowsSearchChooser", (IModel)new PropertyModel((Object)this, "paginatorSearchRows"), this.utility.paginatorRowsChooser());
        rowsSearchChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Users.this.utility.updatePaginatorRows("users.paginator.search.rows", Users.this.paginatorSearchRows);
                resultsView.setRowsPerPage(Users.this.paginatorSearchRows);
                target.addComponent((Component)searchResultsContainer);
            }
        }});
        paginatorSearchForm.add(new Component[]{rowsSearchChooser});
        this.add(new Component[]{paginatorSearchForm});
    }

    public List<AttributeWrapper> attributesToDisplay(UserTO user) {
        List attributes = user.getAttributes();
        ArrayList<AttributeWrapper> attributesList = new ArrayList<AttributeWrapper>();
        ConfigurationTO configuration = this.configurationsRestClient.readConfiguration("users.attributes.view");
        this.columnsList = new ArrayList<String>();
        if (configuration != null && !configuration.getConfValue().equals("")) {
            String conf = configuration.getConfValue();
            StringTokenizer st = new StringTokenizer(conf, ";");
            while (st.hasMoreTokens()) {
                this.columnsList.add(st.nextToken());
            }
        }
        Collections.sort(this.columnsList);
        AttributeWrapper attributeWrapper = null;
        boolean found = false;
        for (String name : this.columnsList) {
            for (AttributeTO attribute : attributes) {
                if (!name.equals(attribute.getSchema()) || found) continue;
                attributeWrapper = new AttributeWrapper();
                attributeWrapper.setKey(attribute.getSchema());
                for (String value : attribute.getValues()) {
                    attributeWrapper.setValue(value);
                    found = true;
                }
                attributesList.add(attributeWrapper);
            }
            if (!found) {
                attributeWrapper = new AttributeWrapper();
                attributeWrapper.setKey(name);
                attributeWrapper.setValue("");
                attributesList.add(attributeWrapper);
                continue;
            }
            found = false;
        }
        return attributesList;
    }

    public void setWindowClosedCallback(ModalWindow window, final WebMarkupContainer container) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                target.addComponent((Component)container);
                if (Users.this.operationResult) {
                    Users.this.info(Users.this.getString("operation_succeded"));
                    target.addComponent((Component)Users.this.feedbackPanel);
                    Users.this.operationResult = false;
                } else {
                    target.addComponent((Component)Users.this.feedbackPanel);
                }
            }
        });
    }

    public boolean isOperationResult() {
        return this.operationResult;
    }

    public void setOperationResult(boolean operationResult) {
        this.operationResult = operationResult;
    }

    private void setupSearchConditionsList() {
        this.searchConditionsList = new ArrayList<SearchConditionWrapper>();
        this.searchConditionsList.add(new SearchConditionWrapper());
    }

    public NodeCond buildSearchExpression(List<SearchConditionWrapper> conditions) {
        AttributeCond attributeCond = null;
        MembershipCond membershipCond = null;
        List<SearchConditionWrapper> subList = null;
        SearchConditionWrapper searchConditionWrapper = conditions.iterator().next();
        if (searchConditionWrapper.getFilterType() == SearchConditionWrapper.FilterType.ATTRIBUTE) {
            attributeCond = new AttributeCond();
            attributeCond.setSchema(searchConditionWrapper.getFilterName());
            attributeCond.setType(searchConditionWrapper.getType());
            attributeCond.setExpression(searchConditionWrapper.getFilterValue());
        } else {
            membershipCond = new MembershipCond();
            membershipCond.setRoleName(searchConditionWrapper.getFilterName());
        }
        if (conditions.size() == 1) {
            if (searchConditionWrapper.getFilterType() == SearchConditionWrapper.FilterType.ATTRIBUTE) {
                if (searchConditionWrapper.isNotOperator()) {
                    return NodeCond.getNotLeafCond((AttributeCond)attributeCond);
                }
                return NodeCond.getLeafCond((AttributeCond)attributeCond);
            }
            if (searchConditionWrapper.isNotOperator()) {
                return NodeCond.getNotLeafCond((MembershipCond)membershipCond);
            }
            return NodeCond.getLeafCond((MembershipCond)membershipCond);
        }
        subList = conditions.subList(1, conditions.size());
        searchConditionWrapper = subList.iterator().next();
        if (searchConditionWrapper.getOperationType() == SearchConditionWrapper.OperationType.AND) {
            if (searchConditionWrapper.getFilterType() == SearchConditionWrapper.FilterType.ATTRIBUTE) {
                if (attributeCond != null) {
                    return NodeCond.getAndCond((NodeCond)NodeCond.getLeafCond((AttributeCond)attributeCond), (NodeCond)this.buildSearchExpression(new ArrayList<SearchConditionWrapper>(subList)));
                }
                return NodeCond.getAndCond((NodeCond)NodeCond.getLeafCond((MembershipCond)membershipCond), (NodeCond)this.buildSearchExpression(new ArrayList<SearchConditionWrapper>(subList)));
            }
            if (attributeCond != null) {
                return NodeCond.getAndCond((NodeCond)NodeCond.getLeafCond((AttributeCond)attributeCond), (NodeCond)this.buildSearchExpression(new ArrayList<SearchConditionWrapper>(subList)));
            }
            return NodeCond.getAndCond((NodeCond)NodeCond.getLeafCond((MembershipCond)membershipCond), (NodeCond)this.buildSearchExpression(new ArrayList<SearchConditionWrapper>(subList)));
        }
        if (searchConditionWrapper.getFilterType() == SearchConditionWrapper.FilterType.ATTRIBUTE) {
            if (attributeCond != null) {
                return NodeCond.getOrCond((NodeCond)NodeCond.getLeafCond((AttributeCond)attributeCond), (NodeCond)this.buildSearchExpression(new ArrayList<SearchConditionWrapper>(subList)));
            }
            return NodeCond.getOrCond((NodeCond)NodeCond.getLeafCond((MembershipCond)membershipCond), (NodeCond)this.buildSearchExpression(new ArrayList<SearchConditionWrapper>(subList)));
        }
        if (attributeCond != null) {
            return NodeCond.getOrCond((NodeCond)NodeCond.getLeafCond((AttributeCond)attributeCond), (NodeCond)this.buildSearchExpression(new ArrayList<SearchConditionWrapper>(subList)));
        }
        return NodeCond.getOrCond((NodeCond)NodeCond.getLeafCond((MembershipCond)membershipCond), (NodeCond)this.buildSearchExpression(new ArrayList<SearchConditionWrapper>(subList)));
    }

    public class AttributeWrapper
    implements Serializable {
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

