/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.rest;

import java.util.Arrays;
import java.util.List;
import org.springframework.web.client.HttpServerErrorException;
import org.syncope.client.mod.UserMod;
import org.syncope.client.search.NodeCond;
import org.syncope.client.to.ConfigurationTO;
import org.syncope.client.to.UserTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.rest.RestClient;

public class UsersRestClient {
    protected RestClient restClient;

    public List<UserTO> getAllUsers() {
        List<Object> users = null;
        try {
            users = Arrays.asList((Object[])this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "user/list.json", UserTO[].class, new Object[0]));
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
        return users;
    }

    public List<UserTO> getPaginatedUsersList(int page, int size) {
        List<Object> users = null;
        try {
            users = Arrays.asList((Object[])this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "user/paginatedList/{page}/{size}", UserTO[].class, new Object[]{page, size}));
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
        return users;
    }

    public void createUser(UserTO userTO) throws SyncopeClientCompositeErrorException {
        UserTO newUserTO = (UserTO)this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "user/create", (Object)userTO, UserTO.class, new Object[0]);
    }

    public boolean updateUser(UserMod userModTO) throws SyncopeClientCompositeErrorException {
        UserTO newUserTO = null;
        newUserTO = (UserTO)this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "user/update", (Object)userModTO, UserTO.class, new Object[0]);
        return userModTO.getId() == newUserTO.getId();
    }

    public void deleteUser(String id) {
        try {
            this.restClient.getRestTemplate().delete(this.restClient.getBaseURL() + "user/delete/{userId}", new Object[]{new Integer(id)});
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
    }

    public UserTO getUser(String id) {
        UserTO userTO = null;
        try {
            userTO = (UserTO)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "user/read/{userId}.json", UserTO.class, new Object[]{id});
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
        }
        return userTO;
    }

    public boolean createConfigurationAttributes(ConfigurationTO configurationTO) {
        ConfigurationTO newConfigurationTO = (ConfigurationTO)this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "configuration/create", (Object)configurationTO, ConfigurationTO.class, new Object[0]);
        return configurationTO.equals((Object)newConfigurationTO);
    }

    public boolean updateConfigurationAttributes(ConfigurationTO configurationTO) {
        ConfigurationTO newConfigurationTO = (ConfigurationTO)this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "configuration/update", (Object)configurationTO, ConfigurationTO.class, new Object[0]);
        return configurationTO.equals((Object)newConfigurationTO);
    }

    public ConfigurationTO readConfigurationDisplayAttributes() {
        ConfigurationTO configurationTO;
        try {
            configurationTO = (ConfigurationTO)this.restClient.getRestTemplate().getForObject(this.restClient.getBaseURL() + "configuration/read/{confKey}", ConfigurationTO.class, new Object[]{"users.attributes.view"});
        }
        catch (SyncopeClientCompositeErrorException e) {
            e.printStackTrace();
            return null;
        }
        return configurationTO;
    }

    public List<UserTO> searchUsers(NodeCond nodeSearchCondition) throws HttpServerErrorException {
        List<Object> matchedUsers = null;
        matchedUsers = Arrays.asList((Object[])this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "user/search", (Object)nodeSearchCondition, UserTO[].class, new Object[0]));
        return matchedUsers;
    }

    public List<UserTO> paginatedSearchUsers(NodeCond nodeSearchCondition, int page, int size) throws HttpServerErrorException {
        List<Object> matchedUsers = null;
        matchedUsers = Arrays.asList((Object[])this.restClient.getRestTemplate().postForObject(this.restClient.getBaseURL() + "user/paginatedSearch/{page}/{size}", (Object)nodeSearchCondition, UserTO[].class, new Object[]{page, size}));
        return matchedUsers;
    }

    public RestClient getRestClient() {
        return this.restClient;
    }

    public void setRestClient(RestClient restClient) {
        this.restClient = restClient;
    }
}

