/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.Session;
import org.apache.wicket.application.IComponentInstantiationListener;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.authorization.strategies.role.IRoleCheckingStrategy;
import org.apache.wicket.authorization.strategies.role.RoleAuthorizationStrategy;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.spring.injection.annot.SpringComponentInjector;
import org.syncope.console.SyncopeRequestCycle;
import org.syncope.console.SyncopeSession;
import org.syncope.console.commons.XMLRolesReader;
import org.syncope.console.pages.Configuration;
import org.syncope.console.pages.Connectors;
import org.syncope.console.pages.Login;
import org.syncope.console.pages.Logout;
import org.syncope.console.pages.Report;
import org.syncope.console.pages.Resources;
import org.syncope.console.pages.Roles;
import org.syncope.console.pages.Schema;
import org.syncope.console.pages.Tasks;
import org.syncope.console.pages.Users;
import org.syncope.console.pages.WelcomePage;

public class SyncopeApplication
extends WebApplication
implements IUnauthorizedComponentInstantiationListener,
IRoleCheckingStrategy {
    protected void init() {
        this.addComponentInstantiationListener((IComponentInstantiationListener)new SpringComponentInjector((WebApplication)this));
        this.getResourceSettings().setThrowExceptionOnMissingResource(true);
        this.getSecuritySettings().setAuthorizationStrategy((IAuthorizationStrategy)new RoleAuthorizationStrategy((IRoleCheckingStrategy)this));
        this.getSecuritySettings().setUnauthorizedComponentInstantiationListener((IUnauthorizedComponentInstantiationListener)this);
        this.getMarkupSettings().setStripWicketTags(true);
        MetaDataRoleAuthorizationStrategy.authorize(Schema.class, (String)"SCHEMA_LIST");
        MetaDataRoleAuthorizationStrategy.authorize(Roles.class, (String)"ROLE_LIST");
        MetaDataRoleAuthorizationStrategy.authorize(Connectors.class, (String)"CONNECTOR_LIST");
        MetaDataRoleAuthorizationStrategy.authorize(Resources.class, (String)"RESOURCE_LIST");
        MetaDataRoleAuthorizationStrategy.authorize(Users.class, (String)"USER_LIST");
        MetaDataRoleAuthorizationStrategy.authorize(Report.class, (String)"REPORT_LIST");
        MetaDataRoleAuthorizationStrategy.authorize(Tasks.class, (String)"TASK_LIST");
        MetaDataRoleAuthorizationStrategy.authorize(Configuration.class, (String)"CONFIGURATION_LIST");
    }

    public void setupNavigationPane(WebPage page, XMLRolesReader xmlRolesReader) {
        BookmarkablePageLink schemaLink = new BookmarkablePageLink("schema", Schema.class);
        String allowedSchemaRoles = xmlRolesReader.getAllAllowedRoles("Schema", "list");
        MetaDataRoleAuthorizationStrategy.authorize((Component)schemaLink, (Action)WebPage.ENABLE, (String)allowedSchemaRoles);
        page.add(new Component[]{schemaLink});
        BookmarkablePageLink usersLink = new BookmarkablePageLink("users", Users.class);
        String allowedUsersRoles = xmlRolesReader.getAllAllowedRoles("Users", "list");
        MetaDataRoleAuthorizationStrategy.authorize((Component)usersLink, (Action)WebPage.ENABLE, (String)allowedUsersRoles);
        page.add(new Component[]{usersLink});
        BookmarkablePageLink rolesLink = new BookmarkablePageLink("roles", Roles.class);
        String allowedRoleRoles = xmlRolesReader.getAllAllowedRoles("Roles", "list");
        MetaDataRoleAuthorizationStrategy.authorize((Component)rolesLink, (Action)WebPage.ENABLE, (String)allowedRoleRoles);
        page.add(new Component[]{rolesLink});
        BookmarkablePageLink resourcesLink = new BookmarkablePageLink("resources", Resources.class);
        String allowedResourcesRoles = xmlRolesReader.getAllAllowedRoles("Resources", "list");
        MetaDataRoleAuthorizationStrategy.authorize((Component)resourcesLink, (Action)WebPage.ENABLE, (String)allowedResourcesRoles);
        page.add(new Component[]{resourcesLink});
        BookmarkablePageLink connectorsLink = new BookmarkablePageLink("connectors", Connectors.class);
        String allowedConnectorsRoles = xmlRolesReader.getAllAllowedRoles("Connectors", "list");
        MetaDataRoleAuthorizationStrategy.authorize((Component)connectorsLink, (Action)WebPage.ENABLE, (String)allowedConnectorsRoles);
        page.add(new Component[]{connectorsLink});
        BookmarkablePageLink reportLink = new BookmarkablePageLink("report", Report.class);
        String allowedReportRoles = xmlRolesReader.getAllAllowedRoles("Report", "list");
        MetaDataRoleAuthorizationStrategy.authorize((Component)reportLink, (Action)WebPage.ENABLE, (String)allowedReportRoles);
        page.add(new Component[]{reportLink});
        BookmarkablePageLink configurationLink = new BookmarkablePageLink("configuration", Configuration.class);
        String allowedConfigurationRoles = xmlRolesReader.getAllAllowedRoles("Configuration", "list");
        MetaDataRoleAuthorizationStrategy.authorize((Component)configurationLink, (Action)WebPage.ENABLE, (String)allowedConfigurationRoles);
        page.add(new Component[]{configurationLink});
        BookmarkablePageLink taskLink = new BookmarkablePageLink("tasks", Tasks.class);
        String allowedTasksRoles = xmlRolesReader.getAllAllowedRoles("Tasks", "list");
        MetaDataRoleAuthorizationStrategy.authorize((Component)taskLink, (Action)WebPage.ENABLE, (String)allowedTasksRoles);
        page.add(new Component[]{taskLink});
        page.add(new Component[]{new BookmarkablePageLink("logout", Logout.class)});
    }

    public Session newSession(Request request, Response response) {
        return new SyncopeSession(request);
    }

    public Class getHomePage() {
        return SyncopeSession.get().isAuthenticated() ? WelcomePage.class : Login.class;
    }

    public final RequestCycle newRequestCycle(Request request, Response response) {
        return new SyncopeRequestCycle(this, (WebRequest)request, (Response)((WebResponse)response));
    }

    public void onUnauthorizedInstantiation(Component component) {
        SyncopeSession.get().invalidate();
        if (component instanceof Page) {
            throw new UnauthorizedInstantiationException(component.getClass());
        }
        throw new RestartResponseAtInterceptPageException(Login.class);
    }

    public boolean hasAnyRole(org.apache.wicket.authorization.strategies.role.Roles roles) {
        return SyncopeSession.get().hasAnyRole(roles);
    }
}

