/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console;

import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.Response;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.markup.html.pages.ExceptionErrorPage;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.syncope.console.SyncopeSession;
import org.syncope.console.pages.ErrorPage;

public class SyncopeRequestCycle
extends WebRequestCycle {
    public SyncopeRequestCycle(WebApplication application, WebRequest request, Response response) {
        super(application, request, response);
    }

    public final Page onRuntimeException(Page cause, RuntimeException e) {
        ErrorPage errorPage;
        PageParameters errorParameters = new PageParameters();
        errorParameters.add("errorTitle", new StringResourceModel("alert", null).getString());
        if (e instanceof UnauthorizedInstantiationException) {
            errorParameters.add("errorMessage", new StringResourceModel("unauthorizedInstantiationException", null).getString());
            errorPage = new ErrorPage(errorParameters);
        } else if (e instanceof HttpClientErrorException) {
            errorParameters.add("errorMessage", new StringResourceModel("httpClientException", null).getString());
            errorPage = new ErrorPage(errorParameters);
        } else if (e instanceof PageExpiredException || !((SyncopeSession)this.getSession()).isAuthenticated()) {
            errorParameters.add("errorMessage", new StringResourceModel("pageExpiredException", null).getString());
            errorPage = new ErrorPage(errorParameters);
        } else if (e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof RestClientException) {
            errorParameters.add("errorMessage", new StringResourceModel("restClientException", null).getString());
            errorPage = new ErrorPage(errorParameters);
        } else {
            errorPage = new ExceptionErrorPage((Throwable)e, cause);
        }
        return errorPage;
    }
}

